/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.SVF12dB;

public class LowShelf12dB {
    private final SVF12dB svf;
    private double gain = 1.0;
    private double gain2 = Math.sqrt(2.0);

    public LowShelf12dB(double fs) {
        this.svf = new SVF12dB(fs);
        this.svf.setRawQ(Math.sqrt(2.0));
        this.setCutoff(fs * 0.1);
    }

    public void setCutoff(double cutoff) {
        this.svf.setCutoff(cutoff);
    }

    public void setGain(double db) {
        this.gain = Math.pow(10.0, db / 20.0);
        this.gain2 = Math.sqrt(2.0 * this.gain);
    }

    public LowShelf12dB setClipper(Clipper clipper) {
        this.svf.setClipper(clipper);
        return this;
    }

    public double process(double input) {
        this.svf.process(input);
        return this.svf.high() + this.gain2 * this.svf.band() + this.gain * this.svf.low();
    }
}

