/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;

public class SVF18dB {
    private final double fs;
    private double b0;
    private double b1;
    private double b2;
    private double f;
    private double fB0;
    private double fB1;
    private double fC0;
    private double fC1;
    private double fD0;
    private double a;
    private double b;
    private double c;
    private double r;
    private double ar;
    private double br;
    private double A;
    private double B;
    private double C;
    private double D;
    private Clipper clipper = new DefaultClipper();

    public SVF18dB(double fs) {
        this.fs = fs;
        this.setButterworthResponse();
    }

    public SVF18dB setCoefficients(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.recalc();
        return this;
    }

    public SVF18dB setButterworthResponse() {
        return this.setCoefficients(2.0, 2.0, 1.0);
    }

    public SVF18dB setLadderResponse() {
        return this.setCoefficients(3.0, 3.0, 1.0);
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
        this.recalc();
    }

    public void setQ(double q) {
        this.r = q;
        this.recalc();
    }

    public void reset() {
        this.b2 = 0.0;
        this.b1 = 0.0;
        this.b0 = 0.0;
    }

    public SVF18dB setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    private void recalc() {
        double rq = 1.0 + this.r;
        this.ar = this.a / rq;
        this.br = this.b / rq;
        this.fB0 = 1.0 / (1.0 + this.f * this.ar);
        this.fB1 = this.f * this.fB0;
        this.fC0 = 1.0 / (1.0 + this.fB1 * this.f * this.br);
        this.fC1 = this.f * this.fC0;
        this.fD0 = 1.0 / (1.0 + this.fC1 * this.fB1 * this.f * this.c);
    }

    public double low() {
        return this.D;
    }

    public double lowBand() {
        return this.C;
    }

    public double highBand() {
        return this.B;
    }

    public double high() {
        return this.A;
    }

    public SVF18dB process(double input) {
        this.D = (this.b2 + this.fC1 * (this.b1 + this.fB1 * (this.b0 + this.f * input))) * this.fD0;
        double temp = input - this.c * this.D;
        this.C = (this.b1 + this.fB1 * (this.b0 + this.f * temp)) * this.fC0;
        this.B = (this.b0 + this.f * (temp -= this.br * this.C)) * this.fB0;
        this.A = temp - this.ar * this.B;
        this.b2 = this.clipper.clip(this.D + this.f * this.C);
        this.b1 = this.clipper.clip(this.C + this.f * this.B);
        this.b0 = this.clipper.clip(this.B + this.f * this.A);
        return this;
    }
}

