/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.math.CatmullRomSpline;

public class TubeCompress {
    private final CatmullRomSpline spline;
    private final double bp;
    private final double m1;
    private final double tp0;
    private final double tp1;
    private final double rtw;

    public TubeCompress(double bp, double tw, double m1) {
        this.bp = bp;
        this.m1 = m1;
        double tw2 = tw * 0.5;
        this.tp0 = bp - tw2;
        this.tp1 = bp + tw2;
        this.rtw = 1.0 / tw;
        double v2 = 1.0 + m1 * tw2;
        double v3 = 1.0 + m1 * (tw + tw2);
        this.spline = new CatmullRomSpline(1.0, 1.0, v2, v3);
    }

    public double get(double in) {
        double i = Math.abs(in);
        if (i < this.tp0) {
            return 1.0;
        }
        if (i < this.tp1) {
            return this.spline.get((i - this.tp0) * this.rtw);
        }
        return (i - this.bp) * this.m1 + 1.0;
    }

    public double process(double in) {
        return in / this.get(in);
    }
}

