/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import java.util.Arrays;

public class FilterKernel {
    final float[] xf;
    final float[] yf;
    final float[] xyf;
    public final int width;
    public final int height;
    final int offsx;
    final int offsy;
    final boolean isSingle;

    public FilterKernel(float[] kernel, int width, int height, int offsx, int offsy) {
        this.xf = null;
        this.yf = null;
        this.xyf = Arrays.copyOf(kernel, width * height);
        this.width = width;
        this.height = height;
        this.offsx = offsx;
        this.offsy = offsy;
        this.isSingle = true;
    }

    public FilterKernel(float[] kernelx, float[] kernely, int width, int height, int offsx, int offsy) {
        this.xf = Arrays.copyOf(kernelx, width);
        this.yf = Arrays.copyOf(kernely, height);
        this.xyf = null;
        this.width = width;
        this.height = height;
        this.offsx = offsx;
        this.offsy = offsy;
        this.isSingle = false;
    }

    public FilterKernel normalize() {
        block8: {
            int y;
            block7: {
                int i;
                if (!this.isSingle) break block7;
                double sum = 0.0;
                for (i = 0; i < this.xyf.length; ++i) {
                    sum += (double)this.xyf[i];
                }
                if (sum == 0.0) break block8;
                i = 0;
                while (i < this.xyf.length) {
                    int n = i++;
                    this.xyf[n] = (float)((double)this.xyf[n] / sum);
                }
                break block8;
            }
            double sum = 0.0;
            for (y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    sum += (double)(this.xf[x] * this.yf[y]);
                }
            }
            if (sum != 0.0) {
                y = 0;
                while (y < this.height) {
                    int n = y++;
                    this.yf[n] = (float)((double)this.yf[n] / sum);
                }
                int x = 0;
                while (x < this.width) {
                    int n = x++;
                    this.xf[n] = (float)((double)this.xf[n] / sum);
                }
            }
        }
        return this;
    }
}

