/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.math.NMath;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class WrappedImage {
    private int width;
    private int height;
    private BufferedImage image;
    private int[] pixels;
    private final boolean hasTransparency;

    public WrappedImage(int width, int height, boolean hasTransparency) {
        this.hasTransparency = hasTransparency;
        this.alloc(width, height);
    }

    public WrappedImage(int width, int height) {
        this(width, height, false);
    }

    public WrappedImage(BufferedImage image, boolean hasTransparency) {
        this.image = WrappedImage.sanitize(image, hasTransparency);
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        this.hasTransparency = hasTransparency;
    }

    public static final BufferedImage sanitize(BufferedImage image, boolean hasTransparency) {
        BufferedImage ret;
        if (hasTransparency) {
            if (image.getType() == 2) {
                return image;
            }
            ret = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        } else {
            if (image.getType() == 1) {
                return image;
            }
            ret = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        }
        ret.createGraphics().drawImage((Image)image, 0, 0, null);
        return ret;
    }

    private void alloc(int width, int height) {
        int w = Math.max(1, width);
        int h = Math.max(1, height);
        if (this.image == null || this.width != w || this.height != h) {
            this.width = w;
            this.height = h;
            this.image = new BufferedImage(w, h, this.hasTransparency ? 2 : 1);
            this.pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        }
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public void resize(int width, int height) {
        this.alloc(width, height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getPixel(int x, int y) {
        return this.pixels[NMath.clamp(x, 0, this.width - 1) + NMath.clamp(y, 0, this.height - 1) * this.width];
    }

    public void setPixel(int x, int y, int c) {
        this.pixels[NMath.clamp((int)x, (int)0, (int)(this.width - 1)) + NMath.clamp((int)y, (int)0, (int)(this.height - 1)) * this.width] = c;
    }

    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    public Graphics2D createGraphicsClipped() {
        Graphics2D g = this.image.createGraphics();
        g.setClip(0, 0, this.width, this.height);
        return g;
    }

    public Graphics2D createGraphicsClipped(int tx, int ty, int clipWidth, int clipHeight) {
        Graphics2D g = this.image.createGraphics();
        g.translate(tx, ty);
        g.setClip(0, 0, clipWidth, clipHeight);
        return g;
    }

    public static WrappedImage fromFile(File file, boolean hasTransparency) throws IOException {
        return new WrappedImage(ImageIO.read(file), hasTransparency);
    }

    public static WrappedImage fromFile(String filename, boolean hasTransparency) throws IOException {
        return WrappedImage.fromFile(new File(filename), hasTransparency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrappedImage fromResource(String resourcename, boolean hasTransparency) throws IOException {
        try (InputStream in = null;){
            WrappedImage img;
            in = WrappedImage.class.getResourceAsStream(resourcename);
            WrappedImage wrappedImage = img = new WrappedImage(ImageIO.read(in), hasTransparency);
            return wrappedImage;
        }
    }
}

