/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.WrappedCheckedException;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import com.github.rjeschke.neetutils.math.Numbers;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ReaderIterator
extends AbstractXIterable<Character>
implements AutoCloseable {
    final Reader in;
    boolean closed = false;
    volatile boolean iteratorInUse = false;
    int current;

    public ReaderIterator(Reader in) {
        this.in = in;
        this.current = this.read();
    }

    int read() {
        if (this.closed) {
            this.current = -1;
            return -1;
        }
        try {
            this.current = this.in.read();
            if (this.current == -1) {
                this.in.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            this.current = -1;
            try {
                this.in.close();
                this.closed = true;
            }
            catch (IOException e1) {
                throw new WrappedCheckedException(e);
            }
        }
        return this.current;
    }

    @Override
    public synchronized Iterator<Character> iterator() {
        if (this.iteratorInUse) {
            throw new IllegalStateException("An iterator is already in use");
        }
        return new StreamIterator(this);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.closed = true;
        this.current = -1;
    }

    private class StreamIterator
    implements Iterator<Character> {
        final ReaderIterator ri;

        public StreamIterator(ReaderIterator ri) {
            this.ri = ri;
        }

        @Override
        public boolean hasNext() {
            return this.ri.current != -1;
        }

        @Override
        public Character next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Trying to read past end of stream");
            }
            Character ret = Numbers.characterOf((char)this.ri.current);
            this.ri.read();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can not remove characters from an InputStream");
        }
    }
}

