/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.io;

import com.github.rjeschke.neetutils.io.LineReaderIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public final class Streams {
    public static final String UTF8 = "UTF-8";

    private Streams() {
    }

    public static final boolean close(Closeable closable) {
        try {
            closable.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean flush(Flushable flushable) {
        try {
            flushable.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean flushAndClose(OutputStream out) {
        boolean ret = Streams.flush(out);
        return ret |= Streams.close(out);
    }

    public static final BufferedReader newBufferedReader(InputStream in, String charsetName) throws IOException {
        return new BufferedReader(new InputStreamReader(in, charsetName));
    }

    public static final BufferedReader newBufferedReader(InputStream in) throws IOException {
        return Streams.newBufferedReader(in, UTF8);
    }

    public static final BufferedReader newBufferedReader(String filename, String charsetName) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charsetName));
    }

    public static final BufferedReader newBufferedReader(String filename) throws IOException {
        return Streams.newBufferedReader(filename, UTF8);
    }

    public static final BufferedReader newBufferedReader(File file, String charsetName) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
    }

    public static final BufferedReader newBufferedReader(File file) throws IOException {
        return Streams.newBufferedReader(file, UTF8);
    }

    public static final LineReaderIterator newLineReaderIterator(InputStream in, String charsetName) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(in, charsetName));
    }

    public static final LineReaderIterator newLineReaderIterator(InputStream in) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(in));
    }

    public static final LineReaderIterator newLineReaderIterator(File file, String charsetName) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(file, charsetName));
    }

    public static final LineReaderIterator newLineReaderIterator(File file) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(file));
    }

    public static final LineReaderIterator newLineReaderIterator(String filename, String charsetName) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(filename, charsetName));
    }

    public static final LineReaderIterator newLineReaderIterator(String filename) throws IOException {
        return new LineReaderIterator(Streams.newBufferedReader(filename));
    }

    public static final BufferedInputStream newBufferedInputStream(String filename) throws IOException {
        return new BufferedInputStream(new FileInputStream(filename));
    }

    public static final BufferedInputStream newBufferedInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static final BufferedOutputStream newBufferedOutputStream(String filename) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(filename));
    }

    public static final BufferedOutputStream newBufferedOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }
}

