/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class XIterableTake<A>
extends AbstractXIterable<A> {
    private final Iterable<A> iterable;
    private final int amount;

    public XIterableTake(Iterable<A> iterable, int amount) {
        this.iterable = iterable;
        this.amount = amount;
    }

    @Override
    public Iterator<A> iterator() {
        return new XIterator<A>(this.iterable.iterator(), this.amount);
    }

    private static final class XIterator<A>
    implements Iterator<A> {
        private final Iterator<A> iterator;
        private final int amount;
        private int count;
        private A element;
        private boolean hasElement;

        public XIterator(Iterator<A> iterator, int amount) {
            this.iterator = iterator;
            this.amount = amount;
        }

        @Override
        public boolean hasNext() {
            if (this.hasElement) {
                return true;
            }
            if (this.iterator.hasNext() && this.count < this.amount) {
                ++this.count;
                this.element = this.iterator.next();
                this.hasElement = true;
            }
            return this.hasElement;
        }

        @Override
        public A next() {
            if (!this.hasElement) {
                throw new NoSuchElementException();
            }
            A e = this.element;
            this.hasElement = false;
            return e;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

