/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.lists;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.RandomAccess;

public class FloatList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 772847916894881877L;
    private static final transient int INIT_SIZE = 16;
    private transient float[] data;
    private int size;
    private transient int maxSize;

    public FloatList() {
        this(16);
    }

    public FloatList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must not be less than 0");
        }
        this.maxSize = initialCapacity;
        this.size = 0;
        this.data = new float[initialCapacity];
    }

    public static FloatList fromArray(float ... values) {
        FloatList list = new FloatList(values.length);
        System.arraycopy(values, 0, list.data, 0, values.length);
        list.size = values.length;
        return list;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.maxSize > this.size) {
            this.maxSize = this.size;
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public float add(float v) {
        this.grow(this.size + 1);
        float f = v;
        this.data[this.size++] = f;
        return f;
    }

    public float add(int index, float v) {
        if (index == this.size) {
            return this.add(v);
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.grow(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = v;
        ++this.size;
        return v;
    }

    public float remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        float old = this.data[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        return old;
    }

    public float set(int index, float v) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = v;
        return this.data[index];
    }

    public float get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public float[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public boolean contains(float v) {
        return this.indexOf(v) != -1;
    }

    public int indexOf(float v) {
        for (int i = 0; i < this.size; ++i) {
            if (v != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float v) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (v != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (this.size > 0) {
            sb.append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                sb.append(',');
                sb.append(this.data[i]);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size; ++i) {
            hash = hash * 31 + Float.floatToIntBits(this.data[i]);
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FloatList)) {
            return false;
        }
        FloatList list = (FloatList)other;
        if (list.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == list.data[i]) continue;
            return false;
        }
        return true;
    }

    public FloatList clone() {
        FloatList list = new FloatList(this.size);
        list.size = this.size;
        System.arraycopy(this.data, 0, list.data, 0, this.size);
        return list;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            out.writeFloat(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.maxSize = this.size;
        this.data = new float[this.maxSize];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = in.readFloat();
        }
    }

    private void grow(int required) {
        if (required > this.maxSize) {
            this.maxSize = (this.maxSize * 3 >>> 1) + 1;
            this.data = Arrays.copyOf(this.data, this.maxSize);
        }
    }
}

