/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.lists;

import com.github.rjeschke.neetutils.math.NMath;
import java.util.Arrays;

public class IntList2 {
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private Block[] blkmap = new Block[1];
    private int bpos = 0;
    private int spos = 0;
    private int size = 0;
    private final int blkSize;
    private final int blkMask;
    private final int shift;

    public IntList2() {
        this(32768);
    }

    public IntList2(int blkSize) {
        this.blkSize = NMath.nextPow2(blkSize);
        this.blkMask = this.blkSize - 1;
        this.shift = (int)(Math.log(this.blkSize) / Math.log(2.0));
        this.blkmap[0] = new Block(this.blkSize);
    }

    public int size() {
        return this.size;
    }

    public void add(int value) {
        if (this.spos == this.blkSize) {
            this.spos = 0;
            ++this.bpos;
            if (this.bpos == this.blkmap.length) {
                this.blkmap = Arrays.copyOf(this.blkmap, this.blkmap.length << 1);
            }
            this.blkmap[this.bpos] = new Block(this.blkSize);
        }
        ++this.size;
        this.blkmap[this.bpos].d[this.spos++] = value;
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Got " + index + ", range is [0, " + this.size + "[");
        }
        this.blkmap[index >>> this.shift].d[index & this.blkMask] = value;
    }

    public int getAndSet(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Got " + index + ", range is [0, " + this.size + "[");
        }
        int ret = this.blkmap[index >>> this.shift].d[index & this.blkMask];
        this.blkmap[index >>> this.shift].d[index & this.blkMask] = value;
        return ret;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Got " + index + ", range is [0, " + this.size + "[");
        }
        return this.blkmap[index >>> this.shift].d[index & this.blkMask];
    }

    public int[] toArray() {
        int[] arr = new int[this.size];
        int left = this.size;
        int n = 0;
        while (left > 0) {
            int todo = Math.min(left, this.blkSize);
            System.arraycopy(this.blkmap[n].d, 0, arr, this.size - left, todo);
            left -= todo;
            ++n;
        }
        return arr;
    }

    private static final class Block {
        public final int[] d;

        public Block(int size) {
            this.d = new int[size];
        }
    }
}

