/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.math;

public final class Numbers {
    private static final Integer[] integerCache;
    private static final Character[] characterCache;
    private static final int maxIntCache;
    private static final boolean hasCharacterCache;

    private Numbers() {
    }

    public static final Integer integerOf(int value) {
        return value > -129 && value < maxIntCache ? integerCache[value + 128] : Integer.valueOf(value);
    }

    public static final Character characterOf(char value) {
        return hasCharacterCache ? characterCache[value] : Character.valueOf(value);
    }

    public static final Type getType(Number a) {
        if (a instanceof Byte) {
            return Type.BYTE;
        }
        if (a instanceof Short) {
            return Type.SHORT;
        }
        if (a instanceof Integer) {
            return Type.INT;
        }
        if (a instanceof Long) {
            return Type.LONG;
        }
        if (a instanceof Float) {
            return Type.FLOAT;
        }
        if (a instanceof Double) {
            return Type.DOUBLE;
        }
        throw new ArithmeticException("Unsupported number type: " + a);
    }

    private static final Type getLargerType(Number a, Number b) {
        Type ta = Numbers.getType(a);
        Type tb = Numbers.getType(b);
        return tb.size > ta.size ? tb : ta;
    }

    public static final Number add(Number a, Number b) {
        switch (Numbers.getLargerType(a, b)) {
            case BYTE: {
                return (byte)(a.byteValue() + b.byteValue());
            }
            case SHORT: {
                return (short)(a.shortValue() + b.shortValue());
            }
            case INT: {
                return Numbers.integerOf(a.intValue() + b.intValue());
            }
            case LONG: {
                return a.longValue() + b.longValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }
            case DOUBLE: {
                return a.doubleValue() + b.doubleValue();
            }
        }
        return null;
    }

    public static final Number sub(Number a, Number b) {
        switch (Numbers.getLargerType(a, b)) {
            case BYTE: {
                return (byte)(a.byteValue() - b.byteValue());
            }
            case SHORT: {
                return (short)(a.shortValue() - b.shortValue());
            }
            case INT: {
                return Numbers.integerOf(a.intValue() - b.intValue());
            }
            case LONG: {
                return a.longValue() - b.longValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() - b.floatValue());
            }
            case DOUBLE: {
                return a.doubleValue() - b.doubleValue();
            }
        }
        return null;
    }

    public static final Number mul(Number a, Number b) {
        switch (Numbers.getLargerType(a, b)) {
            case BYTE: {
                return (byte)(a.byteValue() * b.byteValue());
            }
            case SHORT: {
                return (short)(a.shortValue() * b.shortValue());
            }
            case INT: {
                return Numbers.integerOf(a.intValue() * b.intValue());
            }
            case LONG: {
                return a.longValue() * b.longValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }
            case DOUBLE: {
                return a.doubleValue() * b.doubleValue();
            }
        }
        return null;
    }

    public static final Number div(Number a, Number b) {
        switch (Numbers.getLargerType(a, b)) {
            case BYTE: {
                return (byte)(a.byteValue() / b.byteValue());
            }
            case SHORT: {
                return (short)(a.shortValue() / b.shortValue());
            }
            case INT: {
                return Numbers.integerOf(a.intValue() / b.intValue());
            }
            case LONG: {
                return a.longValue() / b.longValue();
            }
            case FLOAT: {
                return Float.valueOf(a.floatValue() / b.floatValue());
            }
            case DOUBLE: {
                return a.doubleValue() / b.doubleValue();
            }
        }
        return null;
    }

    static {
        int i;
        maxIntCache = System.getProperty("com.github.rjeschke.neetutils.smallIntegerCache") != null ? 256 : 65536;
        hasCharacterCache = System.getProperty("com.github.rjeschke.neetutils.noCharacterCache") == null;
        integerCache = new Integer[128 + maxIntCache];
        for (i = -128; i < maxIntCache; ++i) {
            Numbers.integerCache[i + 128] = i;
        }
        if (hasCharacterCache) {
            characterCache = new Character[65536];
            for (i = 0; i < 65536; ++i) {
                Numbers.characterCache[i] = Character.valueOf((char)i);
            }
        } else {
            characterCache = null;
        }
    }

    public static enum Type {
        BYTE(0),
        SHORT(1),
        INT(2),
        LONG(3),
        FLOAT(4),
        DOUBLE(5);

        public final int size;

        private Type(int size) {
            this.size = size;
        }
    }
}

