/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.vectors.Vector3i;
import com.github.rjeschke.neetutils.vectors.Vector4i;
import java.nio.IntBuffer;

public class Vector2i {
    public int x;
    public int y;

    public Vector2i() {
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vector2i(int xy) {
        this.x = xy;
        this.y = xy;
    }

    public Vector2i(Vector2i v) {
        this.x = v.x;
        this.y = v.y;
    }

    public static Vector2i of(int x, int y) {
        return new Vector2i(x, y);
    }

    public static Vector2i of(Vector2i v) {
        return new Vector2i(v);
    }

    public Vector2i set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2i set(int xy) {
        this.x = xy;
        this.y = xy;
        return this;
    }

    public Vector2i set(Vector2i v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2i set(Vector3i v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2i set(Vector4i v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vector2i setIdx(int index, int value) {
        if (index == 0) {
            this.x = value;
        } else {
            this.y = value;
        }
        return this;
    }

    public int get(int index) {
        if (index == 0) {
            return this.x;
        }
        return this.y;
    }

    public Vector2i add(Vector2i v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vector2i sub(Vector2i v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vector2i mul(Vector2i v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public Vector2i div(Vector2i v) {
        this.x /= v.x;
        this.y /= v.y;
        return this;
    }

    public Vector2i min(Vector2i v) {
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        return this;
    }

    public Vector2i max(Vector2i v) {
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        return this;
    }

    public Vector2i clamp(Vector2i min, Vector2i max) {
        this.x = NMath.clamp(this.x, min.x, max.x);
        this.y = NMath.clamp(this.y, min.y, max.y);
        return this;
    }

    public Vector2i swizzle(int a, int b) {
        return Vector2i.of(this.get(a), this.get(b));
    }

    public Vector3i swizzle(int a, int b, int c) {
        return Vector3i.of(this.get(a), this.get(b), this.get(c));
    }

    public Vector4i swizzle(int a, int b, int c, int d) {
        return Vector4i.of(this.get(a), this.get(b), this.get(c), this.get(d));
    }

    public void into(int[] arr, int offset) {
        arr[offset] = this.x;
        arr[offset + 1] = this.y;
    }

    public void into(IntBuffer buffer, int offset) {
        buffer.put(offset, this.x);
        buffer.put(offset + 1, this.y);
    }

    public Vector2i clone() {
        return new Vector2i(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

