/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.af;
import com.google.android.gms.analytics.ai;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.f;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.l;
import com.google.android.gms.analytics.r;
import com.google.android.gms.analytics.t;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.v;
import com.google.android.gms.analytics.w;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleAnalytics
extends TrackerHandler {
    private static boolean tB;
    private boolean tC;
    private f rk;
    private af tD;
    private Context mContext;
    private volatile Boolean tE = false;
    private Logger tF;
    private String qS;
    private String qR;
    private Set<a> tG;
    private boolean tH = false;
    private static GoogleAnalytics tI;

    protected GoogleAnalytics(Context context) {
        this(context, t.q(context), r.bB());
    }

    private GoogleAnalytics(Context context, f thread, af serviceManager) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.rk = thread;
        this.tD = serviceManager;
        g.n(this.mContext);
        ae.n(this.mContext);
        h.n(this.mContext);
        this.tF = new l();
        this.tG = new HashSet<a>();
        this.cg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleAnalytics getInstance(Context context) {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (tI == null) {
                tI = new GoogleAnalytics(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GoogleAnalytics cf() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return tI;
        }
    }

    private void cg() {
        w w2;
        int n2;
        if (tB) {
            return;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 129);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            aa.v("PackageManager doesn't know about package: " + (Object)((Object)nameNotFoundException));
        }
        if (applicationInfo == null) {
            aa.w("Couldn't get ApplicationInfo to load gloabl config.");
            return;
        }
        Bundle bundle = applicationInfo.metaData;
        if (bundle != null && (n2 = bundle.getInt("com.google.android.gms.analytics.globalConfigResource")) > 0 && (w2 = (w)new v(this.mContext).p(n2)) != null) {
            this.a(w2);
        }
    }

    void a(w w2) {
        int n2;
        aa.v("Loading global config values.");
        if (w2.bV()) {
            this.qR = w2.bW();
            aa.v("app name loaded: " + this.qR);
        }
        if (w2.bX()) {
            this.qS = w2.bY();
            aa.v("app version loaded: " + this.qS);
        }
        if (w2.bZ() && (n2 = this.D(w2.ca())) >= 0) {
            aa.v("log level loaded: " + n2);
            this.getLogger().setLogLevel(n2);
        }
        if (w2.cb()) {
            this.tD.setLocalDispatchPeriod(w2.cc());
        }
        if (w2.cd()) {
            this.setDryRun(w2.ce());
        }
    }

    private int D(String string2) {
        String string3 = string2.toLowerCase();
        if ("verbose".equals(string3)) {
            return 0;
        }
        if ("info".equals(string3)) {
            return 1;
        }
        if ("warning".equals(string3)) {
            return 2;
        }
        if ("error".equals(string3)) {
            return 3;
        }
        return -1;
    }

    public void setDryRun(boolean dryRun) {
        u.bR().a(u.a.tn);
        this.tC = dryRun;
    }

    public boolean isDryRunEnabled() {
        u.bR().a(u.a.to);
        return this.tC;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.tH) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new b());
            this.tH = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.tH) {
            this.d(activity);
        }
    }

    private void d(Activity activity) {
        for (a a2 : this.tG) {
            a2.f(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.tH) {
            this.e(activity);
        }
    }

    private void e(Activity activity) {
        for (a a2 : this.tG) {
            a2.g(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            u.bR().a(u.a.sY);
            return this.a(new Tracker(trackingId, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            aj aj2;
            u.bR().a(u.a.sY);
            Tracker tracker = new Tracker(null, this);
            if (configResId > 0 && (aj2 = (aj)new ai(this.mContext).p(configResId)) != null) {
                tracker.a(this.mContext, aj2);
            }
            return this.a(tracker);
        }
    }

    private Tracker a(Tracker tracker) {
        if (this.qR != null) {
            tracker.set("&an", this.qR);
        }
        if (this.qS != null) {
            tracker.set("&av", this.qS);
        }
        return tracker;
    }

    void a(a a2) {
        this.tG.add(a2);
    }

    void b(a a2) {
        this.tG.remove(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void n(Map<String, String> map) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            if (map == null) {
                throw new IllegalArgumentException("hit cannot be null");
            }
            ak.a(map, "&ul", ak.a(Locale.getDefault()));
            ak.a(map, "&sr", ae.cs().getValue("&sr"));
            map.put("&_u", u.bR().bT());
            u.bR().bS();
            this.rk.n(map);
        }
    }

    public void setAppOptOut(boolean optOut) {
        u.bR().a(u.a.tb);
        this.tE = optOut;
        if (this.tE.booleanValue()) {
            this.rk.bk();
        }
    }

    public boolean getAppOptOut() {
        u.bR().a(u.a.tc);
        return this.tE;
    }

    public Logger getLogger() {
        return this.tF;
    }

    public void setLogger(Logger logger) {
        u.bR().a(u.a.tp);
        this.tF = logger;
    }

    @Deprecated
    public void dispatchLocalHits() {
        this.tD.dispatchLocalHits();
    }

    @Deprecated
    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.tD.setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    class b
    implements Application.ActivityLifecycleCallbacks {
        b() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.d(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.e(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface a {
        public void f(Activity var1);

        public void g(Activity var1);
    }
}

