/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int wj;
    private Boolean Pc;
    private Boolean Pd;
    private int Pe = -1;
    private CameraPosition Pf;
    private Boolean Pg;
    private Boolean Ph;
    private Boolean Pi;
    private Boolean Pj;
    private Boolean Pk;
    private Boolean Pl;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.wj = versionCode;
        this.Pc = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.Pd = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.Pe = mapType;
        this.Pf = camera;
        this.Pg = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.Ph = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.Pi = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.Pj = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.Pk = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.Pl = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.hc()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.wj;
    }

    byte gN() {
        return com.google.android.gms.maps.internal.a.c(this.Pc);
    }

    byte gO() {
        return com.google.android.gms.maps.internal.a.c(this.Pd);
    }

    byte gP() {
        return com.google.android.gms.maps.internal.a.c(this.Pg);
    }

    byte gQ() {
        return com.google.android.gms.maps.internal.a.c(this.Ph);
    }

    byte gR() {
        return com.google.android.gms.maps.internal.a.c(this.Pi);
    }

    byte gS() {
        return com.google.android.gms.maps.internal.a.c(this.Pj);
    }

    byte gT() {
        return com.google.android.gms.maps.internal.a.c(this.Pk);
    }

    byte gU() {
        return com.google.android.gms.maps.internal.a.c(this.Pl);
    }

    public GoogleMapOptions() {
        this.wj = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.Pc = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.Pd = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.Pe = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.Pf = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.Pg = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.Ph = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.Pi = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.Pj = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.Pk = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.Pl = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.Pc;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.Pd;
    }

    public int getMapType() {
        return this.Pe;
    }

    public CameraPosition getCamera() {
        return this.Pf;
    }

    public Boolean getZoomControlsEnabled() {
        return this.Pg;
    }

    public Boolean getCompassEnabled() {
        return this.Ph;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.Pi;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.Pj;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.Pk;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.Pl;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

