/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fn;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ak;
import com.google.android.gms.tagmanager.bh;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class v
implements DataLayer.c {
    private static final String UD = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' STRING NOT NULL, '%s' BLOB NOT NULL, '%s' INTEGER NOT NULL);", "datalayer", "ID", "key", "value", "expires");
    private final Executor UE;
    private final Context mContext;
    private a UF;
    private fl Ty;
    private int UG;

    public v(Context context) {
        this(context, fn.eI(), "google_tagmanager.db", 2000, Executors.newSingleThreadExecutor());
    }

    v(Context context, fl fl2, String string, int n2, Executor executor) {
        this.mContext = context;
        this.Ty = fl2;
        this.UG = n2;
        this.UE = executor;
        this.UF = new a(this.mContext, string);
    }

    @Override
    public void a(List<DataLayer.a> list, final long l2) {
        final List<b> list2 = this.d(list);
        this.UE.execute(new Runnable(){

            public void run() {
                v.this.b(list2, l2);
            }
        });
    }

    @Override
    public void a(final DataLayer.c.a a2) {
        this.UE.execute(new Runnable(){

            public void run() {
                a2.b(v.this.iT());
            }
        });
    }

    @Override
    public void bi(final String string) {
        this.UE.execute(new Runnable(){

            public void run() {
                v.this.bj(string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataLayer.a> iT() {
        try {
            this.t(this.Ty.currentTimeMillis());
            List<DataLayer.a> list = this.c(this.iU());
            return list;
        }
        finally {
            this.iW();
        }
    }

    private List<DataLayer.a> c(List<b> list) {
        ArrayList<DataLayer.a> arrayList = new ArrayList<DataLayer.a>();
        for (b b2 : list) {
            arrayList.add(new DataLayer.a(b2.UA, this.j(b2.UM)));
        }
        return arrayList;
    }

    private List<b> d(List<DataLayer.a> list) {
        ArrayList<b> arrayList = new ArrayList<b>();
        for (DataLayer.a a2 : list) {
            arrayList.add(new b(a2.UA, this.j(a2.UB)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object j(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException iOException) {
            Object var5_8 = null;
            return var5_8;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] j(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void b(List<b> list, long l2) {
        try {
            long l3 = this.Ty.currentTimeMillis();
            this.t(l3);
            this.bQ(list.size());
            this.c(list, l3 + l2);
        }
        finally {
            this.iW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<b> iU() {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for loadSerialized.");
        ArrayList<b> arrayList = new ArrayList<b>();
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        String[] stringArray = new String[]{"key", "value"};
        Cursor cursor = sQLiteDatabase.query("datalayer", stringArray, null, null, null, null, "ID", null);
        try {
            while (cursor.moveToNext()) {
                arrayList.add(new b(cursor.getString(0), cursor.getBlob(1)));
            }
        }
        finally {
            cursor.close();
        }
        return arrayList;
    }

    private void c(List<b> list, long l2) {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for writeEntryToDatabase.");
        if (sQLiteDatabase == null) {
            return;
        }
        for (b b2 : list) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("expires", Long.valueOf(l2));
            contentValues.put("key", b2.UA);
            contentValues.put("value", b2.UM);
            sQLiteDatabase.insert("datalayer", null, contentValues);
        }
    }

    private void bQ(int n2) {
        int n3 = this.iV() - this.UG + n2;
        if (n3 > 0) {
            List<String> list = this.bR(n3);
            bh.u("DataLayer store full, deleting " + list.size() + " entries to make room.");
            this.g(list.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bj(String string) {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for clearKeysWithPrefix.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n2 = sQLiteDatabase.delete("datalayer", "key = ? OR key LIKE ?", new String[]{string, string + ".%"});
            bh.v("Cleared " + n2 + " items");
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error deleting entries with key prefix: " + string + " (" + (Object)((Object)sQLiteException) + ").");
        }
        finally {
            this.iW();
        }
    }

    private void t(long l2) {
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for deleteOlderThan.");
        if (sQLiteDatabase == null) {
            return;
        }
        try {
            int n2 = sQLiteDatabase.delete("datalayer", "expires <= ?", new String[]{Long.toString(l2)});
            bh.v("Deleted " + n2 + " expired items");
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error deleting old entries.");
        }
    }

    private void g(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for deleteEntries.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("%s in (%s)", "ID", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("datalayer", string, stringArray);
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error deleting entries " + Arrays.toString(stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> bR(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            bh.w("Invalid maxEntries specified. Skipping.");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for peekEntryIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("datalayer", new String[]{"ID"}, null, null, null, null, String.format("%s ASC", "ID"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error in peekEntries fetching entryIds: " + sQLiteException.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int iV() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.G("Error opening database for getNumStoredEntries.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from datalayer", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException sQLiteException) {
            bh.w("Error getting numStoredEntries");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n2;
    }

    private SQLiteDatabase G(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.UF.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            bh.w(string);
            return null;
        }
        return sQLiteDatabase;
    }

    private void iW() {
        try {
            this.UF.close();
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
    }

    private static class b {
        final String UA;
        final byte[] UM;

        b(String string, byte[] byArray) {
            this.UA = string;
            this.UM = byArray;
        }

        public String toString() {
            return "KeyAndSerialized: key = " + this.UA + " serialized hash = " + Arrays.hashCode(this.UM);
        }
    }

    class a
    extends SQLiteOpenHelper {
        a(Context context, String string) {
            super(context, string, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string, SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
            catch (SQLiteException sQLiteException) {
                bh.w("Error querying for table " + string);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            SQLiteDatabase sQLiteDatabase = null;
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                v.this.mContext.getDatabasePath("google_tagmanager.db").delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.a("datalayer", db2)) {
                db2.execSQL(UD);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM datalayer WHERE 0", null);
            HashSet<String> hashSet = new HashSet<String>();
            try {
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            finally {
                cursor.close();
            }
            if (!(hashSet.remove("key") && hashSet.remove("value") && hashSet.remove("ID") && hashSet.remove("expires"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            ak.B(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

