/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.c;
import com.google.android.gms.common.api.d;
import com.google.android.gms.internal.gz;
import com.google.android.gms.internal.hn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, T extends a.b<? extends Result, A>> T a(T var1);

    public <A extends Api.a, T extends a.b<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public void stopAutoManage();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String yN;
        private final Set<String> DE = new HashSet<String>();
        private int DF;
        private View DG;
        private String DH;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> DI = new HashMap();
        private FragmentActivity DJ;
        private OnConnectionFailedListener DK;
        private Looper DC;
        private final Set<ConnectionCallbacks> DL = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> DM = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.DC = context.getMainLooper();
            this.DH = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            hn.b(connectedListener, (Object)"Must provide a connected listener");
            this.DL.add(connectedListener);
            hn.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.DM.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            hn.b(handler, (Object)"Handler must not be null");
            this.DC = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.DL.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.DM.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.DG = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.DE.add(scope.eK());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.DI.put(api, null);
            List<Scope> list = api.ev();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.DE.add(list.get(i2).eK());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            hn.b(options, (Object)"Null options are not permitted for this Api");
            this.DI.put(api, options);
            List<Scope> list = api.ev();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.DE.add(list.get(i2).eK());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.yN = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.DF = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            this.DJ = hn.b(fragmentActivity, (Object)"Null activity is not permitted.");
            this.DK = unresolvedConnectionFailedListener;
            return this;
        }

        public gz eD() {
            return new gz(this.yN, this.DE, this.DF, this.DG, this.DH);
        }

        public GoogleApiClient build() {
            hn.b(!this.DI.isEmpty(), (Object)"must call addApi() to add at least one API");
            d d2 = null;
            if (this.DJ != null) {
                d2 = this.eE();
            }
            c c2 = new c(this.mContext, this.DC, this.eD(), this.DI, d2, this.DL, this.DM);
            if (d2 != null) {
                d2.a(c2, this.DK);
            }
            return c2;
        }

        private d eE() {
            FragmentManager fragmentManager = this.DJ.getSupportFragmentManager();
            List list = fragmentManager.getFragments();
            if (list != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    if (!(fragment instanceof d) || !fragment.isAdded() || ((d)fragment).isInitialized()) continue;
                    return (d)fragment;
                }
            }
            d d2 = new d();
            fragmentManager.beginTransaction().add((Fragment)d2, null).commit();
            return d2;
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

