/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int xJ;
    private Boolean Zp;
    private Boolean Zq;
    private int Zr = -1;
    private CameraPosition Zs;
    private Boolean Zt;
    private Boolean Zu;
    private Boolean Zv;
    private Boolean Zw;
    private Boolean Zx;
    private Boolean Zy;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.xJ = versionCode;
        this.Zp = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.Zq = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.Zr = mapType;
        this.Zs = camera;
        this.Zt = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.Zu = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.Zv = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.Zw = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.Zx = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.Zy = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jG()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.xJ;
    }

    byte jl() {
        return com.google.android.gms.maps.internal.a.c(this.Zp);
    }

    byte jm() {
        return com.google.android.gms.maps.internal.a.c(this.Zq);
    }

    byte jn() {
        return com.google.android.gms.maps.internal.a.c(this.Zt);
    }

    byte jo() {
        return com.google.android.gms.maps.internal.a.c(this.Zu);
    }

    byte jp() {
        return com.google.android.gms.maps.internal.a.c(this.Zv);
    }

    byte jq() {
        return com.google.android.gms.maps.internal.a.c(this.Zw);
    }

    byte jr() {
        return com.google.android.gms.maps.internal.a.c(this.Zx);
    }

    byte js() {
        return com.google.android.gms.maps.internal.a.c(this.Zy);
    }

    public GoogleMapOptions() {
        this.xJ = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.Zp = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.Zq = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.Zr = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.Zs = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.Zt = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.Zu = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.Zv = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.Zw = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.Zx = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.Zy = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.Zp;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.Zq;
    }

    public int getMapType() {
        return this.Zr;
    }

    public CameraPosition getCamera() {
        return this.Zs;
    }

    public Boolean getZoomControlsEnabled() {
        return this.Zt;
    }

    public Boolean getCompassEnabled() {
        return this.Zu;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.Zv;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.Zw;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.Zx;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.Zy;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

