/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.jv;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int CK;
    private final Uri LU;
    private final int li;
    private final int lj;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.CK = versionCode;
        this.LU = url;
        this.li = width;
        this.lj = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.d(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.CK;
    }

    private static Uri d(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.LU;
    }

    public int getWidth() {
        return this.li;
    }

    public int getHeight() {
        return this.lj;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.li, this.lj, this.LU.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.LU.toString());
            jSONObject.put("width", this.li);
            jSONObject.put("height", this.lj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return jv.equal(this.LU, webImage.LU) && this.li == webImage.li && this.lj == webImage.lj;
    }

    public int hashCode() {
        return jv.hashCode(this.LU, this.li, this.lj);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

