/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ac;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.af;
import com.google.android.gms.analytics.d;
import com.google.android.gms.analytics.e;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.o;
import com.google.android.gms.analytics.r;
import com.google.android.gms.analytics.t;
import com.google.android.gms.internal.ha;
import com.google.android.gms.internal.ld;
import com.google.android.gms.internal.lf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class ag
implements d {
    private static final String BS = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private final a BT;
    private volatile r BU;
    private final e zc;
    private final Context mContext;
    private final String BV;
    private af BW;
    private long BX;
    private final int BY;
    private ld wb;
    private o ys;
    private volatile boolean yt = true;

    ag(e e2, Context context, o o2) {
        this(e2, context, "google_analytics_v4.db", 2000, o2);
    }

    ag(e e2, Context context, String string2, int n2, o o2) {
        this.mContext = context.getApplicationContext();
        this.ys = o2;
        this.BV = string2;
        this.zc = e2;
        this.wb = lf.if();
        this.BT = new a(this.mContext, this.BV);
        this.BU = new h((HttpClient)new DefaultHttpClient(), this.mContext, this.ys);
        this.BX = 0L;
        this.BY = n2;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.yt = dryRun;
        if (this.BU != null) {
            this.BU.setDryRun(dryRun);
        }
    }

    @Override
    public void l(long l2) {
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l2 == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l2).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.zc.B(this.fj() == 0);
        }
    }

    @Override
    public void a(Map<String, String> map, long l2, String string2, Collection<ha> collection) {
        this.fi();
        this.fh();
        this.a(map, collection);
        this.a(map, l2, string2);
    }

    private void a(Map<String, String> map, Collection<ha> collection) {
        String string2 = "&_v".substring(1);
        if (collection != null) {
            for (ha ha2 : collection) {
                if (!"appendVersion".equals(ha2.getId())) continue;
                map.put(string2, ha2.getValue());
                break;
            }
        }
    }

    private void fh() {
        int n2 = this.fj() - this.BY + 1;
        if (n2 > 0) {
            List<String> list = this.G(n2);
            ae.V("Store full, deleting " + list.size() + " hits to make room.");
            this.b(list.toArray(new String[0]));
        }
    }

    private void a(Map<String, String> map, long l2, String string2) {
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", ag.A(map));
        contentValues.put("hit_time", Long.valueOf(l2));
        long l3 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l3 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l3));
        if (string2 == null) {
            string2 = "http://www.google-analytics.com/collect";
        }
        if (string2.length() == 0) {
            ae.W("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string2);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.zc.B(false);
        }
        catch (SQLiteException sQLiteException) {
            ae.W("Error storing hit");
        }
    }

    static String A(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(ac.encode(entry.getKey()) + "=" + ac.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> G(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            ae.W("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ab> H(int n2) {
        ArrayList<ab> arrayList = new ArrayList<ab>();
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    ab ab2 = new ab(null, cursor.getLong(0), cursor.getLong(1), "");
                    arrayList.add(ab2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((ab)arrayList.get(n3)).aj(cursor.getString(1));
                        ((ab)arrayList.get(n3)).ak(cursor.getString(2));
                    } else {
                        ae.W(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((ab)arrayList.get(n3)).fb()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            ae.W("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<ab> arrayList2 = new ArrayList<ab>();
            boolean bl2 = false;
            for (ab ab3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)ab3.fa())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(ab3);
            }
            ArrayList<ab> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int fi() {
        long l2 = this.wb.currentTimeMillis();
        if (l2 <= this.BX + 86400000L) {
            return 0;
        }
        this.BX = l2;
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.wb.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.zc.B(this.fj() == 0);
        return n2;
    }

    @Deprecated
    void b(Collection<ab> collection) {
        if (collection == null || collection.isEmpty()) {
            ae.W("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (ab ab2 : collection) {
            stringArray[n2++] = String.valueOf(ab2.fb());
        }
        this.b(stringArray);
    }

    void b(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            ae.W("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string2 = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string2, stringArray);
            this.zc.B(this.fj() == 0);
        }
        catch (SQLiteException sQLiteException) {
            ae.W("Error deleting hits " + TextUtils.join((CharSequence)",", (Object[])stringArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fj() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    @Override
    public void dispatch() {
        int n2;
        ae.V("Dispatch running...");
        if (!this.BU.ea()) {
            return;
        }
        List<ab> list = this.H(20);
        if (list.isEmpty()) {
            ae.V("...nothing to dispatch");
            this.zc.B(true);
            return;
        }
        if (this.BW == null) {
            this.BW = new af("_t=dispatch&_v=ma4.0.4", false);
        }
        boolean bl2 = (n2 = this.fj()) <= list.size();
        int n3 = this.BU.a(list, this.BW, bl2);
        ae.V("sent " + n3 + " of " + list.size() + " hits");
        this.b(list.subList(0, Math.min(n3, list.size())));
        if (n3 == list.size() && this.fj() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.BW = null;
        }
    }

    @Override
    public r dV() {
        return this.BU;
    }

    private SQLiteDatabase al(String string2) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.BT.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            ae.W(string2);
            return null;
        }
        return sQLiteDatabase;
    }

    class a
    extends SQLiteOpenHelper {
        private boolean BZ;
        private long Ca;

        a(Context context, String string2) {
            super(context, string2, null, 1);
            this.Ca = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string2, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.BZ && this.Ca + 3600000L > ag.this.wb.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.BZ = true;
            this.Ca = ag.this.wb.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                ag.this.mContext.getDatabasePath(ag.this.BV).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.BZ = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("hits2", db2)) {
                db2.execSQL(BS);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            boolean bl2;
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl3 = bl2 = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl2) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            t.ag(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

