/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GoogleCloudMessaging {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    static GoogleCloudMessaging afo;
    private Context lM;
    private PendingIntent afp;
    final BlockingQueue<Intent> afq = new LinkedBlockingQueue<Intent>();
    private Handler afr = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Intent intent = (Intent)msg.obj;
            GoogleCloudMessaging.this.afq.add(intent);
        }
    };
    private Messenger afs = new Messenger(this.afr);

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (afo == null) {
            afo = new GoogleCloudMessaging();
            GoogleCloudMessaging.afo.lM = context.getApplicationContext();
        }
        return afo;
    }

    public void close() {
        this.mV();
    }

    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        this.a(to, msgId, timeToLive, -1, data);
    }

    private void a(String string2, String string3, long l2, int n2, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        intent.putExtras(bundle);
        this.j(intent);
        intent.setPackage("com.google.android.gms");
        intent.putExtra("google.to", string2);
        intent.putExtra("google.message_id", string3);
        intent.putExtra("google.ttl", Long.toString(l2));
        intent.putExtra("google.delay", Integer.toString(n2));
        this.lM.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    public void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.mU();
        try {
            Intent intent = this.afq.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string2 = intent.getStringExtra("unregistered");
            if (string2 != null) {
                return;
            }
            String string3 = intent.getStringExtra("error");
            if (string3 != null) {
                throw new IOException(string3);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void e(String ... stringArray) {
        String string2 = this.f(stringArray);
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("google.messenger", (Parcelable)this.afs);
        this.j(intent);
        intent.putExtra("sender", string2);
        this.lM.startService(intent);
    }

    public String register(String ... senderIds) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        this.afq.clear();
        this.e(senderIds);
        try {
            Intent intent = this.afq.poll(5000L, TimeUnit.MILLISECONDS);
            if (intent == null) {
                throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            }
            String string2 = intent.getStringExtra("registration_id");
            if (string2 != null) {
                return string2;
            }
            String string3 = intent.getStringExtra("error");
            String string4 = intent.getStringExtra("error");
            if (string4 != null) {
                throw new IOException(string4);
            }
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private void mU() {
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage("com.google.android.gms");
        this.afq.clear();
        intent.putExtra("google.messenger", (Parcelable)this.afs);
        this.j(intent);
        this.lM.startService(intent);
    }

    String f(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append(',').append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string2 = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string2)) {
            return null;
        }
        String string3 = intent.getStringExtra("message_type");
        if (string3 != null) {
            return string3;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void j(Intent intent) {
        if (this.afp == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.afp = PendingIntent.getBroadcast((Context)this.lM, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.afp);
    }

    synchronized void mV() {
        if (this.afp != null) {
            this.afp.cancel();
            this.afp = null;
        }
    }
}

