/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.nn;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String Zt = null;
        private int agd = 0;
        private long age = Long.MIN_VALUE;
        private short agf = (short)-1;
        private double agg;
        private double agh;
        private float agi;
        private int agj = 0;
        private int agk = -1;

        public Builder setRequestId(String requestId) {
            this.Zt = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.agd = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.age = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.agf = 1;
            this.agg = latitude;
            this.agh = longitude;
            this.agi = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.agj = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.agk = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.Zt == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.agd == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.agd & 4) != 0 && this.agk < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.age == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.agf == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.agj < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new nn(this.Zt, this.agd, 1, this.agg, this.agh, this.agi, this.age, this.agj, this.agk);
        }
    }
}

