/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.text.TextUtils;
import com.microsoft.live.OAuth;
import com.microsoft.live.TokenRequest;
import java.util.List;
import java.util.Locale;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicNameValuePair;

class AccessTokenRequest
extends TokenRequest {
    private final String code;
    private final OAuth.GrantType grantType;
    private final String redirectUri;

    public AccessTokenRequest(HttpClient client, String clientId, String redirectUri, String code) {
        super(client, clientId);
        assert (!TextUtils.isEmpty((CharSequence)redirectUri));
        assert (!TextUtils.isEmpty((CharSequence)code));
        this.redirectUri = redirectUri;
        this.code = code;
        this.grantType = OAuth.GrantType.AUTHORIZATION_CODE;
    }

    @Override
    protected void constructBody(List<NameValuePair> body) {
        body.add((NameValuePair)new BasicNameValuePair("code", this.code));
        body.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.redirectUri));
        body.add((NameValuePair)new BasicNameValuePair("grant_type", this.grantType.toString().toLowerCase(Locale.US)));
    }
}

