/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.microsoft.live.Config;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.OAuth;
import com.microsoft.live.UriBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;

abstract class ApiRequest<ResponseType> {
    private static final Header LIVE_LIBRARY_HEADER = new BasicHeader("X-HTTP-Live-Library", "android/" + Build.VERSION.RELEASE + "_" + Config.INSTANCE.getApiVersion());
    private static final int SESSION_REFRESH_BUFFER_SECS = 30;
    private static final int SESSION_TOKEN_SEND_BUFFER_SECS = 3;
    private final HttpClient client;
    private final List<Observer> observers;
    private final String path;
    private final ResponseHandler<ResponseType> responseHandler;
    private final LiveConnectSession session;
    protected final UriBuilder requestUri;
    protected final Uri pathUri;

    private static Header createAuthroizationHeader(LiveConnectSession session) {
        assert (session != null);
        String accessToken = session.getAccessToken();
        assert (!TextUtils.isEmpty((CharSequence)accessToken));
        String tokenType = OAuth.TokenType.BEARER.toString().toLowerCase(Locale.US);
        String value = TextUtils.join((CharSequence)" ", (Object[])new String[]{tokenType, accessToken});
        return new BasicHeader("Authorization", value);
    }

    public ApiRequest(LiveConnectSession session, HttpClient client, ResponseHandler<ResponseType> responseHandler, String path) {
        this(session, client, responseHandler, path, ResponseCodes.SUPPRESS, Redirects.SUPPRESS);
    }

    public ApiRequest(LiveConnectSession session, HttpClient client, ResponseHandler<ResponseType> responseHandler, String path, ResponseCodes responseCodes, Redirects redirects) {
        assert (session != null);
        assert (client != null);
        assert (responseHandler != null);
        assert (!TextUtils.isEmpty((CharSequence)path));
        this.session = session;
        this.client = client;
        this.observers = new ArrayList<Observer>();
        this.responseHandler = responseHandler;
        this.path = path;
        this.pathUri = Uri.parse((String)path);
        int queryStart = path.indexOf("?");
        String pathWithoutQuery = path.substring(0, queryStart != -1 ? queryStart : path.length());
        Uri uriWithoutQuery = Uri.parse((String)pathWithoutQuery);
        String query = queryStart != -1 ? path.substring(queryStart + 1, path.length()) : "";
        UriBuilder builder = uriWithoutQuery.isAbsolute() ? UriBuilder.newInstance(uriWithoutQuery).query(query) : UriBuilder.newInstance(Config.INSTANCE.getApiUri()).appendToPath(uriWithoutQuery.getEncodedPath()).query(query);
        responseCodes.setQueryParameterOn(builder);
        redirects.setQueryParameterOn(builder);
        this.requestUri = builder;
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public ResponseType execute() throws LiveOperationException {
        HttpUriRequest request = this.createHttpRequest();
        request.addHeader(LIVE_LIBRARY_HEADER);
        if (this.session.willExpireInSecs(30)) {
            this.session.refresh();
        }
        if (!this.session.willExpireInSecs(3)) {
            request.addHeader(ApiRequest.createAuthroizationHeader(this.session));
        }
        try {
            HttpResponse response = this.client.execute(request);
            for (Observer observer : this.observers) {
                observer.onComplete(response);
            }
            return (ResponseType)this.responseHandler.handleResponse(response);
        }
        catch (ClientProtocolException e) {
            throw new LiveOperationException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        catch (IOException e) {
            try {
                new JSONObject(e.getMessage());
                throw new LiveOperationException(e.getMessage());
            }
            catch (JSONException jsonException) {
                throw new LiveOperationException("An error occured while communicating with the server during the operation. Please try again later.", e);
            }
        }
    }

    public abstract String getMethod();

    public String getPath() {
        return this.path;
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    protected abstract HttpUriRequest createHttpRequest() throws LiveOperationException;

    public static enum ResponseCodes {
        SUPPRESS{

            @Override
            protected void setQueryParameterOn(UriBuilder builder) {
                ResponseCodes.setQueryParameterOn(builder, Boolean.TRUE);
            }
        }
        ,
        UNSUPPRESSED{

            @Override
            protected void setQueryParameterOn(UriBuilder builder) {
                ResponseCodes.setQueryParameterOn(builder, Boolean.FALSE);
            }
        };


        protected abstract void setQueryParameterOn(UriBuilder var1);

        private static void setQueryParameterOn(UriBuilder builder, Boolean value) {
            builder.removeQueryParametersWithKey("suppress_response_codes");
            builder.appendQueryParameter("suppress_response_codes", value.toString());
        }
    }

    public static enum Redirects {
        SUPPRESS{

            @Override
            protected void setQueryParameterOn(UriBuilder builder) {
                Redirects.setQueryParameterOn(builder, Boolean.TRUE);
            }
        }
        ,
        UNSUPPRESSED{

            @Override
            protected void setQueryParameterOn(UriBuilder builder) {
                Redirects.setQueryParameterOn(builder, Boolean.FALSE);
            }
        };


        protected abstract void setQueryParameterOn(UriBuilder var1);

        private static void setQueryParameterOn(UriBuilder builder, Boolean value) {
            builder.removeQueryParametersWithKey("suppress_redirects");
            builder.appendQueryParameter("suppress_redirects", value.toString());
        }
    }

    public static interface Observer {
        public void onComplete(HttpResponse var1);
    }
}

