/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.os.AsyncTask;
import com.microsoft.live.ApiRequest;
import com.microsoft.live.EntityEnclosingApiRequest;
import com.microsoft.live.LiveOperationException;
import java.util.ArrayList;

class ApiRequestAsync<ResponseType>
extends AsyncTask<Void, Long, Runnable>
implements EntityEnclosingApiRequest.UploadProgressListener {
    private final ArrayList<Observer<ResponseType>> observers = new ArrayList();
    private final ArrayList<ProgressObserver> progressListeners = new ArrayList();
    private final ApiRequest<ResponseType> request;

    public static <T> ApiRequestAsync<T> newInstance(ApiRequest<T> request) {
        return new ApiRequestAsync<T>(request);
    }

    public static <T> ApiRequestAsync<T> newInstance(EntityEnclosingApiRequest<T> request) {
        return new ApiRequestAsync<T>(request);
    }

    public ApiRequestAsync(EntityEnclosingApiRequest<ResponseType> request) {
        assert (request != null);
        request.addListener(this);
        this.request = request;
    }

    public ApiRequestAsync(ApiRequest<ResponseType> request) {
        assert (request != null);
        this.request = request;
    }

    public boolean addObserver(Observer<ResponseType> observer) {
        return this.observers.add(observer);
    }

    public boolean addProgressObserver(ProgressObserver observer) {
        return this.progressListeners.add(observer);
    }

    @Override
    public void onProgress(long totalBytes, long numBytesWritten) {
        this.publishProgress(new Long[]{totalBytes, numBytesWritten});
    }

    public boolean removeObserver(Observer<ResponseType> observer) {
        return this.observers.remove(observer);
    }

    public boolean removeProgressObserver(ProgressObserver observer) {
        return this.progressListeners.remove(observer);
    }

    protected Runnable doInBackground(Void ... args) {
        ResponseType response;
        try {
            response = this.request.execute();
        }
        catch (LiveOperationException e) {
            return new OnErrorRunnable(e);
        }
        return new OnCompleteRunnable(response);
    }

    protected void onPostExecute(Runnable result) {
        super.onPostExecute((Object)result);
        result.run();
    }

    protected void onProgressUpdate(Long ... values) {
        for (ProgressObserver listener : this.progressListeners) {
            listener.onProgress(values);
        }
    }

    private class OnErrorRunnable
    implements Runnable {
        private final LiveOperationException exception;

        public OnErrorRunnable(LiveOperationException exception) {
            assert (exception != null);
            this.exception = exception;
        }

        @Override
        public void run() {
            for (Observer observer : ApiRequestAsync.this.observers) {
                observer.onError(this.exception);
            }
        }
    }

    private class OnCompleteRunnable
    implements Runnable {
        private final ResponseType response;

        public OnCompleteRunnable(ResponseType response) {
            assert (response != null);
            this.response = response;
        }

        @Override
        public void run() {
            for (Observer observer : ApiRequestAsync.this.observers) {
                observer.onComplete(this.response);
            }
        }
    }

    public static interface ProgressObserver {
        public void onProgress(Long ... var1);
    }

    public static interface Observer<ResponseType> {
        public void onComplete(ResponseType var1);

        public void onError(LiveOperationException var1);
    }
}

