/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import com.microsoft.live.ApiRequest;
import com.microsoft.live.LiveConnectSession;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.HttpEntityWrapper;

abstract class EntityEnclosingApiRequest<ResponseType>
extends ApiRequest<ResponseType> {
    protected final HttpEntity entity;
    private final List<UploadProgressListener> listeners;

    public EntityEnclosingApiRequest(LiveConnectSession session, HttpClient client, ResponseHandler<ResponseType> responseHandler, String path, HttpEntity entity) {
        this(session, client, responseHandler, path, entity, ApiRequest.ResponseCodes.SUPPRESS, ApiRequest.Redirects.SUPPRESS);
    }

    public EntityEnclosingApiRequest(LiveConnectSession session, HttpClient client, ResponseHandler<ResponseType> responseHandler, String path, HttpEntity entity, ApiRequest.ResponseCodes responseCodes, ApiRequest.Redirects redirects) {
        super(session, client, responseHandler, path, responseCodes, redirects);
        assert (entity != null);
        this.listeners = new ArrayList<UploadProgressListener>();
        this.entity = new ProgressableEntity(entity, this.listeners);
    }

    public boolean addListener(UploadProgressListener listener) {
        assert (listener != null);
        return this.listeners.add(listener);
    }

    public boolean removeListener(UploadProgressListener listener) {
        assert (listener != null);
        return this.listeners.remove(listener);
    }

    private static class ProgressableOutputStream
    extends FilterOutputStream {
        final List<UploadProgressListener> listeners;
        long numBytesWritten;
        long totalBytes;

        public ProgressableOutputStream(OutputStream outstream, long totalBytes, List<UploadProgressListener> listeners) {
            super(outstream);
            assert (totalBytes >= 0L);
            assert (listeners != null);
            this.listeners = listeners;
            this.numBytesWritten = 0L;
            this.totalBytes = totalBytes;
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.out.write(buffer);
            this.numBytesWritten += (long)buffer.length;
            this.notifyListeners();
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            this.out.write(buffer, offset, count);
            this.numBytesWritten += (long)count;
            this.notifyListeners();
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.out.write(oneByte);
            ++this.numBytesWritten;
            this.notifyListeners();
        }

        private void notifyListeners() {
            assert (this.numBytesWritten <= this.totalBytes);
            for (UploadProgressListener listener : this.listeners) {
                listener.onProgress(this.totalBytes, this.numBytesWritten);
            }
        }
    }

    private static class ProgressableEntity
    extends HttpEntityWrapper {
        final List<UploadProgressListener> listeners;

        ProgressableEntity(HttpEntity wrapped, List<UploadProgressListener> listeners) {
            super(wrapped);
            assert (listeners != null);
            this.listeners = listeners;
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.wrappedEntity.writeTo((OutputStream)new ProgressableOutputStream(outstream, this.getContentLength(), this.listeners));
            this.wrappedEntity.consumeContent();
        }
    }

    public static interface UploadProgressListener {
        public void onProgress(long var1, long var3);
    }
}

