/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.microsoft.live.AuthorizationRequest;
import com.microsoft.live.Config;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.LiveAuthListener;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveConnectUtils;
import com.microsoft.live.LiveStatus;
import com.microsoft.live.OAuth;
import com.microsoft.live.OAuthErrorResponse;
import com.microsoft.live.OAuthRequestObserver;
import com.microsoft.live.OAuthResponse;
import com.microsoft.live.OAuthResponseVisitor;
import com.microsoft.live.OAuthSuccessfulResponse;
import com.microsoft.live.RefreshAccessTokenRequest;
import com.microsoft.live.TokenRequestAsync;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class LiveAuthClient {
    private static final LiveAuthListener NULL_LISTENER = new LiveAuthListener(){

        @Override
        public void onAuthComplete(LiveStatus status, LiveConnectSession session, Object sender) {
        }

        @Override
        public void onAuthError(LiveAuthException exception, Object sender) {
        }
    };
    private final Context applicationContext;
    private final String clientId;
    private boolean hasPendingLoginRequest = false;
    private HttpClient httpClient = new DefaultHttpClient();
    private Set<String> scopesFromInitialize;
    private final LiveConnectSession session = new LiveConnectSession(this);

    public LiveAuthClient(Context context, String clientId) {
        LiveConnectUtils.assertNotNull(context, "context");
        LiveConnectUtils.assertNotNullOrEmpty(clientId, "clientId");
        this.applicationContext = context.getApplicationContext();
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void initialize(Iterable<String> scopes, LiveAuthListener listener) {
        this.initialize(scopes, listener, null, null);
    }

    public void initialize(Iterable<String> scopes, LiveAuthListener listener, Object userState) {
        this.initialize(scopes, listener, userState, null);
    }

    public void initialize(Iterable<String> scopes, LiveAuthListener listener, Object userState, String refreshToken) {
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        if (scopes == null) {
            scopes = Arrays.asList(new String[0]);
        }
        this.scopesFromInitialize = new HashSet<String>();
        for (String scope : scopes) {
            this.scopesFromInitialize.add(scope);
        }
        this.scopesFromInitialize = Collections.unmodifiableSet(this.scopesFromInitialize);
        if (refreshToken == null) {
            refreshToken = this.getRefreshTokenFromPreferences();
        }
        if (refreshToken == null) {
            listener.onAuthComplete(LiveStatus.UNKNOWN, null, userState);
            return;
        }
        RefreshAccessTokenRequest request = new RefreshAccessTokenRequest(this.httpClient, this.clientId, refreshToken, TextUtils.join((CharSequence)" ", scopes));
        TokenRequestAsync asyncRequest = new TokenRequestAsync(request);
        asyncRequest.addObserver(new ListenerCallerObserver(listener, userState));
        asyncRequest.addObserver(new RefreshTokenWriter());
        asyncRequest.execute(new Void[0]);
    }

    public void initialize(LiveAuthListener listener) {
        this.initialize(listener, null);
    }

    public void initialize(LiveAuthListener listener, Object userState) {
        this.initialize(null, listener, userState, null);
    }

    public void login(Activity activity, Iterable<String> scopes, LiveAuthListener listener) {
        this.login(activity, scopes, listener, null);
    }

    public void login(Activity activity, Iterable<String> scopes, LiveAuthListener listener, Object userState) {
        boolean showDialog;
        LiveConnectUtils.assertNotNull(activity, "activity");
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        if (this.hasPendingLoginRequest) {
            throw new IllegalStateException("Another login operation is already in progress.");
        }
        if (scopes == null) {
            scopes = this.scopesFromInitialize == null ? Arrays.asList(new String[0]) : this.scopesFromInitialize;
        }
        boolean bl = showDialog = this.session.isExpired() || !this.session.contains(scopes);
        if (!showDialog) {
            listener.onAuthComplete(LiveStatus.CONNECTED, this.session, userState);
            return;
        }
        String scope = TextUtils.join((CharSequence)" ", scopes);
        String redirectUri = Config.INSTANCE.getOAuthDesktopUri().toString();
        AuthorizationRequest request = new AuthorizationRequest(activity, this.httpClient, this.clientId, redirectUri, scope);
        request.addObserver(new ListenerCallerObserver(listener, userState));
        request.addObserver(new RefreshTokenWriter());
        request.addObserver(new OAuthRequestObserver(){

            @Override
            public void onException(LiveAuthException exception) {
                LiveAuthClient.this.hasPendingLoginRequest = false;
            }

            @Override
            public void onResponse(OAuthResponse response) {
                LiveAuthClient.this.hasPendingLoginRequest = false;
            }
        });
        this.hasPendingLoginRequest = true;
        request.execute();
    }

    public void logout(LiveAuthListener listener) {
        this.logout(listener, null);
    }

    public void logout(LiveAuthListener listener, Object userState) {
        if (listener == null) {
            listener = NULL_LISTENER;
        }
        this.session.setAccessToken(null);
        this.session.setAuthenticationToken(null);
        this.session.setRefreshToken(null);
        this.session.setScopes(null);
        this.session.setTokenType(null);
        this.clearRefreshTokenFromPreferences();
        CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)this.applicationContext);
        CookieManager manager = CookieManager.getInstance();
        Uri logoutUri = Config.INSTANCE.getOAuthLogoutUri();
        String url = logoutUri.toString();
        String domain = logoutUri.getHost();
        List<String> cookieKeys = this.getCookieKeysFromPreferences();
        for (String cookieKey : cookieKeys) {
            String value = TextUtils.join((CharSequence)"", (Object[])new String[]{cookieKey, "=; expires=Thu, 30-Oct-1980 16:00:00 GMT;domain=", domain, ";path=/;version=1"});
            manager.setCookie(url, value);
        }
        cookieSyncManager.sync();
        listener.onAuthComplete(LiveStatus.UNKNOWN, null, userState);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    LiveConnectSession getSession() {
        return this.session;
    }

    boolean refresh() {
        OAuthResponse response;
        String scope = TextUtils.join((CharSequence)" ", this.session.getScopes());
        String refreshToken = this.session.getRefreshToken();
        if (TextUtils.isEmpty((CharSequence)refreshToken)) {
            return false;
        }
        RefreshAccessTokenRequest request = new RefreshAccessTokenRequest(this.httpClient, this.clientId, refreshToken, scope);
        try {
            response = request.execute();
        }
        catch (LiveAuthException e) {
            return false;
        }
        SessionRefresher refresher = new SessionRefresher(this.session);
        response.accept(refresher);
        response.accept(new RefreshTokenWriter());
        return refresher.visitedSuccessfulResponse();
    }

    void setHttpClient(HttpClient client) {
        assert (client != null);
        this.httpClient = client;
    }

    private boolean clearRefreshTokenFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        SharedPreferences.Editor editor = settings.edit();
        editor.remove("refresh_token");
        return editor.commit();
    }

    private SharedPreferences getSharedPreferences() {
        return this.applicationContext.getSharedPreferences("com.microsoft.live", 0);
    }

    private List<String> getCookieKeysFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        String cookieKeys = settings.getString("cookies", "");
        return Arrays.asList(TextUtils.split((String)cookieKeys, (String)","));
    }

    private String getRefreshTokenFromPreferences() {
        SharedPreferences settings = this.getSharedPreferences();
        return settings.getString("refresh_token", null);
    }

    private static class SessionRefresher
    implements OAuthResponseVisitor {
        private final LiveConnectSession session;
        private boolean visitedSuccessfulResponse;

        public SessionRefresher(LiveConnectSession session) {
            assert (session != null);
            this.session = session;
            this.visitedSuccessfulResponse = false;
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            this.visitedSuccessfulResponse = false;
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            this.session.loadFromOAuthResponse(response);
            this.visitedSuccessfulResponse = true;
        }

        public boolean visitedSuccessfulResponse() {
            return this.visitedSuccessfulResponse;
        }
    }

    private class RefreshTokenWriter
    implements OAuthRequestObserver,
    OAuthResponseVisitor {
        private RefreshTokenWriter() {
        }

        @Override
        public void onException(LiveAuthException exception) {
        }

        @Override
        public void onResponse(OAuthResponse response) {
            response.accept(this);
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            if (response.getError() == OAuth.ErrorType.INVALID_GRANT) {
                LiveAuthClient.this.clearRefreshTokenFromPreferences();
            }
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            String refreshToken = response.getRefreshToken();
            if (!TextUtils.isEmpty((CharSequence)refreshToken)) {
                this.saveRefreshTokenToPreferences(refreshToken);
            }
        }

        private boolean saveRefreshTokenToPreferences(String refreshToken) {
            assert (!TextUtils.isEmpty((CharSequence)refreshToken));
            SharedPreferences settings = LiveAuthClient.this.applicationContext.getSharedPreferences("com.microsoft.live", 0);
            SharedPreferences.Editor editor = settings.edit();
            editor.putString("refresh_token", refreshToken);
            return editor.commit();
        }
    }

    private class ListenerCallerObserver
    extends AuthListenerCaller
    implements OAuthRequestObserver,
    OAuthResponseVisitor {
        public ListenerCallerObserver(LiveAuthListener listener, Object userState) {
            super(listener, userState);
        }

        @Override
        public void onException(LiveAuthException exception) {
            new AuthErrorRunnable(this.listener, this.userState, exception).run();
        }

        @Override
        public void onResponse(OAuthResponse response) {
            response.accept(this);
        }

        @Override
        public void visit(OAuthErrorResponse response) {
            String error = response.getError().toString().toLowerCase(Locale.US);
            String errorDescription = response.getErrorDescription();
            String errorUri = response.getErrorUri();
            LiveAuthException exception = new LiveAuthException(error, errorDescription, errorUri);
            new AuthErrorRunnable(this.listener, this.userState, exception).run();
        }

        @Override
        public void visit(OAuthSuccessfulResponse response) {
            LiveAuthClient.this.session.loadFromOAuthResponse(response);
            new AuthCompleteRunnable(this.listener, this.userState, LiveStatus.CONNECTED, LiveAuthClient.this.session).run();
        }
    }

    private static abstract class AuthListenerCaller {
        protected final LiveAuthListener listener;
        protected final Object userState;

        public AuthListenerCaller(LiveAuthListener listener, Object userState) {
            this.listener = listener;
            this.userState = userState;
        }
    }

    private static class AuthErrorRunnable
    extends AuthListenerCaller
    implements Runnable {
        private final LiveAuthException exception;

        public AuthErrorRunnable(LiveAuthListener listener, Object userState, LiveAuthException exception) {
            super(listener, userState);
            this.exception = exception;
        }

        @Override
        public void run() {
            this.listener.onAuthError(this.exception, this.userState);
        }
    }

    private static class AuthCompleteRunnable
    extends AuthListenerCaller
    implements Runnable {
        private final LiveStatus status;
        private final LiveConnectSession session;

        public AuthCompleteRunnable(LiveAuthListener listener, Object userState, LiveStatus status, LiveConnectSession session) {
            super(listener, userState);
            this.status = status;
            this.session = session;
        }

        @Override
        public void run() {
            this.listener.onAuthComplete(this.status, this.session, this.userState);
        }
    }
}

