/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.os.AsyncTask;
import android.text.TextUtils;
import com.microsoft.live.ApiRequest;
import com.microsoft.live.ApiRequestAsync;
import com.microsoft.live.CopyRequest;
import com.microsoft.live.DeleteRequest;
import com.microsoft.live.DownloadRequest;
import com.microsoft.live.GetRequest;
import com.microsoft.live.JsonEntity;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveConnectUtils;
import com.microsoft.live.LiveDownloadOperation;
import com.microsoft.live.LiveDownloadOperationListener;
import com.microsoft.live.LiveOperation;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.LiveOperationListener;
import com.microsoft.live.LiveUploadOperationListener;
import com.microsoft.live.MoveRequest;
import com.microsoft.live.OverwriteOption;
import com.microsoft.live.PostRequest;
import com.microsoft.live.PutRequest;
import com.microsoft.live.UploadRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveConnectClient {
    private static int BUFFER_SIZE = 1024;
    private static int CONNECT_TIMEOUT_IN_MS = 30000;
    private static final String DESTINATION_KEY = "destination";
    private static volatile HttpClient HTTP_CLIENT;
    private static Object HTTP_CLIENT_LOCK;
    private static final LiveDownloadOperationListener NULL_DOWNLOAD_OPERATION_LISTENER;
    private static final LiveOperationListener NULL_OPERATION_LISTENER;
    private static final LiveUploadOperationListener NULL_UPLOAD_OPERATION_LISTENER;
    private static int SOCKET_TIMEOUT_IN_MS;
    private HttpClient httpClient;
    private final LiveConnectSession session;
    private SessionState sessionState;

    private static URI assertIsUri(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            String message = String.format("Input parameter '%1$s' is invalid. '%1$s' must be a valid URI.", "path");
            throw new IllegalArgumentException(message);
        }
    }

    private static void assertValidPath(String path) {
        LiveConnectUtils.assertNotNullOrEmpty(path, "path");
        LiveConnectClient.assertIsUri(path);
    }

    private static void closeSilently(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void assertValidRelativePath(String path) {
        LiveConnectUtils.assertNotNullOrEmpty(path, "path");
        if (path.toLowerCase().startsWith("http") || path.toLowerCase().startsWith("https")) {
            String message = String.format("Input parameter '%1$s' is invalid. '%1$s' cannot be absolute.", "path");
            throw new IllegalArgumentException(message);
        }
    }

    private static JSONObject createJsonBody(String key, String value) {
        HashMap<String, String> tempBody = new HashMap<String, String>();
        tempBody.put(key, value);
        return new JSONObject(tempBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient getHttpClient() {
        if (HTTP_CLIENT == null) {
            Object object = HTTP_CLIENT_LOCK;
            synchronized (object) {
                if (HTTP_CLIENT == null) {
                    BasicHttpParams params = new BasicHttpParams();
                    HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)CONNECT_TIMEOUT_IN_MS);
                    HttpConnectionParams.setSoTimeout((HttpParams)params, (int)SOCKET_TIMEOUT_IN_MS);
                    ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)100);
                    HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                    SchemeRegistry schemeRegistry = new SchemeRegistry();
                    schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                    schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
                    ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
                    HTTP_CLIENT = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
                }
            }
        }
        return HTTP_CLIENT;
    }

    private static LiveOperation handleException(String method, String path, LiveOperationException e, LiveOperationListener listener, Object userState) {
        LiveOperation operation = new LiveOperation.Builder(method, path).userState(userState).build();
        OperationObserver requestListener = new OperationObserver(operation, listener);
        requestListener.onError(e);
        return operation;
    }

    private static LiveOperation handleException(String method, String path, LiveOperationException e, LiveUploadOperationListener listener, Object userState) {
        LiveOperation operation = new LiveOperation.Builder(method, path).userState(userState).build();
        UploadRequestListener requestListener = new UploadRequestListener(operation, listener);
        requestListener.onError(e);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(byteOut);
        is = new BufferedInputStream(is);
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            int bytesRead;
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        finally {
            LiveConnectClient.closeSilently(is);
            LiveConnectClient.closeSilently(out);
        }
        return byteOut.toByteArray();
    }

    public LiveConnectClient(LiveConnectSession session) {
        LiveConnectUtils.assertNotNull(session, "session");
        String accessToken = session.getAccessToken();
        LiveConnectUtils.assertNotNullOrEmpty(accessToken, "session.getAccessToken()");
        this.session = session;
        this.sessionState = SessionState.LOGGED_IN;
        this.session.addPropertyChangeListener("accessToken", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String newValue = (String)event.getNewValue();
                if (TextUtils.isEmpty((CharSequence)newValue)) {
                    LiveConnectClient.this.sessionState = SessionState.LOGGED_OUT;
                } else {
                    LiveConnectClient.this.sessionState = SessionState.LOGGED_IN;
                }
            }
        });
        this.httpClient = LiveConnectClient.getHttpClient();
    }

    public LiveOperation copy(String path, String destination) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNullOrEmpty(destination, DESTINATION_KEY);
        CopyRequest request = this.createCopyRequest(path, destination);
        return this.execute(request);
    }

    public LiveOperation copyAsync(String path, String destination, LiveOperationListener listener) {
        return this.copyAsync(path, destination, listener, null);
    }

    public LiveOperation copyAsync(String path, String destination, LiveOperationListener listener, Object userState) {
        CopyRequest request;
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNullOrEmpty(destination, DESTINATION_KEY);
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        try {
            request = this.createCopyRequest(path, destination);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("COPY", path, e, listener, userState);
        }
        return this.executeAsync(request, listener, userState);
    }

    public LiveOperation delete(String path) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        DeleteRequest request = new DeleteRequest(this.session, this.httpClient, path);
        return this.execute(request);
    }

    public LiveOperation deleteAsync(String path, LiveOperationListener listener) {
        return this.deleteAsync(path, listener, null);
    }

    public LiveOperation deleteAsync(String path, LiveOperationListener listener, Object userState) {
        LiveConnectClient.assertValidRelativePath(path);
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        DeleteRequest request = new DeleteRequest(this.session, this.httpClient, path);
        return this.executeAsync(request, listener, userState);
    }

    public LiveDownloadOperation download(String path) throws LiveOperationException {
        LiveConnectClient.assertValidPath(path);
        DownloadRequest request = new DownloadRequest(this.session, this.httpClient, path);
        LiveDownloadOperation operation = new LiveDownloadOperation.Builder(request.getMethod(), request.getPath()).build();
        request.addObserver(new ContentLengthObserver(operation));
        InputStream stream = (InputStream)request.execute();
        operation.setStream(stream);
        return operation;
    }

    public LiveDownloadOperation downloadAsync(String path, LiveDownloadOperationListener listener) {
        return this.downloadAsync(path, listener, null);
    }

    public LiveDownloadOperation downloadAsync(String path, LiveDownloadOperationListener listener, Object userState) {
        LiveConnectClient.assertValidPath(path);
        if (listener == null) {
            listener = NULL_DOWNLOAD_OPERATION_LISTENER;
        }
        DownloadRequest request = new DownloadRequest(this.session, this.httpClient, path);
        return this.executeAsync(request, listener, userState);
    }

    public LiveDownloadOperation downloadAsync(String path, File file, LiveDownloadOperationListener listener) {
        return this.downloadAsync(path, file, listener, null);
    }

    public LiveDownloadOperation downloadAsync(String path, File file, LiveDownloadOperationListener listener, Object userState) {
        LiveConnectClient.assertValidPath(path);
        if (listener == null) {
            listener = NULL_DOWNLOAD_OPERATION_LISTENER;
        }
        DownloadRequest request = new DownloadRequest(this.session, this.httpClient, path);
        ApiRequestAsync<InputStream> asyncRequest = ApiRequestAsync.newInstance(request);
        LiveDownloadOperation operation = new LiveDownloadOperation.Builder(request.getMethod(), request.getPath()).userState(userState).apiRequestAsync(asyncRequest).build();
        request.addObserver(new ContentLengthObserver(operation));
        asyncRequest.addObserver(new FileDownloadObserver(operation, listener, file));
        asyncRequest.execute(new Void[0]);
        return operation;
    }

    public LiveOperation get(String path) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        GetRequest request = new GetRequest(this.session, this.httpClient, path);
        return this.execute(request);
    }

    public LiveOperation getAsync(String path, LiveOperationListener listener) {
        return this.getAsync(path, listener, null);
    }

    public LiveOperation getAsync(String path, LiveOperationListener listener, Object userState) {
        LiveConnectClient.assertValidRelativePath(path);
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        GetRequest request = new GetRequest(this.session, this.httpClient, path);
        return this.executeAsync(request, listener, userState);
    }

    public LiveConnectSession getSession() {
        return this.session;
    }

    public LiveOperation move(String path, String destination) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNullOrEmpty(destination, DESTINATION_KEY);
        MoveRequest request = this.createMoveRequest(path, destination);
        return this.execute(request);
    }

    public LiveOperation moveAsync(String path, String destination, LiveOperationListener listener) {
        return this.moveAsync(path, destination, listener, null);
    }

    public LiveOperation moveAsync(String path, String destination, LiveOperationListener listener, Object userState) {
        MoveRequest request;
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNullOrEmpty(destination, DESTINATION_KEY);
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        try {
            request = this.createMoveRequest(path, destination);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("MOVE", path, e, listener, userState);
        }
        return this.executeAsync(request, listener, userState);
    }

    public LiveOperation post(String path, JSONObject body) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNull(body, "body");
        PostRequest request = this.createPostRequest(path, body);
        return this.execute(request);
    }

    public LiveOperation post(String path, String body) throws LiveOperationException {
        JSONObject jsonBody;
        LiveConnectUtils.assertNotNullOrEmpty(body, "body");
        try {
            jsonBody = new JSONObject(body.toString());
        }
        catch (JSONException e) {
            throw new LiveOperationException("An error occured on the client during the operation.", e);
        }
        return this.post(path, jsonBody);
    }

    public LiveOperation postAsync(String path, JSONObject body, LiveOperationListener listener) {
        return this.postAsync(path, body, listener, null);
    }

    public LiveOperation postAsync(String path, JSONObject body, LiveOperationListener listener, Object userState) {
        PostRequest request;
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNull(body, "body");
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        try {
            request = this.createPostRequest(path, body);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("POST", path, e, listener, userState);
        }
        return this.executeAsync(request, listener, userState);
    }

    public LiveOperation postAsync(String path, String body, LiveOperationListener listener) {
        return this.postAsync(path, body, listener, null);
    }

    public LiveOperation postAsync(String path, String body, LiveOperationListener listener, Object userState) {
        JSONObject jsonBody;
        LiveConnectUtils.assertNotNullOrEmpty(body, "body");
        try {
            jsonBody = new JSONObject(body.toString());
        }
        catch (JSONException e) {
            return LiveConnectClient.handleException("POST", path, new LiveOperationException("An error occured on the client during the operation.", e), listener, userState);
        }
        return this.postAsync(path, jsonBody, listener, userState);
    }

    public LiveOperation put(String path, JSONObject body) throws LiveOperationException {
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNull(body, "body");
        PutRequest request = this.createPutRequest(path, body);
        return this.execute(request);
    }

    public LiveOperation put(String path, String body) throws LiveOperationException {
        JSONObject jsonBody;
        LiveConnectUtils.assertNotNullOrEmpty(body, "body");
        try {
            jsonBody = new JSONObject(body.toString());
        }
        catch (JSONException e) {
            throw new LiveOperationException("An error occured on the client during the operation.", e);
        }
        return this.put(path, jsonBody);
    }

    public LiveOperation putAsync(String path, JSONObject body, LiveOperationListener listener) {
        return this.putAsync(path, body, listener, null);
    }

    public LiveOperation putAsync(String path, JSONObject body, LiveOperationListener listener, Object userState) {
        PutRequest request;
        LiveConnectClient.assertValidRelativePath(path);
        LiveConnectUtils.assertNotNull(body, "body");
        if (listener == null) {
            listener = NULL_OPERATION_LISTENER;
        }
        try {
            request = this.createPutRequest(path, body);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("PUT", path, e, listener, userState);
        }
        return this.executeAsync(request, listener, userState);
    }

    public LiveOperation putAsync(String path, String body, LiveOperationListener listener) {
        return this.putAsync(path, body, listener, null);
    }

    public LiveOperation putAsync(String path, String body, LiveOperationListener listener, Object userState) {
        JSONObject jsonBody;
        LiveConnectUtils.assertNotNullOrEmpty(body, "body");
        try {
            jsonBody = new JSONObject(body.toString());
        }
        catch (JSONException e) {
            return LiveConnectClient.handleException("PUT", path, new LiveOperationException("An error occured on the client during the operation.", e), listener, userState);
        }
        return this.putAsync(path, jsonBody, listener, userState);
    }

    public LiveOperation upload(String path, String filename, InputStream file) throws LiveOperationException {
        return this.upload(path, filename, file, OverwriteOption.DoNotOverwrite);
    }

    public LiveOperation upload(String path, String filename, InputStream file, OverwriteOption overwrite) throws LiveOperationException {
        byte[] bytes;
        LiveConnectClient.assertValidPath(path);
        LiveConnectUtils.assertNotNullOrEmpty(filename, "filename");
        LiveConnectUtils.assertNotNull(file, "file");
        LiveConnectUtils.assertNotNull((Object)overwrite, "overwrite");
        try {
            bytes = LiveConnectClient.toByteArray(file);
        }
        catch (IOException e) {
            throw new LiveOperationException("An error occured on the client during the operation.", e);
        }
        UploadRequest request = this.createUploadRequest(path, filename, new ByteArrayInputStream(bytes), bytes.length, overwrite);
        return this.execute(request);
    }

    public LiveOperation upload(String path, String filename, File file) throws LiveOperationException {
        return this.upload(path, filename, file, OverwriteOption.DoNotOverwrite);
    }

    public LiveOperation upload(String path, String filename, File file, OverwriteOption overwrite) throws LiveOperationException {
        LiveConnectClient.assertValidPath(path);
        LiveConnectUtils.assertNotNullOrEmpty(filename, "filename");
        LiveConnectUtils.assertNotNull(file, "file");
        LiveConnectUtils.assertNotNull((Object)overwrite, "overwrite");
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new LiveOperationException("An error occured on the client during the operation.", e);
        }
        UploadRequest request = this.createUploadRequest(path, filename, is, file.length(), overwrite);
        return this.execute(request);
    }

    public LiveOperation uploadAsync(String path, String filename, InputStream file, OverwriteOption overwrite, LiveUploadOperationListener listener, Object userState) {
        UploadRequest request;
        byte[] bytes;
        LiveConnectClient.assertValidPath(path);
        LiveConnectUtils.assertNotNullOrEmpty(filename, "filename");
        LiveConnectUtils.assertNotNull(file, "file");
        LiveConnectUtils.assertNotNull((Object)overwrite, "overwrite");
        if (listener == null) {
            listener = NULL_UPLOAD_OPERATION_LISTENER;
        }
        try {
            bytes = LiveConnectClient.toByteArray(file);
        }
        catch (IOException e) {
            LiveOperationException exception = new LiveOperationException("An error occured on the client during the operation.", e);
            return LiveConnectClient.handleException("PUT", path, exception, listener, userState);
        }
        try {
            request = this.createUploadRequest(path, filename, new ByteArrayInputStream(bytes), bytes.length, overwrite);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("PUT", path, e, listener, userState);
        }
        ApiRequestAsync<JSONObject> asyncRequest = ApiRequestAsync.newInstance(request);
        LiveOperation operation = new LiveOperation.Builder(request.getMethod(), request.getPath()).userState(userState).apiRequestAsync(asyncRequest).build();
        UploadRequestListener operationListener = new UploadRequestListener(operation, listener);
        asyncRequest.addObserver(operationListener);
        asyncRequest.addProgressObserver(operationListener);
        asyncRequest.execute(new Void[0]);
        return operation;
    }

    public LiveOperation uploadAsync(String path, String filename, InputStream input, LiveUploadOperationListener listener) {
        return this.uploadAsync(path, filename, input, listener, null);
    }

    public LiveOperation uploadAsync(String path, String filename, InputStream input, LiveUploadOperationListener listener, Object userState) {
        return this.uploadAsync(path, filename, input, OverwriteOption.DoNotOverwrite, listener, userState);
    }

    public LiveOperation uploadAsync(String path, String filename, File file, LiveUploadOperationListener listener) {
        return this.uploadAsync(path, filename, file, listener, null);
    }

    public LiveOperation uploadAsync(String path, String filename, File file, LiveUploadOperationListener listener, Object userState) {
        return this.uploadAsync(path, filename, file, OverwriteOption.DoNotOverwrite, listener, userState);
    }

    public LiveOperation uploadAsync(String path, String filename, File file, OverwriteOption overwrite, LiveUploadOperationListener listener, Object userState) {
        UploadRequest request;
        LiveConnectClient.assertValidPath(path);
        LiveConnectUtils.assertNotNullOrEmpty(filename, "filename");
        LiveConnectUtils.assertNotNull(file, "file");
        LiveConnectUtils.assertNotNull((Object)overwrite, "overwrite");
        if (listener == null) {
            listener = NULL_UPLOAD_OPERATION_LISTENER;
        }
        try {
            request = this.createUploadRequest(path, filename, new FileInputStream(file), file.length(), overwrite);
        }
        catch (LiveOperationException e) {
            return LiveConnectClient.handleException("PUT", path, e, listener, userState);
        }
        catch (FileNotFoundException e) {
            LiveOperationException exception = new LiveOperationException("An error occured on the client during the operation.", e);
            return LiveConnectClient.handleException("PUT", path, exception, listener, userState);
        }
        ApiRequestAsync<JSONObject> asyncRequest = ApiRequestAsync.newInstance(request);
        LiveOperation operation = new LiveOperation.Builder(request.getMethod(), request.getPath()).userState(userState).apiRequestAsync(asyncRequest).build();
        UploadRequestListener operationListener = new UploadRequestListener(operation, listener);
        asyncRequest.addObserver(operationListener);
        asyncRequest.addProgressObserver(operationListener);
        asyncRequest.execute(new Void[0]);
        return operation;
    }

    void setHttpClient(HttpClient client) {
        assert (client != null);
        this.httpClient = client;
    }

    private CopyRequest createCopyRequest(String path, String destination) throws LiveOperationException {
        assert (!TextUtils.isEmpty((CharSequence)path));
        assert (!TextUtils.isEmpty((CharSequence)destination));
        JSONObject body = LiveConnectClient.createJsonBody(DESTINATION_KEY, destination);
        JsonEntity entity = this.createJsonEntity(body);
        return new CopyRequest(this.session, this.httpClient, path, (HttpEntity)entity);
    }

    private JsonEntity createJsonEntity(JSONObject body) throws LiveOperationException {
        assert (body != null);
        try {
            return new JsonEntity(body);
        }
        catch (UnsupportedEncodingException e) {
            throw new LiveOperationException("An error occured on the client during the operation.", e);
        }
    }

    private MoveRequest createMoveRequest(String path, String destination) throws LiveOperationException {
        assert (!TextUtils.isEmpty((CharSequence)path));
        assert (!TextUtils.isEmpty((CharSequence)destination));
        JSONObject body = LiveConnectClient.createJsonBody(DESTINATION_KEY, destination);
        JsonEntity entity = this.createJsonEntity(body);
        return new MoveRequest(this.session, this.httpClient, path, (HttpEntity)entity);
    }

    private PostRequest createPostRequest(String path, JSONObject body) throws LiveOperationException {
        assert (!TextUtils.isEmpty((CharSequence)path));
        assert (body != null);
        JsonEntity entity = this.createJsonEntity(body);
        return new PostRequest(this.session, this.httpClient, path, (HttpEntity)entity);
    }

    private PutRequest createPutRequest(String path, JSONObject body) throws LiveOperationException {
        assert (!TextUtils.isEmpty((CharSequence)path));
        assert (body != null);
        JsonEntity entity = this.createJsonEntity(body);
        return new PutRequest(this.session, this.httpClient, path, (HttpEntity)entity);
    }

    private UploadRequest createUploadRequest(String path, String filename, InputStream is, long length, OverwriteOption overwrite) throws LiveOperationException {
        assert (!TextUtils.isEmpty((CharSequence)path));
        assert (!TextUtils.isEmpty((CharSequence)filename));
        assert (is != null);
        InputStreamEntity entity = new InputStreamEntity(is, length);
        return new UploadRequest(this.session, this.httpClient, path, (HttpEntity)entity, filename, overwrite);
    }

    private LiveOperation execute(ApiRequest<JSONObject> request) throws LiveOperationException {
        this.sessionState.check();
        JSONObject result = request.execute();
        LiveOperation.Builder builder = new LiveOperation.Builder(request.getMethod(), request.getPath()).result(result);
        return builder.build();
    }

    private LiveDownloadOperation executeAsync(ApiRequest<InputStream> request, LiveDownloadOperationListener listener, Object userState) {
        this.sessionState.check();
        ApiRequestAsync<InputStream> asyncRequest = ApiRequestAsync.newInstance(request);
        LiveDownloadOperation operation = new LiveDownloadOperation.Builder(request.getMethod(), request.getPath()).userState(userState).apiRequestAsync(asyncRequest).build();
        request.addObserver(new ContentLengthObserver(operation));
        asyncRequest.addObserver(new DownloadObserver(operation, listener));
        asyncRequest.execute(new Void[0]);
        return operation;
    }

    private LiveOperation executeAsync(ApiRequest<JSONObject> request, LiveOperationListener listener, Object userState) {
        this.sessionState.check();
        ApiRequestAsync<JSONObject> asyncRequest = ApiRequestAsync.newInstance(request);
        LiveOperation operation = new LiveOperation.Builder(request.getMethod(), request.getPath()).userState(userState).apiRequestAsync(asyncRequest).build();
        asyncRequest.addObserver(new OperationObserver(operation, listener));
        asyncRequest.execute(new Void[0]);
        return operation;
    }

    static {
        HTTP_CLIENT_LOCK = new Object();
        SOCKET_TIMEOUT_IN_MS = 30000;
        NULL_DOWNLOAD_OPERATION_LISTENER = new LiveDownloadOperationListener(){

            @Override
            public void onDownloadCompleted(LiveDownloadOperation operation) {
                assert (operation != null);
            }

            @Override
            public void onDownloadFailed(LiveOperationException exception, LiveDownloadOperation operation) {
                assert (exception != null);
                assert (operation != null);
            }

            @Override
            public void onDownloadProgress(int totalBytes, int bytesRemaining, LiveDownloadOperation operation) {
                assert (totalBytes >= 0);
                assert (bytesRemaining >= 0);
                assert (totalBytes >= bytesRemaining);
                assert (operation != null);
            }
        };
        NULL_OPERATION_LISTENER = new LiveOperationListener(){

            @Override
            public void onComplete(LiveOperation operation) {
                assert (operation != null);
            }

            @Override
            public void onError(LiveOperationException exception, LiveOperation operation) {
                assert (exception != null);
                assert (operation != null);
            }
        };
        NULL_UPLOAD_OPERATION_LISTENER = new LiveUploadOperationListener(){

            @Override
            public void onUploadCompleted(LiveOperation operation) {
                assert (operation != null);
            }

            @Override
            public void onUploadFailed(LiveOperationException exception, LiveOperation operation) {
                assert (exception != null);
                assert (operation != null);
            }

            @Override
            public void onUploadProgress(int totalBytes, int bytesRemaining, LiveOperation operation) {
                assert (totalBytes >= 0);
                assert (bytesRemaining >= 0);
                assert (totalBytes >= bytesRemaining);
                assert (operation != null);
            }
        };
    }

    private static class UploadRequestListener
    implements ApiRequestAsync.Observer<JSONObject>,
    ApiRequestAsync.ProgressObserver {
        private final LiveUploadOperationListener listener;
        private final LiveOperation operation;

        public UploadRequestListener(LiveOperation operation, LiveUploadOperationListener listener) {
            assert (operation != null);
            assert (listener != null);
            this.operation = operation;
            this.listener = listener;
        }

        @Override
        public void onComplete(JSONObject result) {
            this.operation.setResult(result);
            this.listener.onUploadCompleted(this.operation);
        }

        @Override
        public void onError(LiveOperationException e) {
            assert (e != null);
            this.listener.onUploadFailed(e, this.operation);
        }

        @Override
        public void onProgress(Long ... values) {
            long totalBytes = values[0];
            long numBytesWritten = values[1];
            assert (totalBytes >= 0L);
            assert (numBytesWritten >= 0L);
            assert (numBytesWritten <= totalBytes);
            long bytesRemaining = totalBytes - numBytesWritten;
            this.listener.onUploadProgress((int)totalBytes, (int)bytesRemaining, this.operation);
        }
    }

    private static enum SessionState {
        LOGGED_IN{

            @Override
            public void check() {
            }
        }
        ,
        LOGGED_OUT{

            @Override
            public void check() {
                throw new IllegalStateException("The user has is logged out.");
            }
        };


        public abstract void check();
    }

    private static final class ParamNames {
        public static final String ACCESS_TOKEN = "session.getAccessToken()";
        public static final String BODY = "body";
        public static final String DESTINATION = "destination";
        public static final String FILE = "file";
        public static final String FILENAME = "filename";
        public static final String OVERWRITE = "overwrite";
        public static final String PATH = "path";
        public static final String SESSION = "session";

        private ParamNames() {
            throw new AssertionError((Object)"Non-instantiable class");
        }
    }

    private static class OperationObserver
    implements ApiRequestAsync.Observer<JSONObject> {
        private final LiveOperationListener listener;
        private final LiveOperation operation;

        public OperationObserver(LiveOperation operation, LiveOperationListener listener) {
            assert (operation != null);
            assert (listener != null);
            this.operation = operation;
            this.listener = listener;
        }

        @Override
        public void onComplete(JSONObject result) {
            this.operation.setResult(result);
            this.listener.onComplete(this.operation);
        }

        @Override
        public void onError(LiveOperationException e) {
            this.listener.onError(e, this.operation);
        }
    }

    private static class FileDownloadObserver
    extends AsyncTask<InputStream, Integer, Runnable>
    implements ApiRequestAsync.Observer<InputStream> {
        private final File file;
        private final LiveDownloadOperationListener listener;
        private final LiveDownloadOperation operation;

        public FileDownloadObserver(LiveDownloadOperation operation, LiveDownloadOperationListener listener, File file) {
            assert (operation != null);
            assert (listener != null);
            assert (file != null);
            this.operation = operation;
            this.listener = listener;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Runnable doInBackground(InputStream ... params) {
            BufferedOutputStream out;
            InputStream is = params[0];
            byte[] buffer = new byte[BUFFER_SIZE];
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException e) {
                LiveOperationException exception = new LiveOperationException("An error occured on the client during the operation.", e);
                return new OnErrorRunnable(exception);
            }
            try {
                int bytesRead;
                int totalBytes;
                int bytesRemaining = totalBytes = this.operation.getContentLength();
                while ((bytesRead = is.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                    this.publishProgress(new Integer[]{totalBytes, bytesRemaining -= bytesRead});
                }
            }
            catch (IOException e) {
                LiveOperationException exception = new LiveOperationException("An error occured on the client during the operation.", e);
                OnErrorRunnable onErrorRunnable = new OnErrorRunnable(exception);
                return onErrorRunnable;
            }
            finally {
                LiveConnectClient.closeSilently(out);
                LiveConnectClient.closeSilently(is);
            }
            return new Runnable(){

                @Override
                public void run() {
                    FileDownloadObserver.this.listener.onDownloadCompleted(FileDownloadObserver.this.operation);
                }
            };
        }

        protected void onPostExecute(Runnable result) {
            result.run();
        }

        protected void onProgressUpdate(Integer ... values) {
            int totalBytes = values[0];
            int bytesRemaining = values[1];
            assert (totalBytes >= 0);
            assert (bytesRemaining >= 0);
            assert (totalBytes >= bytesRemaining);
            this.listener.onDownloadProgress(totalBytes, bytesRemaining, this.operation);
        }

        @Override
        public void onComplete(InputStream result) {
            this.execute(new InputStream[]{result});
        }

        @Override
        public void onError(LiveOperationException e) {
            this.listener.onDownloadFailed(e, this.operation);
        }

        private class OnErrorRunnable
        implements Runnable {
            private final LiveOperationException exception;

            public OnErrorRunnable(LiveOperationException exception) {
                this.exception = exception;
            }

            @Override
            public void run() {
                FileDownloadObserver.this.listener.onDownloadFailed(this.exception, FileDownloadObserver.this.operation);
            }
        }
    }

    private static class DownloadObserver
    implements ApiRequestAsync.Observer<InputStream> {
        private final LiveDownloadOperationListener listener;
        private final LiveDownloadOperation operation;

        public DownloadObserver(LiveDownloadOperation operation, LiveDownloadOperationListener listener) {
            assert (operation != null);
            assert (listener != null);
            this.operation = operation;
            this.listener = listener;
        }

        @Override
        public void onComplete(InputStream result) {
            this.operation.setStream(result);
            this.listener.onDownloadCompleted(this.operation);
        }

        @Override
        public void onError(LiveOperationException e) {
            this.listener.onDownloadFailed(e, this.operation);
        }
    }

    private static class ContentLengthObserver
    implements ApiRequest.Observer {
        private final LiveDownloadOperation operation;

        public ContentLengthObserver(LiveDownloadOperation operation) {
            assert (operation != null);
            this.operation = operation;
        }

        @Override
        public void onComplete(HttpResponse response) {
            Header header = response.getFirstHeader("Content-Length");
            if (header == null) {
                return;
            }
            int contentLength = Integer.valueOf(header.getValue());
            this.operation.setContentLength(contentLength);
        }
    }
}

