/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.text.TextUtils;
import com.microsoft.live.ApiRequestAsync;
import java.io.InputStream;

public class LiveDownloadOperation {
    private final ApiRequestAsync<InputStream> apiRequestAsync;
    private int contentLength;
    private final String method;
    private final String path;
    private InputStream stream;
    private final Object userState;

    LiveDownloadOperation(Builder builder) {
        this.apiRequestAsync = builder.apiRequestAsync;
        this.method = builder.method;
        this.path = builder.path;
        this.stream = builder.stream;
        this.userState = builder.userState;
    }

    public void cancel() {
        boolean isCancelable;
        boolean bl = isCancelable = this.apiRequestAsync != null;
        if (isCancelable) {
            this.apiRequestAsync.cancel(true);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public Object getUserState() {
        return this.userState;
    }

    void setContentLength(int contentLength) {
        assert (contentLength >= 0);
        this.contentLength = contentLength;
    }

    void setStream(InputStream stream) {
        assert (stream != null);
        this.stream = stream;
    }

    static class Builder {
        private ApiRequestAsync<InputStream> apiRequestAsync;
        private final String method;
        private final String path;
        private InputStream stream;
        private Object userState;

        public Builder(String method, String path) {
            assert (!TextUtils.isEmpty((CharSequence)method));
            assert (!TextUtils.isEmpty((CharSequence)path));
            this.method = method;
            this.path = path;
        }

        public Builder apiRequestAsync(ApiRequestAsync<InputStream> apiRequestAsync) {
            assert (apiRequestAsync != null);
            this.apiRequestAsync = apiRequestAsync;
            return this;
        }

        public LiveDownloadOperation build() {
            return new LiveDownloadOperation(this);
        }

        public Builder stream(InputStream stream) {
            assert (stream != null);
            this.stream = stream;
            return this;
        }

        public Builder userState(Object userState) {
            this.userState = userState;
            return this;
        }
    }
}

