/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.text.TextUtils;
import com.microsoft.live.ApiRequestAsync;
import org.json.JSONObject;

public class LiveOperation {
    private final ApiRequestAsync<JSONObject> apiRequestAsync;
    private final String method;
    private final String path;
    private JSONObject result;
    private final Object userState;

    private LiveOperation(Builder builder) {
        this.apiRequestAsync = builder.apiRequestAsync;
        this.method = builder.method;
        this.path = builder.path;
        this.result = builder.result;
        this.userState = builder.userState;
    }

    public void cancel() {
        boolean isCancelable;
        boolean bl = isCancelable = this.apiRequestAsync != null;
        if (isCancelable) {
            this.apiRequestAsync.cancel(true);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawResult() {
        JSONObject result = this.getResult();
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public JSONObject getResult() {
        return this.result;
    }

    public Object getUserState() {
        return this.userState;
    }

    void setResult(JSONObject result) {
        assert (result != null);
        this.result = result;
    }

    static class Builder {
        private ApiRequestAsync<JSONObject> apiRequestAsync;
        private final String method;
        private final String path;
        private JSONObject result;
        private Object userState;

        public Builder(String method, String path) {
            assert (!TextUtils.isEmpty((CharSequence)method));
            assert (!TextUtils.isEmpty((CharSequence)path));
            this.method = method;
            this.path = path;
        }

        public Builder apiRequestAsync(ApiRequestAsync<JSONObject> apiRequestAsync) {
            assert (apiRequestAsync != null);
            this.apiRequestAsync = apiRequestAsync;
            return this;
        }

        public LiveOperation build() {
            return new LiveOperation(this);
        }

        public Builder result(JSONObject result) {
            assert (result != null);
            this.result = result;
            return this;
        }

        public Builder userState(Object userState) {
            this.userState = userState;
            return this;
        }
    }
}

