/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import com.microsoft.live.LiveAuthException;
import com.microsoft.live.OAuth;
import com.microsoft.live.OAuthResponse;
import com.microsoft.live.OAuthResponseVisitor;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class OAuthErrorResponse
implements OAuthResponse {
    private final OAuth.ErrorType error;
    private final String errorDescription;
    private final String errorUri;

    public static OAuthErrorResponse createFromJson(JSONObject response) throws LiveAuthException {
        OAuth.ErrorType error;
        String errorString;
        try {
            errorString = response.getString("error");
        }
        catch (JSONException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        try {
            error = OAuth.ErrorType.valueOf(errorString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        catch (NullPointerException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        Builder builder = new Builder(error);
        if (response.has("error_description")) {
            String errorDescription;
            try {
                errorDescription = response.getString("error_description");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.errorDescription(errorDescription);
        }
        if (response.has("error_uri")) {
            String errorUri;
            try {
                errorUri = response.getString("error_uri");
            }
            catch (JSONException e) {
                throw new LiveAuthException("An error occured on the client during the operation.", e);
            }
            builder.errorUri(errorUri);
        }
        return builder.build();
    }

    public static boolean validOAuthErrorResponse(JSONObject response) {
        return response.has("error");
    }

    private OAuthErrorResponse(Builder builder) {
        this.error = builder.error;
        this.errorDescription = builder.errorDescription;
        this.errorUri = builder.errorUri;
    }

    @Override
    public void accept(OAuthResponseVisitor visitor) {
        visitor.visit(this);
    }

    public OAuth.ErrorType getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public String toString() {
        return String.format("OAuthErrorResponse [error=%s, errorDescription=%s, errorUri=%s]", this.error.toString().toLowerCase(Locale.US), this.errorDescription, this.errorUri);
    }

    public static class Builder {
        private final OAuth.ErrorType error;
        private String errorDescription;
        private String errorUri;

        public Builder(OAuth.ErrorType error) {
            assert (error != null);
            this.error = error;
        }

        public OAuthErrorResponse build() {
            return new OAuthErrorResponse(this);
        }

        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public Builder errorUri(String errorUri) {
            this.errorUri = errorUri;
            return this;
        }
    }
}

