/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.net.Uri;
import android.text.TextUtils;
import com.microsoft.live.Config;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.OAuthErrorResponse;
import com.microsoft.live.OAuthResponse;
import com.microsoft.live.OAuthSuccessfulResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

abstract class TokenRequest {
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded;charset=UTF-8";
    protected final HttpClient client;
    protected final String clientId;

    public TokenRequest(HttpClient client, String clientId) {
        assert (client != null);
        assert (clientId != null);
        assert (!TextUtils.isEmpty((CharSequence)clientId));
        this.client = client;
        this.clientId = clientId;
    }

    public OAuthResponse execute() throws LiveAuthException {
        JSONObject jsonResponse;
        String stringResponse;
        HttpResponse response;
        Uri requestUri = Config.INSTANCE.getOAuthTokenUri();
        HttpPost request = new HttpPost(requestUri.toString());
        ArrayList<NameValuePair> body = new ArrayList<NameValuePair>();
        body.add((NameValuePair)new BasicNameValuePair("client_id", this.clientId));
        this.constructBody(body);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(body, "UTF-8");
            entity.setContentType(CONTENT_TYPE);
            request.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            throw new LiveAuthException("An error occured on the client during the operation.", e);
        }
        try {
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        catch (IOException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        HttpEntity entity = response.getEntity();
        try {
            stringResponse = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        try {
            jsonResponse = new JSONObject(stringResponse);
        }
        catch (JSONException e) {
            throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.", e);
        }
        if (OAuthErrorResponse.validOAuthErrorResponse(jsonResponse)) {
            return OAuthErrorResponse.createFromJson(jsonResponse);
        }
        if (OAuthSuccessfulResponse.validOAuthSuccessfulResponse(jsonResponse)) {
            return OAuthSuccessfulResponse.createFromJson(jsonResponse);
        }
        throw new LiveAuthException("An error occured while communicating with the server during the operation. Please try again later.");
    }

    protected abstract void constructBody(List<NameValuePair> var1);
}

