/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.os.AsyncTask;
import com.microsoft.live.DefaultObservableOAuthRequest;
import com.microsoft.live.LiveAuthException;
import com.microsoft.live.OAuthRequestObserver;
import com.microsoft.live.OAuthResponse;
import com.microsoft.live.ObservableOAuthRequest;
import com.microsoft.live.TokenRequest;

class TokenRequestAsync
extends AsyncTask<Void, Void, Void>
implements ObservableOAuthRequest {
    private final DefaultObservableOAuthRequest observerable;
    private LiveAuthException exception;
    private OAuthResponse response;
    private final TokenRequest request;

    public TokenRequestAsync(TokenRequest request) {
        assert (request != null);
        this.observerable = new DefaultObservableOAuthRequest();
        this.request = request;
    }

    @Override
    public void addObserver(OAuthRequestObserver observer) {
        this.observerable.addObserver(observer);
    }

    @Override
    public boolean removeObserver(OAuthRequestObserver observer) {
        return this.observerable.removeObserver(observer);
    }

    protected Void doInBackground(Void ... params) {
        try {
            this.response = this.request.execute();
        }
        catch (LiveAuthException e) {
            this.exception = e;
        }
        return null;
    }

    protected void onPostExecute(Void result) {
        super.onPostExecute((Object)result);
        if (this.response != null) {
            this.observerable.notifyObservers(this.response);
        } else if (this.exception != null) {
            this.observerable.notifyObservers(this.exception);
        } else {
            LiveAuthException exception = new LiveAuthException("An error occured on the client during the operation.");
            this.observerable.notifyObservers(exception);
        }
    }
}

