/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.net.Uri;
import android.text.TextUtils;
import com.microsoft.live.ApiRequest;
import com.microsoft.live.EntityEnclosingApiRequest;
import com.microsoft.live.JsonResponseHandler;
import com.microsoft.live.LiveConnectSession;
import com.microsoft.live.LiveOperationException;
import com.microsoft.live.OverwriteOption;
import com.microsoft.live.UriBuilder;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;
import org.json.JSONObject;

class UploadRequest
extends EntityEnclosingApiRequest<JSONObject> {
    public static final String METHOD = "PUT";
    private static final String FILE_PATH = "file.";
    private static final String ERROR_KEY = "error";
    private static final String UPLOAD_LOCATION_KEY = "upload_location";
    private HttpUriRequest currentRequest;
    private final String filename;
    private final boolean isFileUpload;
    private final OverwriteOption overwrite;

    public UploadRequest(LiveConnectSession session, HttpClient client, String path, HttpEntity entity, String filename, OverwriteOption overwrite) {
        super(session, client, JsonResponseHandler.INSTANCE, path, entity, ApiRequest.ResponseCodes.SUPPRESS, ApiRequest.Redirects.UNSUPPRESSED);
        assert (!TextUtils.isEmpty((CharSequence)filename));
        this.filename = filename;
        this.overwrite = overwrite;
        String lowerCasePath = this.pathUri.getPath().toLowerCase(Locale.US);
        this.isFileUpload = lowerCasePath.indexOf(FILE_PATH) != -1;
    }

    @Override
    public String getMethod() {
        return METHOD;
    }

    @Override
    public JSONObject execute() throws LiveOperationException {
        UriBuilder uploadRequestUri;
        if (this.pathUri.isRelative()) {
            String uploadLocation;
            JSONObject response = this.getUploadLocation();
            if (response.has(ERROR_KEY)) {
                return response;
            }
            if (!response.has(UPLOAD_LOCATION_KEY)) {
                throw new LiveOperationException("The provided path does not contain an upload_location.");
            }
            try {
                uploadLocation = response.getString(UPLOAD_LOCATION_KEY);
            }
            catch (JSONException e) {
                throw new LiveOperationException("An error occured while communicating with the server during the operation. Please try again later.", e);
            }
            uploadRequestUri = UriBuilder.newInstance(Uri.parse((String)uploadLocation));
            uploadRequestUri.appendQueryString(this.pathUri.getQuery());
        } else {
            uploadRequestUri = this.requestUri;
        }
        if (!this.isFileUpload) {
            uploadRequestUri.appendToPath(this.filename);
            this.overwrite.appendQueryParameterOnTo(uploadRequestUri);
        }
        HttpPut uploadRequest = new HttpPut(uploadRequestUri.toString());
        uploadRequest.setEntity(this.entity);
        this.currentRequest = uploadRequest;
        return (JSONObject)super.execute();
    }

    @Override
    protected HttpUriRequest createHttpRequest() throws LiveOperationException {
        return this.currentRequest;
    }

    private JSONObject getUploadLocation() throws LiveOperationException {
        this.currentRequest = new HttpGet(this.requestUri.toString());
        return (JSONObject)super.execute();
    }
}

