/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.live;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.LinkedList;

class UriBuilder {
    private static final String EQUAL = "=";
    private static final String AMPERSAND = "&";
    private static final char FORWARD_SLASH = '/';
    private String scheme;
    private String host;
    private StringBuilder path;
    private final LinkedList<QueryParameter> queryParameters = new LinkedList();

    public static UriBuilder newInstance(Uri uri) {
        return new UriBuilder().scheme(uri.getScheme()).host(uri.getHost()).path(uri.getPath()).query(uri.getQuery());
    }

    public UriBuilder appendQueryParameter(String key, String value) {
        assert (key != null);
        assert (value != null);
        this.queryParameters.add(new QueryParameter(key, value));
        return this;
    }

    public UriBuilder appendQueryString(String queryString) {
        String[] pairs;
        if (queryString == null) {
            return this;
        }
        for (String pair : pairs = TextUtils.split((String)queryString, (String)AMPERSAND)) {
            String key;
            String[] splitPair = TextUtils.split((String)pair, (String)EQUAL);
            if (splitPair.length == 2) {
                key = splitPair[0];
                String value = splitPair[1];
                this.queryParameters.add(new QueryParameter(key, value));
                continue;
            }
            if (splitPair.length == 1) {
                key = splitPair[0];
                this.queryParameters.add(new QueryParameter(key));
                continue;
            }
            Log.w((String)"com.microsoft.live.UriBuilder", (String)("Invalid query parameter: " + pair));
        }
        return this;
    }

    public UriBuilder appendToPath(String path) {
        assert (path != null);
        if (this.path == null) {
            this.path = new StringBuilder(path);
        } else {
            boolean beginsWithSlash;
            boolean endsWithSlash = TextUtils.isEmpty((CharSequence)this.path) ? false : this.path.charAt(this.path.length() - 1) == '/';
            boolean pathIsEmpty = TextUtils.isEmpty((CharSequence)path);
            boolean bl = pathIsEmpty ? false : (beginsWithSlash = path.charAt(0) == '/');
            if (endsWithSlash && beginsWithSlash) {
                if (path.length() > 1) {
                    this.path.append(path.substring(1));
                }
            } else if (!endsWithSlash && !beginsWithSlash) {
                if (!pathIsEmpty) {
                    this.path.append('/').append(path);
                }
            } else {
                this.path.append(path);
            }
        }
        return this;
    }

    public Uri build() {
        return new Uri.Builder().scheme(this.scheme).authority(this.host).path(this.path == null ? "" : this.path.toString()).encodedQuery(TextUtils.join((CharSequence)AMPERSAND, this.queryParameters)).build();
    }

    public UriBuilder host(String host) {
        assert (host != null);
        this.host = host;
        return this;
    }

    public UriBuilder path(String path) {
        assert (path != null);
        this.path = new StringBuilder(path);
        return this;
    }

    public UriBuilder query(String queryString) {
        this.queryParameters.clear();
        return this.appendQueryString(queryString);
    }

    public UriBuilder removeQueryParametersWithKey(String key) {
        Iterator it = this.queryParameters.iterator();
        while (it.hasNext()) {
            QueryParameter qp = (QueryParameter)it.next();
            if (!qp.getKey().equals(key)) continue;
            it.remove();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) {
        assert (scheme != null);
        this.scheme = scheme;
        return this;
    }

    public String toString() {
        return this.build().toString();
    }

    public static class QueryParameter {
        private final String key;
        private final String value;

        public QueryParameter(String key) {
            assert (key != null);
            this.key = key;
            this.value = null;
        }

        public QueryParameter(String key, String value) {
            assert (key != null);
            assert (value != null);
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public String toString() {
            if (this.hasValue()) {
                return this.key + UriBuilder.EQUAL + this.value;
            }
            return this.key;
        }
    }
}

