/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import android.graphics.Bitmap;
import crl.android.pdfwriter.Indentifiers;
import crl.android.pdfwriter.IndirectObject;
import crl.android.pdfwriter.PDFDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.spaceroots.jarmor.ASCII85Encoder;

public class XObjectImage {
    public static final int BITSPERCOMPONENT_8 = 8;
    public static final String DEVICE_RGB = "/DeviceRGB";
    public static boolean INTERPOLATION = false;
    public static int BITSPERCOMPONENT = 8;
    public static String COLORSPACE = "/DeviceRGB";
    public static int COMPRESSION_LEVEL = 9;
    public static String ENCODING = "ISO-8859-1";
    protected int mImageCount = 0;
    protected PDFDocument mDocument;
    protected IndirectObject mIndirectObject;
    private int mDataSize = 0;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected String mName = "";
    protected String mId = "";
    private String mProcessedImage = "";

    public XObjectImage(PDFDocument document, Bitmap bitmap) {
        this.mDocument = document;
        this.mProcessedImage = this.processImage(this.configureBitmap(bitmap));
        this.mId = Indentifiers.generateId(this.mProcessedImage);
        this.mName = "/img" + ++this.mImageCount;
    }

    protected XObjectImage() {
    }

    public void appendToDocument() {
        this.mIndirectObject = this.mDocument.newIndirectObject();
        this.mDocument.includeIndirectObject(this.mIndirectObject);
        this.mIndirectObject.addDictionaryContent(" /Type /XObject\n /Subtype /Image\n /Filter [/ASCII85Decode /FlateDecode]\n /Width " + this.mWidth + "\n /Height " + this.mHeight + "\n /BitsPerComponent " + Integer.toString(BITSPERCOMPONENT) + "\n /Interpolate " + Boolean.toString(INTERPOLATION) + "\n /ColorSpace " + DEVICE_RGB + "\n /Length " + this.mProcessedImage.length() + "\n");
        this.mIndirectObject.addStreamContent(this.mProcessedImage);
    }

    private Bitmap configureBitmap(Bitmap bitmap) {
        Bitmap img = bitmap;
        if (!bitmap.getConfig().equals((Object)Bitmap.Config.ARGB_8888)) {
            img = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        if (img != null) {
            this.mWidth = img.getWidth();
            this.mHeight = img.getHeight();
            this.mDataSize = this.mWidth * this.mHeight * 3;
        }
        return img;
    }

    private byte[] getBitmapData(Bitmap bitmap) {
        byte[] data = null;
        if (bitmap != null) {
            data = new byte[this.mDataSize];
            int offset = 0;
            for (int y = 0; y < this.mHeight; ++y) {
                for (int x = 0; x < this.mWidth; ++x) {
                    int intColor = bitmap.getPixel(x, y);
                    data[offset++] = (byte)(intColor >> 16 & 0xFF);
                    data[offset++] = (byte)(intColor >> 8 & 0xFF);
                    data[offset++] = (byte)(intColor >> 0 & 0xFF);
                }
            }
        }
        return data;
    }

    private boolean deflateImageData(OutputStream baos, byte[] data) {
        if (data != null) {
            Deflater deflater = new Deflater(COMPRESSION_LEVEL);
            DeflaterOutputStream dos = new DeflaterOutputStream(baos, deflater);
            try {
                dos.write(data);
                dos.close();
                deflater.end();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private String processImage(Bitmap bitmap) {
        ByteArrayOutputStream sob = new ByteArrayOutputStream();
        ASCII85Encoder ascii = new ASCII85Encoder(sob, 120, null, "\n".getBytes());
        byte[] bitmapA = this.getBitmapData(bitmap);
        System.out.println("########: Bitmap size =" + bitmapA.length);
        if (this.deflateImageData(ascii, bitmapA)) {
            try {
                return sob.toString(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String asXObjectReference() {
        return this.mName + " " + this.mIndirectObject.getIndirectReference();
    }

    public String getName() {
        return this.mName;
    }

    public String getId() {
        return this.mId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }
}

