/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.JPGXObjectImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnclosedContent
extends Base {
    private String mBegin;
    private String mEnd;
    protected ArrayList<Object> content = new ArrayList();
    protected long length = 0L;

    public EnclosedContent() {
        this.clear();
    }

    public void setBeginKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        this.mBegin = NewLineBefore ? "\n" + Value : Value;
        if (NewLineAfter) {
            this.mBegin = this.mBegin + "\n";
        }
    }

    public void setEndKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        this.mEnd = NewLineBefore ? "\n" + Value : Value;
        if (NewLineAfter) {
            this.mEnd = this.mEnd + "\n";
        }
    }

    public boolean hasContent() {
        return this.content.size() > 0;
    }

    public void setContent(String Value) {
        this.clear();
        this.content.add(Value);
        this.length = Value.length();
    }

    public ArrayList<Object> getContent() {
        return this.content;
    }

    public long length() {
        return this.length;
    }

    public void addContent(Object o) {
        this.content.add(o);
        this.length = o instanceof String ? (this.length += (long)((String)o).length()) : (o instanceof JPGXObjectImage ? (this.length += ((JPGXObjectImage)o).getObjectSize()) : (this.length += ((EnclosedContent)o).length()));
    }

    public void addNewLine() {
        this.content.add("\n");
    }

    public void addSpace() {
        this.content.add(" ");
    }

    @Override
    public void clear() {
        this.content = new ArrayList();
    }

    @Override
    public String toPDFString() {
        StringBuilder b = new StringBuilder();
        for (Object o : this.content) {
            if (o instanceof String) {
                b.append((String)o);
                continue;
            }
            b.append(((EnclosedContent)o).toPDFString());
        }
        return this.mBegin + b.toString() + this.mEnd;
    }

    public int write(OutputStream out) throws IOException {
        int length = 0;
        if (this.content.size() > 0) {
            length += this.write(out, this.mBegin);
            for (int i = 0; i < this.content.size(); ++i) {
                Object o = this.content.get(i);
                if (o instanceof String) {
                    length += this.write(out, (String)o);
                    continue;
                }
                if (o instanceof JPGXObjectImage) {
                    length = (int)((long)length + ((JPGXObjectImage)o).writeStream(out));
                    length += this.write(out, "\n");
                    continue;
                }
                length += ((EnclosedContent)o).write(out);
            }
            length += this.write(out, this.mEnd);
        }
        return length;
    }
}

