package crl.android.pdfwriter;

import android.graphics.Rect;

/**
 * Representation of text annotation in PDF document
 */
public class Annotation {
    protected IndirectObject mIndirectObject;
    protected PDFDocument mDocument;
    protected Rect mRect;
    protected String mText;

    public Annotation(String text, Rect rect, PDFDocument document) {
        mText = text;
        mRect = rect;
        mDocument = document;
        mIndirectObject = mDocument.newIndirectObject();
        mDocument.includeIndirectObject(mIndirectObject);
        mIndirectObject.addDictionaryContent(
            " /Type /Annot\n" +
            " /Subtype /Text\n" +
            " /Rect [" + mRect.flattenToString() + "]\n" +
            " /Contents (" + mText + ")\n"
        );
    }

    /**
     *
     * @return Object that contains data about annotation
     */
    public IndirectObject getIndirectObject() {
        return mIndirectObject;
    }
}
