//
//  Android PDF Writer
//  http://coderesearchlabs.com/androidpdfwriter
//
//  by Javier Santo Domingo (j-a-s-d@coderesearchlabs.com)
//

package crl.android.pdfwriter;

import java.io.IOException;
import java.io.OutputStream;

public abstract class Base {
    public abstract void clear();

    public abstract String toPDFString();

    protected int write(OutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes();
        out.write(bytes);
        return bytes.length;
    }
}
