//
//  Android PDF Writer
//  http://coderesearchlabs.com/androidpdfwriter
//
//  by Javier Santo Domingo (j-a-s-d@coderesearchlabs.com)
//

package crl.android.pdfwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class EnclosedContent extends Base {

    private String mBegin;
    private String mEnd;
    //protected StringBuilder mContent;
    protected ArrayList<Object> content = new ArrayList<Object>();
    protected long length = 0;

    public EnclosedContent() {
        clear();
    }

    public void setBeginKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        if (NewLineBefore)
            mBegin = "\n" + Value;
        else
            mBegin = Value;
        if (NewLineAfter)
            mBegin += "\n";
    }

    public void setEndKeyword(String Value, boolean NewLineBefore, boolean NewLineAfter) {
        if (NewLineBefore)
            mEnd = "\n" + Value;
        else
            mEnd = Value;
        if (NewLineAfter)
            mEnd += "\n";
    }

    public boolean hasContent() {
        return content.size() > 0;
    }

    public void setContent(String Value) {
        clear();
        content.add(Value);
        length = Value.length();
    }

    public ArrayList<Object> getContent() {
        return content;
    }

    public long length(){
        return this.length;
    }

    public void addContent(Object o) {
        content.add(o);
        if(o instanceof String)
            length += ((String) o).length();
        else if (o instanceof JPGXObjectImage)
            length += ((JPGXObjectImage) o).getObjectSize();
        else
            length += ((EnclosedContent)o).length();
    }

    public void addNewLine() {
        content.add("\n");
    }

    public void addSpace() {
        content.add(" ");
    }

    @Override
    public void clear() {
        content = new ArrayList<Object>();
        //mContent = new StringBuilder();
    }

    @Override
    public String toPDFString() {
        StringBuilder b = new StringBuilder();
        for(Object o:content){
            if(o instanceof String)
                b.append((String)o);
            else
                b.append(((EnclosedContent)o).toPDFString());
        }

        return mBegin + b.toString() + mEnd;
    }

    public int write(OutputStream out) throws IOException {
        int length = 0;
        if(content.size()>0){
            length += write(out, mBegin);
            for(int i = 0; i<content.size();i++){
                Object o = content.get(i);
                if(o instanceof String)
                    length += write(out, (String) o);
                else if (o instanceof JPGXObjectImage){
                    length += ((JPGXObjectImage) o).writeStream(out);
                    length += write(out,"\n");
                }
                else
                    length += ((EnclosedContent)o).write(out);
            }
            length += write(out, mEnd);
        }
        return length;
    }
}
