package crl.android.pdfwriter;

import android.graphics.BitmapRegionDecoder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Created by a.koch on 6/25/13.
 */
public class JPGXObjectImage extends XObjectImage {

    private String path;
    private long objectSize;


    public JPGXObjectImage(PDFDocument document, String path) throws IOException {
        this.path = path;
        this.mDocument = document;
        this.mId = Indentifiers.generateId("" + System.currentTimeMillis());
        this.mName = "/img" + (++this.mImageCount);
        File fd = new File(path);
        this.objectSize = fd.length();
        BitmapRegionDecoder brd = BitmapRegionDecoder.newInstance(path, false);
        this.mWidth = brd.getWidth();
        this.mHeight = brd.getHeight();
    }

    public long getObjectSize() {
        return objectSize;
    }

    public void appendToDocument() {
        mIndirectObject = mDocument.newIndirectObject();
        mDocument.includeIndirectObject(mIndirectObject);
        mIndirectObject.addStreamContent(this);
        mIndirectObject.addDictionaryContent(
                " /Type /XObject\n" +
                        " /Subtype /Image\n" +
                        " /Filter /DCTDecode\n" +
                        " /Width " + mWidth + "\n" +
                        " /Height " + mHeight + "\n" +
                        " /BitsPerComponent " + Integer.toString(BITSPERCOMPONENT) + "\n" +
                        " /Interpolate " + Boolean.toString(INTERPOLATION) + "\n" +
                        " /ColorSpace " + DEVICE_RGB + "\n" +
                        " /Length " + objectSize + "\n"
        );
        //          /Name /X
    }

    public long writeStream(OutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.path);
            byte[] buffer = new byte[1024 * 15];
            int read;
            while ((read = in.read(buffer)) > -1)
                out.write(buffer, 0, read);
        } finally {
            if (in != null) in.close();
        }
        return this.objectSize;
    }
}
