/*
 * Decompiled with CFR 0.152.
 */
package crl.android.pdfwriter;

import crl.android.pdfwriter.Base;
import crl.android.pdfwriter.Dictionary;
import crl.android.pdfwriter.EnclosedContent;
import crl.android.pdfwriter.IndirectIdentifier;
import crl.android.pdfwriter.Stream;
import java.io.IOException;
import java.io.OutputStream;

public class IndirectObject
extends Base {
    private EnclosedContent mContent;
    private Dictionary mDictionaryContent;
    private Stream mStreamContent;
    private IndirectIdentifier mID;
    private int mByteOffset;
    private boolean mInUse;

    public IndirectObject() {
        this.clear();
    }

    public void setNumberID(int Value) {
        this.mID.setNumber(Value);
    }

    public int getNumberID() {
        return this.mID.getNumber();
    }

    public void setGeneration(int Value) {
        this.mID.setGeneration(Value);
    }

    public int getGeneration() {
        return this.mID.getGeneration();
    }

    public String getIndirectReference() {
        return this.mID.toPDFString() + " R";
    }

    public void setByteOffset(int Value) {
        this.mByteOffset = Value;
    }

    public int getByteOffset() {
        return this.mByteOffset;
    }

    public void setInUse(boolean Value) {
        this.mInUse = Value;
    }

    public boolean getInUse() {
        return this.mInUse;
    }

    public void addContent(String Value) {
        this.mContent.addContent(Value);
    }

    public void setContent(String Value) {
        this.mContent.setContent(Value);
    }

    public void addDictionaryContent(String Value) {
        this.mDictionaryContent.addContent(Value);
    }

    public void setDictionaryContent(String Value) {
        this.mDictionaryContent.setContent(Value);
    }

    public void addStreamContent(Object value) {
        this.mStreamContent.addContent(value);
        this.setDictionaryContent("  /Length " + Long.toString(this.mStreamContent.length()) + "\n");
    }

    public void setStreamContent(String Value) {
        this.mStreamContent.setContent(Value);
    }

    protected String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mID.toPDFString());
        sb.append(" ");
        if (this.mDictionaryContent.hasContent()) {
            this.mContent.setContent(this.mDictionaryContent.toPDFString());
            if (this.mStreamContent.hasContent()) {
                this.mContent.addContent(this.mStreamContent.toPDFString());
            }
        }
        sb.append(this.mContent.toPDFString());
        return sb.toString();
    }

    public void clear() {
        this.mID = new IndirectIdentifier();
        this.mByteOffset = 0;
        this.mInUse = false;
        this.mContent = new EnclosedContent();
        this.mContent.setBeginKeyword("obj", false, true);
        this.mContent.setEndKeyword("endobj", false, true);
        this.mDictionaryContent = new Dictionary();
        this.mStreamContent = new Stream();
    }

    public String toPDFString() {
        return this.render();
    }

    public int write(OutputStream out) throws IOException {
        int bytesWritten = this.mID.write(out);
        bytesWritten += this.write(out, " ");
        if (this.mDictionaryContent.hasContent()) {
            this.mContent.setContent(this.mDictionaryContent.toPDFString());
            if (this.mStreamContent.hasContent()) {
                this.mContent.addContent(this.mStreamContent);
            }
        }
        return bytesWritten += this.mContent.write(out);
    }
}

