/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.jarmor;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85Encoder
extends FilterOutputStream {
    private int lineLength;
    private byte[] sol;
    private byte[] eol;
    private int c1;
    private int c2;
    private int c3;
    private int c4;
    private int c5;
    private int phase;
    private int length;

    public ASCII85Encoder(OutputStream out) {
        super(out);
        this.lineLength = -1;
        this.c1 = -1;
        this.phase = 4;
    }

    public ASCII85Encoder(OutputStream out, int lineLength, byte[] sol, byte[] eol) {
        super(out);
        this.lineLength = lineLength;
        this.sol = sol;
        this.eol = eol;
        this.c1 = -1;
        this.phase = 4;
    }

    @Override
    public void close() throws IOException {
        if (this.c1 >= 0) {
            this.c4 += this.c5 / 85;
            this.c3 += this.c4 / 85;
            this.c2 += this.c3 / 85;
            this.c1 += this.c2 / 85;
            this.putByte(33 + this.c1);
            this.putByte(33 + this.c2 % 85);
            if (this.phase > 1) {
                this.putByte(33 + this.c3 % 85);
                if (this.phase > 2) {
                    this.putByte(33 + this.c4 % 85);
                    if (this.phase > 3) {
                        this.putByte(33 + this.c5 % 85);
                    }
                }
            }
            this.putByte(126);
            this.putByte(62);
        }
        if (this.length != 0) {
            this.out.write(this.eol, 0, this.eol.length);
        }
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        b &= 0xFF;
        switch (this.phase) {
            case 1: {
                this.c3 += 9 * b;
                this.c4 += 6 * b;
                this.c5 += b;
                this.phase = 2;
                break;
            }
            case 2: {
                this.c4 += 3 * b;
                this.c5 += b;
                this.phase = 3;
                break;
            }
            case 3: {
                this.c5 += b;
                this.phase = 4;
                break;
            }
            default: {
                if (this.c1 >= 0) {
                    if (this.c1 == 0 && this.c2 == 0 && this.c3 == 0 && this.c4 == 0 && this.c5 == 0) {
                        this.putByte(122);
                    } else {
                        this.c4 += this.c5 / 85;
                        this.c3 += this.c4 / 85;
                        this.c2 += this.c3 / 85;
                        this.c1 += this.c2 / 85;
                        this.putByte(33 + this.c1);
                        this.putByte(33 + this.c2 % 85);
                        this.putByte(33 + this.c3 % 85);
                        this.putByte(33 + this.c4 % 85);
                        this.putByte(33 + this.c5 % 85);
                    }
                }
                this.c1 = 0;
                this.c3 = this.c2 = 27 * b;
                this.c4 = 9 * b;
                this.c5 = b;
                this.phase = 1;
            }
        }
    }

    private void putByte(int b) throws IOException {
        if (this.lineLength >= 0) {
            if (this.length == 0 && this.sol != null) {
                this.out.write(this.sol, 0, this.sol.length);
                this.length = this.sol.length;
            }
            this.out.write(b);
            if (++this.length >= this.lineLength) {
                this.out.write(this.eol, 0, this.eol.length);
                this.length = 0;
            }
        } else {
            this.out.write(b);
        }
    }
}

