/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.ChecksSdkIntAtLeast;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeScannerFrameHandler;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.IBarcodeScanner;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 42\u00020\u0001:\u0006567849B\u0017\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\b0\u00101B\u0019\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010/\u001a\u000202\u00a2\u0006\u0004\b0\u00103J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001c\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001dR\u0018\u0010%\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\"\u0010'\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010#\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;", "", "", "barcodesScanned", "()V", "", "sensitivity", "setSensitivity", "(F)V", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "callback", "setAutoSnappingCallback", "(Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;)V", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "getCameraView", "()Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "Ljava/util/concurrent/atomic/AtomicLong;", "captureInterval", "Ljava/util/concurrent/atomic/AtomicLong;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "", "lastCapture", "J", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isResumed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Landroid/os/Handler;", "mainThreadHandler", "Landroid/os/Handler;", "", "shouldTryAcquireFocus", "Z", "isAutoSnappingShooting", "autoSnappingCallback", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "isEnabled", "()Z", "setEnabled", "(Z)V", "Ljava/lang/Runnable;", "autoSnappingShoot", "Ljava/lang/Runnable;", "Lio/scanbot/sdk/camera/FrameHandler;", "frameHandler", "<init>", "(Lio/scanbot/sdk/ui/camera/IScanbotCameraView;Lio/scanbot/sdk/camera/FrameHandler;)V", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler;", "(Lio/scanbot/sdk/ui/camera/IScanbotCameraView;Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler;)V", "Companion", "AutoSnappingCallback", "a", "b", "c", "d", "sdk-barcode_release"})
public final class BarcodeAutoSnappingController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    @NotNull
    private final IScanbotCameraView cameraView;
    @NotNull
    private final AtomicLong captureInterval;
    @NotNull
    private final Logger logger;
    private long lastCapture;
    @NotNull
    private AtomicBoolean isResumed;
    @NotNull
    private final Handler mainThreadHandler;
    @ChecksSdkIntAtLeast(api=24)
    private final boolean shouldTryAcquireFocus;
    @NotNull
    private final AtomicBoolean isAutoSnappingShooting;
    @Nullable
    private AutoSnappingCallback autoSnappingCallback;
    private boolean isEnabled;
    @NotNull
    private final Runnable autoSnappingShoot;

    /*
     * WARNING - void declaration
     */
    public BarcodeAutoSnappingController(@NotNull IScanbotCameraView cameraView, @NotNull FrameHandler frameHandler2) {
        void var2_2;
        void var1_1;
        BarcodeAutoSnappingController barcodeAutoSnappingController = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"frameHandler");
        barcodeAutoSnappingController.cameraView = var1_1;
        barcodeAutoSnappingController.captureInterval = new AtomicLong(1000L);
        barcodeAutoSnappingController.logger = LoggerProvider.getLogger();
        barcodeAutoSnappingController.isResumed = new AtomicBoolean(false);
        barcodeAutoSnappingController.mainThreadHandler = new Handler(Looper.getMainLooper());
        boolean bl = Build.VERSION.SDK_INT < 24;
        void v1 = var1_1;
        this.shouldTryAcquireFocus = bl;
        this.isAutoSnappingShooting = new AtomicBoolean(false);
        this.isEnabled = true;
        this.autoSnappingShoot = () -> BarcodeAutoSnappingController.autoSnappingShoot$lambda$1(this);
        v1.addFrameHandler((FrameHandler)var2_2);
        v1.addPictureCallback((BasePictureCallback)new d(this));
        v1.addCameraStateCallback((CameraStateCallback)new b(this));
        v1.addTakePictureCallback((CameraTakePictureCallback)new c(this));
    }

    /*
     * WARNING - void declaration
     */
    public BarcodeAutoSnappingController(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScannerFrameHandler frameHandler2) {
        a a2;
        void var2_2;
        a a3;
        Intrinsics.checkNotNullParameter((Object)a3, (String)"cameraView");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"frameHandler");
        this((IScanbotCameraView)a3, (FrameHandler)var2_2);
        a3 = a2;
        a2 = new a(this);
        frameHandler2.addResultHandler(a3);
    }

    private final void barcodesScanned() {
        if (!this.isAutoSnappingShooting.get()) {
            BarcodeAutoSnappingController barcodeAutoSnappingController = this;
            barcodeAutoSnappingController.isAutoSnappingShooting.set(true);
            barcodeAutoSnappingController.mainThreadHandler.post(this.autoSnappingShoot);
        }
    }

    private static final void autoSnappingShoot$lambda$1(BarcodeAutoSnappingController this$0) {
        BarcodeAutoSnappingController barcodeAutoSnappingController;
        BarcodeAutoSnappingController barcodeAutoSnappingController2 = this$0;
        Intrinsics.checkNotNullParameter((Object)barcodeAutoSnappingController2, (String)"this$0");
        if (!barcodeAutoSnappingController2.isEnabled) {
            barcodeAutoSnappingController.isAutoSnappingShooting.set(false);
            return;
        }
        AutoSnappingCallback autoSnappingCallback = barcodeAutoSnappingController.autoSnappingCallback;
        if (autoSnappingCallback == null || !autoSnappingCallback.onAutoSnapping()) {
            barcodeAutoSnappingController.cameraView.takePicture(barcodeAutoSnappingController.shouldTryAcquireFocus, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final BarcodeAutoSnappingController attach(@NotNull IScanbotCameraView cameraView, @NotNull IBarcodeScanner barcodeScanner) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (IBarcodeScanner)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final BarcodeAutoSnappingController attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScannerFrameHandler frameHandler2) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (BarcodeScannerFrameHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setLastCapture$p(BarcodeAutoSnappingController $this, long l) {
        void var1_1;
        $this.lastCapture = var1_1;
    }

    @NotNull
    public final IScanbotCameraView getCameraView() {
        return this.cameraView;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnabled(boolean bl) {
        void var1_1;
        this.isEnabled = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSensitivity(float sensitivity) {
        void var1_2;
        this.logger.logMethod();
        float f2 = 1.0f - RangesKt.coerceIn((float)var1_2, (float)0.0f, (float)1.0f);
        this.captureInterval.set((long)(f2 * (float)3000L));
    }

    /*
     * WARNING - void declaration
     */
    public final void setAutoSnappingCallback(@Nullable AutoSnappingCallback callback) {
        void var1_1;
        this.logger.logMethod();
        this.autoSnappingCallback = var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$AutoSnappingCallback;", "", "onAutoSnapping", "", "sdk-barcode_release"})
    public static interface AutoSnappingCallback {
        public boolean onAutoSnapping();
    }

    public final class a
    implements BarcodeScannerFrameHandler.ResultHandler {
        public final /* synthetic */ BarcodeAutoSnappingController a;

        /*
         * WARNING - void declaration
         */
        public a(BarcodeAutoSnappingController this$0) {
            void var1_1;
            this.a = var1_1;
        }

        public static final void a(BarcodeAutoSnappingController this$0) {
            BarcodeAutoSnappingController barcodeAutoSnappingController = this$0;
            Intrinsics.checkNotNullParameter((Object)barcodeAutoSnappingController, (String)"this$0");
            barcodeAutoSnappingController.barcodesScanned();
        }

        public boolean handle(@NotNull FrameHandlerResult<BarcodeScannerResult, SdkLicenseError> result) {
            BarcodeScannerResult barcodeScannerResult;
            Intrinsics.checkNotNullParameter((Object)barcodeScannerResult, (String)"result");
            this.a.logger.logMethod();
            if (result instanceof FrameHandlerResult.Success) {
                barcodeScannerResult = (BarcodeScannerResult)((FrameHandlerResult.Success)barcodeScannerResult).getValue();
                if (this.a.isResumed.get() && barcodeScannerResult != null && barcodeScannerResult.getBarcodes().isEmpty() ^ true && SystemClock.elapsedRealtime() - this.a.lastCapture > this.a.captureInterval.get()) {
                    if (this.a.lastCapture != 0L) {
                        this.a();
                    }
                    BarcodeAutoSnappingController.access$setLastCapture$p(this.a, SystemClock.elapsedRealtime());
                }
            }
            return false;
        }

        public final void a() {
            this.a.mainThreadHandler.post(() -> a.a(this.a));
        }
    }

    public final class b
    implements CameraStateCallback {
        public final /* synthetic */ BarcodeAutoSnappingController a;

        /*
         * WARNING - void declaration
         */
        public b(BarcodeAutoSnappingController this$0) {
            void var1_1;
            this.a = var1_1;
        }

        public void onResume() {
            this.a.isResumed.set(true);
        }

        public void onPause() {
            b b2 = this;
            b2.a.isAutoSnappingShooting.set(false);
            b2.a.isResumed.set(false);
            BarcodeAutoSnappingController.access$setLastCapture$p(b2.a, 0L);
        }
    }

    public final class c
    implements CameraTakePictureCallback {
        public final /* synthetic */ BarcodeAutoSnappingController a;

        /*
         * WARNING - void declaration
         */
        public c(BarcodeAutoSnappingController this$0) {
            void var1_1;
            this.a = var1_1;
        }

        public void onTakePictureRequested() {
        }

        public void onTakePictureCancelled() {
            c c2 = this;
            c2.a.mainThreadHandler.removeCallbacksAndMessages(null);
            c2.a.isAutoSnappingShooting.set(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController$Companion;", "", "()V", "DEFAULT_CAPTURE_INTERVAL_MS", "", "MAXIMUM_CAPTURE_INTERVAL", "attach", "Lio/scanbot/sdk/barcode/BarcodeAutoSnappingController;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "frameHandler", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler;", "barcodeScanner", "Lio/scanbot/sdk/barcode/IBarcodeScanner;", "sdk-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BarcodeAutoSnappingController attach(@NotNull IScanbotCameraView cameraView, @NotNull IBarcodeScanner barcodeScanner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"barcodeScanner");
            BarcodeScannerFrameHandler barcodeScannerFrameHandler = (BarcodeScannerFrameHandler)cameraView.getAttachedFrameHandler(BarcodeScannerFrameHandler.class);
            if (barcodeScannerFrameHandler == null) {
                BarcodeScannerFrameHandler barcodeScannerFrameHandler2;
                barcodeScannerFrameHandler = barcodeScannerFrameHandler2;
                barcodeScannerFrameHandler2 = new BarcodeScannerFrameHandler((IBarcodeScanner)var2_2);
            }
            void v1 = var1_1;
            v1.addFrameHandler((FrameHandler)barcodeScannerFrameHandler);
            return this.attach((IScanbotCameraView)v1, barcodeScannerFrameHandler);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final BarcodeAutoSnappingController attach(@NotNull IScanbotCameraView cameraView, @NotNull BarcodeScannerFrameHandler frameHandler2) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)((Object)frameHandler2), (String)"frameHandler");
            return new BarcodeAutoSnappingController((IScanbotCameraView)var1_1, (BarcodeScannerFrameHandler)var2_2);
        }
    }

    public final class d
    extends PictureCallback {
        public final /* synthetic */ BarcodeAutoSnappingController a;

        /*
         * WARNING - void declaration
         */
        public d(BarcodeAutoSnappingController this$0) {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void onPictureTaken(@NotNull ImageRef image, @NotNull CaptureInfo captureInfo) {
            void var2_2;
            void var1_1;
            d d2 = this;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"image");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"captureInfo");
            d2.a.mainThreadHandler.removeCallbacksAndMessages(null);
            d2.a.isAutoSnappingShooting.set(false);
        }
    }
}

