/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.barcode.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.lifecycle.LifecycleOwner;
import io.scanbot.common.Result;
import io.scanbot.common.ResultKt;
import io.scanbot.sdk.barcode.BarcodeCounterFrameHandler;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeItemKt;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.BarcodeScannerConfiguration;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.IBarcodeScanner;
import io.scanbot.sdk.barcode.R;
import io.scanbot.sdk.barcode.databinding.ScanbotSdkBarcodeScanCountViewBinding;
import io.scanbot.sdk.barcode.ui.BarcodePolygonsStaticView;
import io.scanbot.sdk.barcode.ui.BarcodeScanAndCountView;
import io.scanbot.sdk.barcode.ui.CaptureMode;
import io.scanbot.sdk.barcode.ui.IBarcodeCounterView;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountSelectionOverlayController;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewCallback;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewCameraConfiguration;
import io.scanbot.sdk.barcode.ui.IBarcodeScanCountViewController;
import io.scanbot.sdk.camera.BasePictureCallback;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CaptureCallback;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.ZoomRange;
import io.scanbot.sdk.image.ImageInfo;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ScanbotCameraXView;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001?B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170.H\u0002J\b\u0010/\u001a\u00020&H\u0002J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0016H\u0002J\b\u00105\u001a\u00020,H\u0016J\u001a\u00106\u001a\u00020,2\u0006\u0010\b\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u00109\u001a\u00020,H\u0014J\b\u0010:\u001a\u00020,H\u0014J\u0018\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/barcode/ui/IBarcodeCounterView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "barcodeScannerViewInterface", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCallback;", "binding", "Lio/scanbot/sdk/barcode/databinding/ScanbotSdkBarcodeScanCountViewBinding;", "cameraConfiguration", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCameraConfiguration;", "getCameraConfiguration", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewCameraConfiguration;", "captureMode", "Lio/scanbot/sdk/barcode/ui/CaptureMode;", "<set-?>", "", "Lio/scanbot/sdk/barcode/BarcodeItem;", "", "countedBarcodes", "getCountedBarcodes", "()Ljava/util/Map;", "counterOverlayController", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountSelectionOverlayController;", "getCounterOverlayController", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountSelectionOverlayController;", "frameHandler", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler;", "resultHandler", "Lio/scanbot/sdk/barcode/BarcodeCounterFrameHandler$ResultHandler;", "scanState", "Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView$ScanState;", "snapExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "viewController", "Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewController;", "getViewController", "()Lio/scanbot/sdk/barcode/ui/IBarcodeScanCountViewController;", "appendBarcodeItem", "", "barcodeItem", "", "createSingleThreadPoolExecutor", "dpToPx", "dp", "getBarcodeItemUUID", "", "it", "initCamera", "initScanningBehavior", "Lio/scanbot/sdk/barcode/IBarcodeScanner;", "callback", "onAttachedToWindow", "onDetachedFromWindow", "processPictureTaken", "image", "Lio/scanbot/sdk/image/ImageRef;", "imageOrientation", "ScanState", "sdk-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeScanAndCountView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeScanAndCountView.kt\nio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,382:1\n1#2:383\n1#2:387\n1#2:389\n288#3,2:384\n2634#3:386\n2634#3:388\n*S KotlinDebug\n*F\n+ 1 BarcodeScanAndCountView.kt\nio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView\n*L\n77#1:387\n365#1:389\n320#1:384,2\n77#1:386\n365#1:388\n*E\n"})
public final class BarcodeScanAndCountView
extends FrameLayout
implements IBarcodeCounterView {
    @Nullable
    private IBarcodeScanCountViewCallback barcodeScannerViewInterface;
    private BarcodeCounterFrameHandler frameHandler;
    @NotNull
    private ScanState scanState;
    @NotNull
    private ScanbotSdkBarcodeScanCountViewBinding binding;
    @NotNull
    private ThreadPoolExecutor snapExecutor;
    private BarcodeScanner barcodeScanner;
    @NotNull
    private CaptureMode captureMode;
    @NotNull
    private Map<BarcodeItem, Integer> countedBarcodes;
    @NotNull
    private final BarcodeCounterFrameHandler.ResultHandler resultHandler;
    @NotNull
    private final IBarcodeScanCountViewController viewController;
    @NotNull
    private final IBarcodeScanCountViewCameraConfiguration cameraConfiguration;
    @NotNull
    private final IBarcodeScanCountSelectionOverlayController counterOverlayController;

    /*
     * WARNING - void declaration
     */
    public BarcodeScanAndCountView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        void var1_1;
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        this.scanState = ScanState.IDLE;
        ScanbotSdkBarcodeScanCountViewBinding scanbotSdkBarcodeScanCountViewBinding = ScanbotSdkBarcodeScanCountViewBinding.inflate(LayoutInflater.from((Context)var1_1), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkBarcodeScanCountViewBinding, (String)"inflate(...)");
        barcodeScanAndCountView.binding = scanbotSdkBarcodeScanCountViewBinding;
        barcodeScanAndCountView.snapExecutor = barcodeScanAndCountView.createSingleThreadPoolExecutor();
        barcodeScanAndCountView.captureMode = CaptureMode.FRAME;
        barcodeScanAndCountView.countedBarcodes = MapsKt.emptyMap();
        barcodeScanAndCountView.resultHandler = arg_0 -> BarcodeScanAndCountView.resultHandler$lambda$3(barcodeScanAndCountView, arg_0);
        barcodeScanAndCountView.viewController = new IBarcodeScanCountViewController(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            private static final void scanAndCount$lambda$0(BarcodeScanAndCountView this$0) {
                BarcodeScanAndCountView barcodeScanAndCountView = this$0;
                Intrinsics.checkNotNullParameter((Object)barcodeScanAndCountView, (String)"this$0");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)barcodeScanAndCountView).scanbotCameraView.freezePreview();
            }

            public void scanAndCount() {
                if (BarcodeScanAndCountView.access$getScanState$p(this.this$0) == ScanState.IDLE) {
                    Object object = BarcodeScanAndCountView.access$getBarcodeScannerViewInterface$p(this.this$0);
                    if (object != null) {
                        object.onScanAndCountStarted();
                    }
                    if (BarcodeScanAndCountView.access$getCaptureMode$p(this.this$0) == CaptureMode.FRAME) {
                        object = BarcodeScanAndCountView.access$getFrameHandler$p(this.this$0);
                        if (object == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                            object = null;
                        }
                        ((BarcodeCounterFrameHandler)((Object)object)).performSingleShotScan();
                        BarcodeScanAndCountView barcodeScanAndCountView = this.this$0;
                        barcodeScanAndCountView.post(() -> viewController.1.scanAndCount$lambda$0(barcodeScanAndCountView));
                    } else {
                        viewController.1 v1 = this;
                        BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v1.this$0).barcodesPolygonView.getFrameHandler().setEnabled(false);
                        BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v1.this$0).scanbotCameraView.takePicture(false);
                    }
                    BarcodeScanAndCountView.access$setScanState$p(this.this$0, ScanState.SCANNING);
                }
            }

            public void clearCountedBarcodes() {
                viewController.1 v0 = this;
                BarcodeScanAndCountView.access$setCountedBarcodes$p(v0.this$0, MapsKt.emptyMap());
                v0.continueScanning();
            }

            public void continueScanning() {
                if (BarcodeScanAndCountView.access$getScanState$p(this.this$0) == ScanState.RESULT) {
                    viewController.1 v0 = this;
                    BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v0.this$0).barcodesPolygonView.clearBarcodes();
                    BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)v0.this$0).scanbotCameraView.unfreezePreview();
                    BarcodeScanAndCountView.access$setScanState$p(v0.this$0, ScanState.IDLE);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setCaptureMode(@NotNull CaptureMode mode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"mode");
                BarcodeScanAndCountView.access$setCaptureMode$p(this.this$0, (CaptureMode)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setLifecycleOwner(@NotNull LifecycleOwner lifecycleOwner) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"lifecycleOwner");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setLifecycleOwner((LifecycleOwner)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void takePicture(boolean acquireFocus) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.takePicture((boolean)var1_1);
            }

            public void startPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.startPreview();
            }

            public void stopPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.stopPreview();
            }

            public void restartPreview() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.restartPreview();
            }

            public void continuousFocus() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.continuousFocus();
            }

            /*
             * WARNING - void declaration
             */
            public void useFlash(boolean flash) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.useFlash((boolean)var1_1);
            }
        };
        barcodeScanAndCountView.cameraConfiguration = new IBarcodeScanCountViewCameraConfiguration(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public long getDelayAfterFocusCompleteMs() {
                return BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.getDelayAfterFocusCompleteMs();
            }

            /*
             * WARNING - void declaration
             */
            public void setDelayAfterFocusCompleteMs(long value) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setDelayAfterFocusCompleteMs((long)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraPreviewMode");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPreviewMode((CameraPreviewMode)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
                int n = cameraConfiguration.WhenMappings.$EnumSwitchMapping$0[var1_1.ordinal()];
                if (n != 1) {
                    if (n == 2) {
                        BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockToLandscape(true);
                    }
                } else {
                    BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockToPortrait(true);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setPhysicalZoomRatio(float zoomRatio) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPhysicalZoom((float)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setPhysicalZoomRange(@NotNull ZoomRange zoomRange) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"zoomRange");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setPhysicalZoomRange((ZoomRange)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setCameraModule(@NotNull CameraModule cameraModule) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraModule");
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setCameraModule((CameraModule)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setShutterSound(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setShutterSound((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setForceMaxSnappingSize(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setForceMaxSnappingSize((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setForceMaxSnappingQuality(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setForceMaxSnappingQuality((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void lockMinFocusDistance(boolean lock) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.lockMinFocusDistance((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setAutoFocusOnTouch(boolean enabled) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setAutoFocusOnTouch((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setAnalyzerFpsLimit(float fps) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.setAnalyzerFpsLimit((float)var1_1);
            }
        };
        barcodeScanAndCountView.counterOverlayController = new IBarcodeScanCountSelectionOverlayController(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewFactory(@Nullable BarcodePolygonsStaticView.BarcodeItemViewFactory barcodeItemViewFactory2) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewFactory((BarcodePolygonsStaticView.BarcodeItemViewFactory)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewBinder(@Nullable BarcodePolygonsStaticView.BarcodeItemViewBinder binder) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewBinder((BarcodePolygonsStaticView.BarcodeItemViewBinder)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeItemViewPositionHandler(@Nullable BarcodePolygonsStaticView.BarcodeItemViewPositionHandler positionHandler) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeItemViewPositionHandler((BarcodePolygonsStaticView.BarcodeItemViewPositionHandler)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeAcceptedDelegate(@Nullable BarcodePolygonsStaticView.BarcodeAcceptanceDelegate delegate) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeAcceptanceDelegate((BarcodePolygonsStaticView.BarcodeAcceptanceDelegate)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void setBarcodeAppearanceDelegate(@Nullable BarcodePolygonsStaticView.BarcodeAppearanceDelegate delegate) {
                void var1_1;
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).barcodesPolygonView.setBarcodeAppearanceDelegate((BarcodePolygonsStaticView.BarcodeAppearanceDelegate)var1_1);
            }
        };
    }

    public /* synthetic */ BarcodeScanAndCountView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final ThreadPoolExecutor createSingleThreadPoolExecutor() {
        ThreadPoolExecutor.DiscardPolicy discardPolicy;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        Object object = TimeUnit.MILLISECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor.DiscardPolicy discardPolicy2 = discardPolicy;
        discardPolicy = new ThreadPoolExecutor.DiscardPolicy();
        return new ThreadPoolExecutor(1, 1, 0L, (TimeUnit)((Object)object), linkedBlockingQueue2, discardPolicy2);
    }

    private final void appendBarcodeItem(BarcodeItem barcodeItem, Map<BarcodeItem, Integer> countedBarcodes) {
        Object var5_5;
        Integer n;
        BarcodeScanAndCountView barcodeScanAndCountView;
        block3: {
            String string = barcodeScanAndCountView.getBarcodeItemUUID((BarcodeItem)n);
            for (Object t : countedBarcodes.keySet()) {
                var5_5 = t;
                if (!Intrinsics.areEqual((Object)barcodeScanAndCountView.getBarcodeItemUUID((BarcodeItem)t), (Object)string)) continue;
                break block3;
            }
            var5_5 = null;
        }
        barcodeScanAndCountView = var5_5;
        if (barcodeScanAndCountView != null) {
            n = (Integer)var2_2.get(barcodeScanAndCountView);
            var2_2.put(barcodeScanAndCountView, (n != null ? n : 0) + 1);
        } else {
            var2_2.put(n, 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getBarcodeItemUUID(BarcodeItem it) {
        void var1_1;
        return it.getFormat().name() + BarcodeItemKt.getTextWithExtension((BarcodeItem)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void processPictureTaken(ImageRef image, int imageOrientation) {
        BarcodeScannerResult barcodeScannerResult;
        List list;
        void var2_4;
        ImageInfo imageInfo;
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        barcodeScanAndCountView.post(() -> BarcodeScanAndCountView.processPictureTaken$lambda$9(barcodeScanAndCountView));
        BarcodeScanner barcodeScanner = barcodeScanAndCountView.barcodeScanner;
        if (barcodeScanner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"barcodeScanner");
            barcodeScanner = null;
        }
        barcodeScanner = (BarcodeScannerResult)ResultKt.getOrNull((Result)barcodeScanner.run((ImageRef)imageInfo));
        ImageRef imageRef = ImageRef.CREATOR.fromEncodedBuffer$default((ImageRef.CREATOR)ImageRef.CREATOR, (byte[])new byte[0], null, (int)2, null);
        ImageInfo imageInfo2 = (ImageInfo)ResultKt.getOrNull((Result)imageInfo.info());
        int n = imageInfo2 != null ? imageInfo2.getWidth() : 0;
        imageInfo = (ImageInfo)ResultKt.getOrNull((Result)imageInfo.info());
        int n2 = imageInfo != null ? imageInfo.getHeight() : 0;
        ImageRef imageRef2 = imageRef;
        imageRef = CameraModule.BACK;
        FrameHandler.Frame frame = new FrameHandler.Frame(imageRef2, n, n2, (int)var2_4, null, null, 0, 0, (CameraModule)imageRef, false);
        this.binding.barcodesPolygonView.getFrameHandler().handleFrame(frame);
        if (barcodeScanner == null || (list = barcodeScanner.getBarcodes()) == null) {
            list = CollectionsKt.emptyList();
        }
        BarcodeCounterFrameHandler.ResultHandler resultHandler = this.binding.barcodesPolygonView.getBarcodesResultHandler();
        boolean bl = barcodeScanner != null ? barcodeScanner.getSuccess() : false;
        ImageRef imageRef3 = imageRef;
        BarcodeScannerResult barcodeScannerResult2 = barcodeScannerResult;
        barcodeScannerResult2(list, bl);
        imageRef3((Object)barcodeScannerResult2, frame);
        resultHandler.handle((FrameHandlerResult)imageRef3);
        this.post(() -> BarcodeScanAndCountView.processPictureTaken$lambda$12(list, this));
    }

    /*
     * WARNING - void declaration
     */
    private final int dpToPx(int dp) {
        void var1_2;
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
        float f2 = (float)var1_2;
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        return MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)displayMetrics));
    }

    private static final void resultHandler$lambda$3$lambda$2(BarcodeScanAndCountView this$0, FrameHandlerResult $it) {
        Object object;
        IBarcodeScanCountViewCallback iBarcodeScanCountViewCallback;
        Intrinsics.checkNotNullParameter((Object)iBarcodeScanCountViewCallback, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)object, (String)"$it");
        iBarcodeScanCountViewCallback = this$0.barcodeScannerViewInterface;
        if (iBarcodeScanCountViewCallback != null) {
            if ((object = (BarcodeScannerResult)((FrameHandlerResult.Success)object).getValue()) == null || (object = object.getBarcodes()) == null) {
                object = CollectionsKt.emptyList();
            }
            iBarcodeScanCountViewCallback.onScanAndCountFinished((List<BarcodeItem>)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean resultHandler$lambda$3(BarcodeScanAndCountView this$0, FrameHandlerResult it) {
        void var1_1;
        IBarcodeScanCountViewCallback iBarcodeScanCountViewCallback;
        FrameHandlerResult frameHandlerResult = it;
        Intrinsics.checkNotNullParameter((Object)iBarcodeScanCountViewCallback, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameHandlerResult, (String)"it");
        if (frameHandlerResult instanceof FrameHandlerResult.Failure) {
            iBarcodeScanCountViewCallback = ((BarcodeScanAndCountView)((Object)iBarcodeScanCountViewCallback)).barcodeScannerViewInterface;
            if (iBarcodeScanCountViewCallback != null) {
                iBarcodeScanCountViewCallback.onLicenseError();
            }
        } else if (var1_1 instanceof FrameHandlerResult.Success) {
            Object object = (BarcodeScannerResult)((FrameHandlerResult.Success)var1_1).getValue();
            if (object != null && (object = object.getBarcodes()) != null) {
                BarcodeScannerResult barcodeScannerResult = object;
                object = MapsKt.toMutableMap(((BarcodeScanAndCountView)((Object)iBarcodeScanCountViewCallback)).countedBarcodes);
                Iterator iterator = barcodeScannerResult.iterator();
                while (iterator.hasNext()) {
                    super.appendBarcodeItem((BarcodeItem)iterator.next(), (Map<BarcodeItem, Integer>)object);
                }
                ((BarcodeScanAndCountView)((Object)iBarcodeScanCountViewCallback)).countedBarcodes = MapsKt.toMap((Map)object);
            }
            Object object2 = iBarcodeScanCountViewCallback;
            object2.post(() -> BarcodeScanAndCountView.resultHandler$lambda$3$lambda$2((BarcodeScanAndCountView)object2, (FrameHandlerResult)var1_1));
            ((BarcodeScanAndCountView)object2).scanState = ScanState.RESULT;
        }
        return false;
    }

    private static final void initCamera$lambda$4(BarcodeScanAndCountView this$0) {
        BarcodeScanAndCountView barcodeScanAndCountView;
        BarcodeScanAndCountView barcodeScanAndCountView2 = this$0;
        Intrinsics.checkNotNullParameter((Object)barcodeScanAndCountView2, (String)"this$0");
        IBarcodeScanCountViewCallback iBarcodeScanCountViewCallback = barcodeScanAndCountView2.barcodeScannerViewInterface;
        if (iBarcodeScanCountViewCallback != null) {
            iBarcodeScanCountViewCallback.onCameraOpen();
        }
        BarcodeScanAndCountView barcodeScanAndCountView3 = barcodeScanAndCountView;
        barcodeScanAndCountView3.binding.scanbotCameraView.setCaptureCallback(new CaptureCallback(barcodeScanAndCountView){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public void onImageCaptured() {
                BarcodeScanAndCountView.access$getBinding$p((BarcodeScanAndCountView)this.this$0).scanbotCameraView.stopPreview();
            }
        });
        barcodeScanAndCountView3.binding.scanbotCameraView.setShutterSound(false);
        barcodeScanAndCountView3.binding.scanbotCameraView.continuousFocus();
    }

    private static final void processPictureTaken$lambda$9(BarcodeScanAndCountView this$0) {
        BarcodeScanAndCountView barcodeScanAndCountView = this$0;
        Intrinsics.checkNotNullParameter((Object)barcodeScanAndCountView, (String)"this$0");
        barcodeScanAndCountView.binding.scanbotCameraView.freezePreview();
    }

    /*
     * WARNING - void declaration
     */
    private static final void processPictureTaken$lambda$12(List $items, BarcodeScanAndCountView this$0) {
        List list;
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)list, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"this$0");
        Object object = MapsKt.toMutableMap(v0.countedBarcodes);
        Iterator iterator = $items.iterator();
        while (iterator.hasNext()) {
            super.appendBarcodeItem((BarcodeItem)iterator.next(), (Map<BarcodeItem, Integer>)object);
        }
        var1_1.countedBarcodes = MapsKt.toMap((Map)object);
        object = var1_1.barcodeScannerViewInterface;
        if (object != null) {
            object.onScanAndCountFinished(list);
        }
        var1_1.scanState = ScanState.RESULT;
    }

    public static final /* synthetic */ BarcodeScanner access$getBarcodeScanner$p(BarcodeScanAndCountView $this) {
        return $this.barcodeScanner;
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getSnapExecutor$p(BarcodeScanAndCountView $this) {
        return $this.snapExecutor;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$processPictureTaken(BarcodeScanAndCountView $this, ImageRef image, int imageOrientation) {
        void var2_2;
        void var1_1;
        $this.processPictureTaken((ImageRef)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$dpToPx(BarcodeScanAndCountView $this, int dp) {
        void var1_1;
        return $this.dpToPx((int)var1_1);
    }

    public static final /* synthetic */ ScanbotSdkBarcodeScanCountViewBinding access$getBinding$p(BarcodeScanAndCountView $this) {
        return $this.binding;
    }

    public static final /* synthetic */ ScanState access$getScanState$p(BarcodeScanAndCountView $this) {
        return $this.scanState;
    }

    public static final /* synthetic */ IBarcodeScanCountViewCallback access$getBarcodeScannerViewInterface$p(BarcodeScanAndCountView $this) {
        return $this.barcodeScannerViewInterface;
    }

    public static final /* synthetic */ CaptureMode access$getCaptureMode$p(BarcodeScanAndCountView $this) {
        return $this.captureMode;
    }

    public static final /* synthetic */ BarcodeCounterFrameHandler access$getFrameHandler$p(BarcodeScanAndCountView $this) {
        return $this.frameHandler;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setScanState$p(BarcodeScanAndCountView $this, ScanState scanState) {
        void var1_1;
        $this.scanState = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setCountedBarcodes$p(BarcodeScanAndCountView $this, Map map) {
        void var1_1;
        $this.countedBarcodes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setCaptureMode$p(BarcodeScanAndCountView $this, CaptureMode captureMode) {
        void var1_1;
        $this.captureMode = var1_1;
    }

    @NotNull
    public final Map<BarcodeItem, Integer> getCountedBarcodes() {
        return this.countedBarcodes;
    }

    @Override
    @NotNull
    public IBarcodeScanCountViewController getViewController() {
        return this.viewController;
    }

    @Override
    @NotNull
    public IBarcodeScanCountViewCameraConfiguration getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    @Override
    @NotNull
    public IBarcodeScanCountSelectionOverlayController getCounterOverlayController() {
        return this.counterOverlayController;
    }

    @Override
    public void initCamera() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        barcodeScanAndCountView.binding.scanbotCameraView.setPreviewMode(CameraPreviewMode.FILL_IN);
        barcodeScanAndCountView.binding.scanbotCameraView.setCameraOpenCallback(() -> BarcodeScanAndCountView.initCamera$lambda$4(this));
        barcodeScanAndCountView.binding.scanbotCameraView.addPictureCallback((BasePictureCallback)new PictureCallback(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private static final void onPictureTaken$lambda$0(BarcodeScanAndCountView this$0, ImageRef $image, CaptureInfo $captureInfo) {
                void var1_1;
                BarcodeScanAndCountView barcodeScanAndCountView;
                void var2_2;
                void v0 = var2_2;
                Intrinsics.checkNotNullParameter((Object)barcodeScanAndCountView, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$image");
                Intrinsics.checkNotNullParameter((Object)v0, (String)"$captureInfo");
                BarcodeScanAndCountView.access$processPictureTaken(this$0, (ImageRef)var1_1, v0.getImageOrientation());
            }

            /*
             * WARNING - void declaration
             */
            public void onPictureTaken(@NotNull ImageRef image, @NotNull CaptureInfo captureInfo) {
                void var2_2;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"image");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"captureInfo");
                if (BarcodeScanAndCountView.access$getBarcodeScanner$p(this.this$0) != null) {
                    BarcodeScanAndCountView.access$getSnapExecutor$p(this.this$0).execute(() -> initCamera.2.onPictureTaken$lambda$0(this.this$0, (ImageRef)var1_1, (CaptureInfo)var2_2));
                }
            }
        });
        barcodeScanAndCountView.binding.barcodesPolygonView.setBarcodeItemViewFactory(new BarcodePolygonsStaticView.BarcodeItemViewFactory(this){
            final /* synthetic */ BarcodeScanAndCountView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @NotNull
            public View createView() {
                ImageView imageView = new ImageView(barcodeScanAndCountView.this$0.getContext());
                BarcodeScanAndCountView barcodeScanAndCountView = barcodeScanAndCountView.this$0;
                imageView.setImageResource(R.drawable.ic_scanbot_checkmark);
                BarcodeScanAndCountView barcodeScanAndCountView2 = barcodeScanAndCountView;
                int n = BarcodeScanAndCountView.access$dpToPx(barcodeScanAndCountView2, 36);
                imageView.setLayoutParams(new ViewGroup.LayoutParams(n, BarcodeScanAndCountView.access$dpToPx(barcodeScanAndCountView2, 36)));
                return imageView;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initScanningBehavior(@NotNull IBarcodeScanner barcodeScanner, @Nullable IBarcodeScanCountViewCallback callback) {
        void var2_2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"barcodeScanner");
        BarcodeScannerConfiguration barcodeScannerConfiguration = object.copyCurrentConfiguration();
        barcodeScannerConfiguration.setOptimizedForOverlays(true);
        Unit unit = Unit.INSTANCE;
        this.barcodeScanner = (BarcodeScanner)ResultKt.getOrThrow((Result)BarcodeScanner.Companion.createBarcodeScanner(barcodeScannerConfiguration));
        ScanbotCameraXView scanbotCameraXView = this.binding.scanbotCameraView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraXView, (String)"scanbotCameraView");
        object = BarcodeCounterFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraXView, (IBarcodeScanner)object);
        this.frameHandler = object;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
            object = null;
        }
        object.setEnabled(false);
        object = this.frameHandler;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
            object = null;
        }
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        object.setViewHandler(this.binding.barcodesPolygonView.getBarcodesResultHandler());
        object = barcodeScanAndCountView.binding;
        ((ScanbotSdkBarcodeScanCountViewBinding)object).scanbotCameraView.addFrameHandler(((ScanbotSdkBarcodeScanCountViewBinding)object).barcodesPolygonView.getFrameHandler());
        barcodeScanAndCountView.binding.barcodesPolygonView.setBarcodeAcceptanceDelegate(new BarcodePolygonsStaticView.BarcodeAcceptanceDelegate(){

            public boolean shouldAccept(@NotNull BarcodeItem barcodeItem) {
                Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                return true;
            }
        });
        this.barcodeScannerViewInterface = var2_2;
        if (var2_2 != null) {
            object = this.frameHandler;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                object = null;
            }
            object.addResultHandler(this.resultHandler);
        } else {
            unit = null;
        }
        if (unit == null) {
            object = this.frameHandler;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                object = null;
            }
            object.removeResultHandler(this.resultHandler);
        }
    }

    public void onAttachedToWindow() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        super.onAttachedToWindow();
        if (barcodeScanAndCountView.snapExecutor.isShutdown()) {
            this.snapExecutor = this.createSingleThreadPoolExecutor();
        }
    }

    public void onDetachedFromWindow() {
        BarcodeScanAndCountView barcodeScanAndCountView = this;
        super.onDetachedFromWindow();
        barcodeScanAndCountView.snapExecutor.shutdown();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/barcode/ui/BarcodeScanAndCountView$ScanState;", "", "(Ljava/lang/String;I)V", "IDLE", "SCANNING", "RESULT", "sdk-barcode_release"})
    public static final class ScanState
    extends Enum<ScanState> {
        public static final /* enum */ ScanState IDLE;
        public static final /* enum */ ScanState SCANNING;
        public static final /* enum */ ScanState RESULT;
        public static final /* synthetic */ ScanState[] a;
        public static final /* synthetic */ EnumEntries b;

        /*
         * WARNING - void declaration
         */
        public ScanState() {
            void var2_2;
            void var1_1;
        }

        public static ScanState[] values() {
            return (ScanState[])a.clone();
        }

        public static ScanState valueOf(String value) {
            String string;
            return Enum.valueOf(ScanState.class, string);
        }

        @NotNull
        public static EnumEntries<ScanState> getEntries() {
            return b;
        }

        public static final /* synthetic */ ScanState[] a() {
            return new ScanState[]{IDLE, SCANNING, RESULT};
        }

        static {
            ScanState scanState;
            ScanState scanState2;
            ScanState scanState3;
            ScanState scanState4 = scanState3;
            IDLE = new ScanState();
            ScanState scanState5 = scanState2;
            SCANNING = new ScanState();
            ScanState scanState6 = scanState;
            RESULT = new ScanState();
            a = new ScanState[]{scanState4, scanState5, scanState6};
            b = EnumEntriesKt.enumEntries((Enum[])a);
        }
    }
}

