/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import com.android.mms.exif.ExifData;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.IfdData;
import com.android.mms.exif.JpegHeader;
import com.android.mms.exif.OrderedDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class ExifOutputStream
extends FilterOutputStream {
    private static final String TAG = "ExifOutputStream";
    private static final boolean DEBUG = false;
    private static final int STREAMBUFFER_SIZE = 65536;
    private static final int STATE_SOI = 0;
    private static final int STATE_FRAME_HEADER = 1;
    private static final int STATE_JPEG_DATA = 2;
    private static final int EXIF_HEADER = 1165519206;
    private static final short TIFF_HEADER = 42;
    private static final short TIFF_BIG_ENDIAN = 19789;
    private static final short TIFF_LITTLE_ENDIAN = 18761;
    private static final short TAG_SIZE = 12;
    private static final short TIFF_HEADER_SIZE = 8;
    private static final int MAX_EXIF_SIZE = 65535;
    private ExifData mExifData;
    private int mState = 0;
    private int mByteToSkip;
    private int mByteToCopy;
    private final byte[] mSingleByteArray = new byte[1];
    private final ByteBuffer mBuffer = ByteBuffer.allocate(4);
    private final ExifInterface mInterface;

    /*
     * WARNING - void declaration
     */
    public ExifOutputStream(OutputStream ou, ExifInterface iRef) {
        super(new BufferedOutputStream((OutputStream)var1_1, 65536));
        void var2_2;
        void var1_1;
        this.mInterface = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int requestByteToBuffer(int requestByteCount, byte[] buffer, int offset, int length) {
        void var3_3;
        void var2_2;
        void var4_4;
        if (length > (var1_1 -= this.mBuffer.position())) {
            void var1_1;
            var4_4 = var1_1;
        }
        this.mBuffer.put((byte[])var2_2, (int)var3_3, (int)var4_4);
        return (int)var4_4;
    }

    private void writeExifData() throws IOException {
        Object object = this.mExifData;
        if (object == null) {
            return;
        }
        ExifOutputStream exifOutputStream = this;
        object = exifOutputStream.stripNullValueTags((ExifData)object);
        exifOutputStream.createRequiredIfdAndTag();
        int n2 = exifOutputStream.calculateAllOffset() + 8;
        if (n2 <= 65535) {
            OrderedDataOutputStream orderedDataOutputStream;
            OrderedDataOutputStream orderedDataOutputStream2;
            OrderedDataOutputStream orderedDataOutputStream3 = orderedDataOutputStream2 = orderedDataOutputStream;
            orderedDataOutputStream3(this.out);
            Object object2 = ByteOrder.BIG_ENDIAN;
            orderedDataOutputStream3.setByteOrder((ByteOrder)object2);
            orderedDataOutputStream3.writeShort((short)-31);
            orderedDataOutputStream.writeShort((short)n2);
            orderedDataOutputStream.writeInt(1165519206);
            orderedDataOutputStream.writeShort((short)0);
            if (this.mExifData.getByteOrder() == object2) {
                orderedDataOutputStream2.writeShort((short)19789);
            } else {
                orderedDataOutputStream2.writeShort((short)18761);
            }
            OrderedDataOutputStream orderedDataOutputStream4 = orderedDataOutputStream2;
            orderedDataOutputStream4.setByteOrder(this.mExifData.getByteOrder());
            orderedDataOutputStream4.writeShort((short)42);
            orderedDataOutputStream4.writeInt(8);
            this.writeAllTags(orderedDataOutputStream4);
            this.writeThumbnail(orderedDataOutputStream2);
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                object2 = (ExifTag)object.next();
                this.mExifData.addTag((ExifTag)object2);
            }
            return;
        }
        throw new IOException("Exif header is too large (>64Kb)");
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<ExifTag> stripNullValueTags(ExifData data) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (ExifTag exifTag : data.getAllTags()) {
            void var1_1;
            if (exifTag.getValue() != null || ExifInterface.isOffsetTag(exifTag.getTagId())) continue;
            ExifTag exifTag2 = exifTag;
            short s2 = exifTag2.getTagId();
            var1_1.removeTag(s2, exifTag2.getIfd());
            arrayList2.add(exifTag);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private void writeThumbnail(OrderedDataOutputStream dataOutputStream) throws IOException {
        void var1_1;
        if (this.mExifData.hasCompressedThumbnail()) {
            var1_1.write(this.mExifData.getCompressedThumbnail());
        } else if (this.mExifData.hasUncompressedStrip()) {
            for (int i2 = 0; i2 < this.mExifData.getStripCount(); ++i2) {
                var1_1.write(this.mExifData.getStrip(i2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeAllTags(OrderedDataOutputStream dataOutputStream) throws IOException {
        void var1_1;
        ExifOutputStream exifOutputStream = this;
        exifOutputStream.writeIfd(exifOutputStream.mExifData.getIfdData(0), (OrderedDataOutputStream)var1_1);
        exifOutputStream.writeIfd(exifOutputStream.mExifData.getIfdData(2), (OrderedDataOutputStream)var1_1);
        IfdData ifdData = exifOutputStream.mExifData.getIfdData(3);
        if (ifdData != null) {
            this.writeIfd(ifdData, (OrderedDataOutputStream)var1_1);
        }
        if ((ifdData = this.mExifData.getIfdData(4)) != null) {
            this.writeIfd(ifdData, (OrderedDataOutputStream)var1_1);
        }
        if (this.mExifData.getIfdData(1) != null) {
            ExifOutputStream exifOutputStream2 = this;
            exifOutputStream2.writeIfd(exifOutputStream2.mExifData.getIfdData(1), (OrderedDataOutputStream)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeIfd(IfdData ifd, OrderedDataOutputStream dataOutputStream) throws IOException {
        void var1_1;
        void var2_3;
        ExifTag[] exifTagArray = ifd.getAllTags();
        var2_3.writeShort((short)exifTagArray.length);
        int n2 = exifTagArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void v0 = var2_3;
            ExifTag exifTag = exifTagArray[i2];
            v0.writeShort(exifTag.getTagId());
            v0.writeShort(exifTag.getDataType());
            v0.writeInt(exifTag.getComponentCount());
            if (exifTag.getDataSize() > 4) {
                var2_3.writeInt(exifTag.getOffset());
                continue;
            }
            ExifTag exifTag2 = exifTag;
            ExifOutputStream.writeTagValue(exifTag2, (OrderedDataOutputStream)var2_3);
            int n3 = 4 - exifTag2.getDataSize();
            for (int i3 = 0; i3 < n3; ++i3) {
                var2_3.write(0);
            }
        }
        var2_3.writeInt(var1_1.getOffsetToNextIfd());
        for (ExifTag exifTag : exifTagArray) {
            if (exifTag.getDataSize() <= 4) continue;
            ExifOutputStream.writeTagValue(exifTag, (OrderedDataOutputStream)var2_3);
        }
    }

    private int calculateOffsetOfIfd(IfdData ifd, int offset) {
        int n2;
        IfdData ifdData = ifd;
        int n3 = ifdData.getTagCount() * 12 + 2 + 4 + n2;
        for (ExifTag exifTag : ifdData.getAllTags()) {
            if (exifTag.getDataSize() <= 4) continue;
            ExifTag exifTag2 = exifTag;
            exifTag2.setOffset(n3);
            n3 = exifTag2.getDataSize() + n3;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createRequiredIfdAndTag() throws IOException {
        ExifTag exifTag;
        int n2;
        ExifTag exifTag2;
        IfdData ifdData = this.mExifData.getIfdData(0);
        if (ifdData == null) {
            IfdData ifdData2;
            ifdData = ifdData2;
            ifdData2 = new IfdData(0);
            this.mExifData.addIfdData(ifdData);
        }
        if ((exifTag2 = this.mInterface.buildUninitializedTag(n2 = ExifInterface.TAG_EXIF_IFD)) == null) throw new IOException("No definition for crucial exif tag: " + n2);
        ifdData.setTag(exifTag2);
        IfdData ifdData3 = this.mExifData.getIfdData(2);
        if (ifdData3 == null) {
            IfdData ifdData4;
            ifdData3 = ifdData4;
            ifdData4 = new IfdData(2);
            this.mExifData.addIfdData(ifdData3);
        }
        if (this.mExifData.getIfdData(4) != null) {
            int n3 = ExifInterface.TAG_GPS_IFD;
            exifTag = this.mInterface.buildUninitializedTag(n3);
            if (exifTag == null) throw new IOException("No definition for crucial exif tag: " + n3);
            ifdData.setTag(exifTag);
        }
        if (this.mExifData.getIfdData(3) != null) {
            int n4 = ExifInterface.TAG_INTEROPERABILITY_IFD;
            exifTag2 = this.mInterface.buildUninitializedTag(n4);
            if (exifTag2 == null) throw new IOException("No definition for crucial exif tag: " + n4);
            ifdData3.setTag(exifTag2);
        }
        ExifOutputStream exifOutputStream = this;
        IfdData ifdData5 = exifOutputStream.mExifData.getIfdData(1);
        if (exifOutputStream.mExifData.hasCompressedThumbnail()) {
            int n5;
            if (ifdData5 == null) {
                IfdData ifdData6;
                ifdData5 = ifdData6;
                ifdData6 = new IfdData(1);
                this.mExifData.addIfdData(ifdData5);
            }
            if ((exifTag2 = this.mInterface.buildUninitializedTag(n5 = ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)) == null) throw new IOException("No definition for crucial exif tag: " + n5);
            ifdData5.setTag(exifTag2);
            n5 = ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH;
            exifTag2 = this.mInterface.buildUninitializedTag(n5);
            if (exifTag2 == null) throw new IOException("No definition for crucial exif tag: " + n5);
            IfdData ifdData7 = ifdData5;
            ExifTag exifTag3 = exifTag2;
            exifTag3.setValue(this.mExifData.getCompressedThumbnail().length);
            ifdData7.setTag(exifTag3);
            ifdData7.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS));
            ifdData7.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS));
            return;
        } else if (this.mExifData.hasUncompressedStrip()) {
            if (ifdData5 == null) {
                IfdData ifdData8;
                ifdData5 = ifdData8;
                ifdData8 = new IfdData(1);
                this.mExifData.addIfdData(ifdData5);
            }
            ExifOutputStream exifOutputStream2 = this;
            int n6 = exifOutputStream2.mExifData.getStripCount();
            int n7 = ExifInterface.TAG_STRIP_OFFSETS;
            exifTag = exifOutputStream2.mInterface.buildUninitializedTag(n7);
            if (exifTag == null) throw new IOException("No definition for crucial exif tag: " + n7);
            n7 = ExifInterface.TAG_STRIP_BYTE_COUNTS;
            ExifTag exifTag4 = this.mInterface.buildUninitializedTag(n7);
            if (exifTag4 == null) throw new IOException("No definition for crucial exif tag: " + n7);
            long[] lArray = new long[n6];
            for (n7 = 0; n7 < this.mExifData.getStripCount(); ++n7) {
                lArray[n7] = this.mExifData.getStrip(n7).length;
            }
            IfdData ifdData9 = ifdData5;
            exifTag4.setValue(lArray);
            ifdData5.setTag(exifTag);
            ifdData9.setTag(exifTag4);
            ifdData9.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT));
            ifdData9.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH));
            return;
        } else {
            if (ifdData5 == null) return;
            IfdData ifdData10 = ifdData5;
            ifdData10.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS));
            ifdData10.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_BYTE_COUNTS));
            ifdData10.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT));
            ifdData10.removeTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT_LENGTH));
        }
    }

    private int calculateAllOffset() {
        ExifOutputStream exifOutputStream = this;
        Object object = exifOutputStream.mExifData.getIfdData(0);
        int n2 = this.calculateOffsetOfIfd((IfdData)object, 8);
        ((IfdData)object).getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_EXIF_IFD)).setValue(n2);
        IfdData ifdData = exifOutputStream.mExifData.getIfdData(2);
        n2 = exifOutputStream.calculateOffsetOfIfd(ifdData, n2);
        IfdData ifdData2 = exifOutputStream.mExifData.getIfdData(3);
        if (ifdData2 != null) {
            ifdData.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_INTEROPERABILITY_IFD)).setValue(n2);
            n2 = this.calculateOffsetOfIfd(ifdData2, n2);
        }
        if ((ifdData = this.mExifData.getIfdData(4)) != null) {
            ((IfdData)object).getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_GPS_IFD)).setValue(n2);
            n2 = this.calculateOffsetOfIfd(ifdData, n2);
        }
        if ((ifdData = this.mExifData.getIfdData(1)) != null) {
            ((IfdData)object).setOffsetToNextIfd(n2);
            n2 = this.calculateOffsetOfIfd(ifdData, n2);
        }
        if (this.mExifData.hasCompressedThumbnail()) {
            ifdData.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_JPEG_INTERCHANGE_FORMAT)).setValue(n2);
            n2 += this.mExifData.getCompressedThumbnail().length;
        } else if (this.mExifData.hasUncompressedStrip()) {
            object = new long[this.mExifData.getStripCount()];
            for (int i2 = 0; i2 < this.mExifData.getStripCount(); ++i2) {
                object[i2] = (long)n2;
                n2 += this.mExifData.getStrip(i2).length;
            }
            ifdData.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_STRIP_OFFSETS)).setValue((long[])object);
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeTagValue(ExifTag tag, OrderedDataOutputStream dataOutputStream) throws IOException {
        switch (tag.getDataType()) {
            default: {
                break;
            }
            case 5: 
            case 10: {
                void var1_1;
                Object object;
                int n2 = ((ExifTag)object).getComponentCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    var1_1.writeRational(((ExifTag)object).getRational(i2));
                }
                break;
            }
            case 4: 
            case 9: {
                void var1_1;
                Object object;
                int n3 = ((ExifTag)object).getComponentCount();
                for (int i3 = 0; i3 < n3; ++i3) {
                    var1_1.writeInt((int)((ExifTag)object).getValueAt(i3));
                }
                break;
            }
            case 3: {
                void var1_1;
                Object object;
                int n4 = ((ExifTag)object).getComponentCount();
                for (int i4 = 0; i4 < n4; ++i4) {
                    var1_1.writeShort((short)((ExifTag)object).getValueAt(i4));
                }
                break;
            }
            case 2: {
                void var1_1;
                Object object;
                byte[] byArray = ((ExifTag)object).getStringByte();
                if (byArray.length == ((ExifTag)object).getComponentCount()) {
                    byte[] byArray2 = byArray;
                    byArray2[byArray2.length - 1] = 0;
                    var1_1.write(byArray);
                    break;
                }
                void v1 = var1_1;
                v1.write(byArray);
                v1.write(0);
                break;
            }
            case 1: 
            case 7: {
                void var1_1;
                Object object;
                ExifTag exifTag = object;
                byte[] byArray = new byte[exifTag.getComponentCount()];
                object = byArray;
                exifTag.getBytes(byArray);
                var1_1.write((byte[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setExifData(ExifData exifData) {
        void var1_1;
        this.mExifData = var1_1;
    }

    public ExifData getExifData() {
        return this.mExifData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        void var1_1;
        int n3;
        int n4;
        while (((n4 = this.mByteToSkip) > 0 || this.mByteToCopy > 0 || this.mState != 2) && n3 > 0) {
            if (n4 > 0) {
                int n5 = n3 > n4 ? n4 : n3;
                n3 -= n5;
                this.mByteToSkip = n4 - n5;
                n2 += n5;
            }
            if ((n4 = this.mByteToCopy) > 0) {
                if (n3 <= n4) {
                    n4 = n3;
                }
                this.out.write((byte[])var1_1, n2, n4);
                n3 -= n4;
                this.mByteToCopy -= n4;
                n2 += n4;
            }
            if (n3 == 0) {
                return;
            }
            n4 = this.mState;
            if (n4 != 0) {
                if (n4 != 1) continue;
                void v0 = n3;
                void v1 = n2;
                n2 = this.requestByteToBuffer(4, (byte[])var1_1, n2, n3);
                n3 = v1 + n2;
                n2 = v0 - n2;
                if (this.mBuffer.position() == 2 && this.mBuffer.getShort() == -39) {
                    ExifOutputStream exifOutputStream = this;
                    exifOutputStream.out.write(this.mBuffer.array(), 0, 2);
                    exifOutputStream.mBuffer.rewind();
                }
                if (this.mBuffer.position() < 4) {
                    return;
                }
                ExifOutputStream exifOutputStream = this;
                exifOutputStream.mBuffer.rewind();
                short s2 = exifOutputStream.mBuffer.getShort();
                n4 = s2;
                if (s2 == -31) {
                    this.mByteToSkip = (this.mBuffer.getShort() & 0xFFFF) - 2;
                    this.mState = 2;
                } else if (!JpegHeader.isSofMarker((short)n4)) {
                    ExifOutputStream exifOutputStream2 = this;
                    exifOutputStream2.out.write(this.mBuffer.array(), 0, 4);
                    exifOutputStream2.mByteToCopy = (exifOutputStream2.mBuffer.getShort() & 0xFFFF) - 2;
                } else {
                    this.out.write(this.mBuffer.array(), 0, 4);
                    this.mState = 2;
                }
                this.mBuffer.rewind();
                int n6 = n3;
                n3 = n2;
                n2 = n6;
                continue;
            }
            void v7 = n3;
            void v8 = n2;
            n2 = this.requestByteToBuffer(2, (byte[])var1_1, n2, n3);
            n3 = v8 + n2;
            n2 = v7 - n2;
            if (this.mBuffer.position() < 2) {
                return;
            }
            ExifOutputStream exifOutputStream = this;
            exifOutputStream.mBuffer.rewind();
            if (exifOutputStream.mBuffer.getShort() == -40) {
                ExifOutputStream exifOutputStream3 = this;
                exifOutputStream3.out.write(this.mBuffer.array(), 0, 2);
                exifOutputStream3.mState = 1;
                exifOutputStream3.mBuffer.rewind();
                exifOutputStream3.writeExifData();
                void v11 = n3;
                n3 = n2;
                n2 = v11;
                continue;
            }
            throw new IOException("Not a valid jpeg image, cannot write exif");
        }
        if (n3 > 0) {
            this.out.write((byte[])var1_1, n2, n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int oneByte) throws IOException {
        void var1_1;
        ExifOutputStream exifOutputStream = this;
        exifOutputStream.mSingleByteArray[0] = (byte)(var1_1 & 0xFF);
        exifOutputStream.write(exifOutputStream.mSingleByteArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] buffer) throws IOException {
        void var1_2;
        int n2 = ((void)var1_2).length;
        this.write((byte[])var1_2, 0, n2);
    }
}

