/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.Toolbar;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewKt;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeItem;
import io.scanbot.sdk.barcode.BarcodeScanner;
import io.scanbot.sdk.barcode.BarcodeScannerFrameHandler;
import io.scanbot.sdk.barcode.BarcodeScannerResult;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.barcode.ui.BarcodeOverlayTextFormat;
import io.scanbot.sdk.barcode.ui.BarcodePolygonsView;
import io.scanbot.sdk.barcode.ui.IBarcodeScannerFinderViewController;
import io.scanbot.sdk.barcode.ui.IBarcodeScannerViewCallback;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.ZoomRange;
import io.scanbot.sdk.ui.IFinderViewController;
import io.scanbot.sdk.ui.barcode.databinding.ScanbotSdkBarcodeCameraViewBinding;
import io.scanbot.sdk.ui.barcode.databinding.ScanbotSdkBarcodeDescriptionViewBinding;
import io.scanbot.sdk.ui.base.R;
import io.scanbot.sdk.ui.base.databinding.ScanbotSdkCameraViewPermissionPlaceholderBinding;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.camera.FinderOverlayViewKt;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraView;
import io.scanbot.sdk.ui.view.barcode.IBarcodeCameraView;
import io.scanbot.sdk.ui.view.base.IPermissionViewModel;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0001uB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020<H\u0016J\u0010\u0010C\u001a\u00020B2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010D\u001a\u00020BH\u0002J\u0015\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020B2\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020BH\u0014J\b\u0010L\u001a\u00020BH\u0014J\u0010\u0010M\u001a\u00020B2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020B2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020B2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020B2\u0006\u0010W\u001a\u00020XH\u0016J\u000e\u0010Y\u001a\u00020B2\u0006\u0010Z\u001a\u00020[J\u0010\u0010\\\u001a\u00020B2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020B2\u0006\u0010`\u001a\u00020\u001dH\u0016J\u0010\u0010a\u001a\u00020B2\u0006\u0010b\u001a\u00020JH\u0016J\u0010\u0010c\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010e\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010f\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010g\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010h\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010i\u001a\u00020B2\u0006\u0010d\u001a\u00020\u0013H\u0016J\u0010\u0010j\u001a\u00020B2\u0006\u0010k\u001a\u00020-H\u0016J\u0010\u0010l\u001a\u00020B2\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020B2\u0006\u0010?\u001a\u00020<H\u0002J\u0010\u0010p\u001a\u00020B2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010q\u001a\u00020B2\u0006\u0010r\u001a\u00020JH\u0002J\u0010\u0010s\u001a\u00020B2\u0006\u0010t\u001a\u00020JH\u0002R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010#\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b$\u0010\u0015\"\u0004\b%\u0010\u0017R\u001e\u0010&\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0017R\u001e\u0010)\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b*\u0010\u0015\"\u0004\b+\u0010\u0017R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001e\u00102\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b3\u0010\u0015\"\u0004\b4\u0010\u0017R\u001a\u00105\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u000e\u0010;\u001a\u00020<X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lio/scanbot/sdk/ui/view/barcode/BarcodeCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/barcode/IBarcodeCameraView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraBinding", "Lio/scanbot/sdk/ui/barcode/databinding/ScanbotSdkBarcodeCameraViewBinding;", "getCameraBinding$rtu_ui_barcode_release", "()Lio/scanbot/sdk/ui/barcode/databinding/ScanbotSdkBarcodeCameraViewBinding;", "setCameraBinding$rtu_ui_barcode_release", "(Lio/scanbot/sdk/ui/barcode/databinding/ScanbotSdkBarcodeCameraViewBinding;)V", "descriptionBinding", "Lio/scanbot/sdk/ui/barcode/databinding/ScanbotSdkBarcodeDescriptionViewBinding;", "getDescriptionBinding$rtu_ui_barcode_release", "()Lio/scanbot/sdk/ui/barcode/databinding/ScanbotSdkBarcodeDescriptionViewBinding;", "overlayHighlightedPolygonColor", "", "getOverlayHighlightedPolygonColor$rtu_ui_barcode_release", "()Ljava/lang/Integer;", "setOverlayHighlightedPolygonColor$rtu_ui_barcode_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "overlayPolygonColor", "getOverlayPolygonColor$rtu_ui_barcode_release", "setOverlayPolygonColor$rtu_ui_barcode_release", "overlayStrokeWidth", "", "getOverlayStrokeWidth$rtu_ui_barcode_release", "()Ljava/lang/Float;", "setOverlayStrokeWidth$rtu_ui_barcode_release", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "overlayTextColor", "getOverlayTextColor$rtu_ui_barcode_release", "setOverlayTextColor$rtu_ui_barcode_release", "overlayTextContainerColor", "getOverlayTextContainerColor$rtu_ui_barcode_release", "setOverlayTextContainerColor$rtu_ui_barcode_release", "overlayTextContainerHighlightedColor", "getOverlayTextContainerHighlightedColor$rtu_ui_barcode_release", "setOverlayTextContainerHighlightedColor$rtu_ui_barcode_release", "overlayTextFormat", "Lio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;", "getOverlayTextFormat$rtu_ui_barcode_release", "()Lio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;", "setOverlayTextFormat$rtu_ui_barcode_release", "(Lio/scanbot/sdk/barcode/ui/BarcodeOverlayTextFormat;)V", "overlayTextHighlightedColor", "getOverlayTextHighlightedColor$rtu_ui_barcode_release", "setOverlayTextHighlightedColor$rtu_ui_barcode_release", "permissionBinding", "Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "getPermissionBinding$rtu_ui_barcode_release", "()Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "setPermissionBinding$rtu_ui_barcode_release", "(Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;)V", "permissionViewModel", "Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;", "resultHandler", "Lio/scanbot/sdk/barcode/BarcodeScannerFrameHandler$ResultHandler;", "viewModel", "Lio/scanbot/sdk/ui/view/barcode/IBarcodeCameraView$ViewModel;", "attachPermissionViewModel", "", "attachViewModel", "doOnCameraOpen", "initCameraView", "cameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "initCameraView$rtu_ui_barcode_release", "lockMinFocusDistance", "", "onAttachedToWindow", "onDetachedFromWindow", "setBarcodeHighlightedDelegate", "barcodeHighlightDelegate", "Lio/scanbot/sdk/barcode/ui/BarcodePolygonsView$BarcodeHighlightDelegate;", "setBarcodeScanner", "barcodeScanner", "Lio/scanbot/sdk/barcode/BarcodeScanner;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCameraZoomRange", "zoomRange", "Lio/scanbot/sdk/camera/ZoomRange;", "setCameraZoomRatio", "zoomRatio", "setSelectionOverlayEnabled", "enabled", "setSelectionOverlayHighlightedPolygonColor", "color", "setSelectionOverlayHighlightedTextColor", "setSelectionOverlayHighlightedTextContainerColor", "setSelectionOverlayPolygonColor", "setSelectionOverlayTextColor", "setSelectionOverlayTextContainerColor", "setSelectionOverlayTextFormat", "format", "setSuccessfulScanningInterval", "scanningIntervalInMs", "", "subscribePermissionViewModel", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "Companion", "rtu-ui-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeCameraView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeCameraView.kt\nio/scanbot/sdk/ui/view/barcode/BarcodeCameraView\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,298:1\n65#2,4:299\n37#2:303\n53#2:304\n71#2,2:305\n*S KotlinDebug\n*F\n+ 1 BarcodeCameraView.kt\nio/scanbot/sdk/ui/view/barcode/BarcodeCameraView\n*L\n64#1:299,4\n64#1:303\n64#1:304\n64#1:305,2\n*E\n"})
public final class BarcodeCameraView
extends FrameLayout
implements IBarcodeCameraView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private IBarcodeCameraView.ViewModel viewModel;
    private IPermissionViewModel permissionViewModel;
    @NotNull
    private final BarcodeScannerFrameHandler.ResultHandler resultHandler;
    @NotNull
    private ScanbotSdkBarcodeCameraViewBinding cameraBinding;
    @NotNull
    private final ScanbotSdkBarcodeDescriptionViewBinding descriptionBinding;
    @NotNull
    private ScanbotSdkCameraViewPermissionPlaceholderBinding permissionBinding;
    @Nullable
    private Float overlayStrokeWidth;
    @Nullable
    private Integer overlayPolygonColor;
    @Nullable
    private Integer overlayHighlightedPolygonColor;
    @Nullable
    private Integer overlayTextColor;
    @Nullable
    private Integer overlayTextHighlightedColor;
    @Nullable
    private Integer overlayTextContainerColor;
    @Nullable
    private Integer overlayTextContainerHighlightedColor;
    @Nullable
    private BarcodeOverlayTextFormat overlayTextFormat;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;

    public BarcodeCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.resultHandler = arg_0 -> BarcodeCameraView.resultHandler$lambda$0(this, arg_0);
        ScanbotSdkBarcodeCameraViewBinding scanbotSdkBarcodeCameraViewBinding = ScanbotSdkBarcodeCameraViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkBarcodeCameraViewBinding, (String)"inflate(...)");
        this.cameraBinding = scanbotSdkBarcodeCameraViewBinding;
        ScanbotSdkBarcodeDescriptionViewBinding scanbotSdkBarcodeDescriptionViewBinding = ScanbotSdkBarcodeDescriptionViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this.cameraBinding.barcodeScannerView, false);
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkBarcodeDescriptionViewBinding, (String)"inflate(...)");
        this.descriptionBinding = scanbotSdkBarcodeDescriptionViewBinding;
        ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding = this.cameraBinding.cameraPermissionView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"cameraPermissionView");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
        IBarcodeScannerFinderViewController iBarcodeScannerFinderViewController = this.cameraBinding.barcodeScannerView.getFinderViewController();
        ConstraintLayout constraintLayout = this.descriptionBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        iBarcodeScannerFinderViewController.addBottomPlaceholder((View)constraintLayout);
        ConstraintLayout constraintLayout2 = this.descriptionBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"getRoot(...)");
        View $this$doOnLayout$iv = (View)constraintLayout2;
        boolean $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = $this$doOnLayout$iv;
            boolean bl = false;
            if ((float)it.getHeight() < this.getResources().getDimension(R.dimen.extended_bottom_finder_inset)) {
                IFinderViewController.DefaultImpls.setFinderInset$default((IFinderViewController)((IFinderViewController)this.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getFinderViewController()), null, null, null, (Integer)MathKt.roundToInt((float)this.getResources().getDimension(R.dimen.extended_bottom_finder_inset)), (int)7, null);
            }
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = barcodeCameraView;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    if ((float)it2.getHeight() < this.this$0.getResources().getDimension(R.dimen.extended_bottom_finder_inset)) {
                        IFinderViewController.DefaultImpls.setFinderInset$default((IFinderViewController)((IFinderViewController)this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getFinderViewController()), null, null, null, (Integer)MathKt.roundToInt((float)this.this$0.getResources().getDimension(R.dimen.extended_bottom_finder_inset)), (int)7, null);
                    }
                }
            });
        }
        this.cameraBinding.cancelView.setOnClickListener(arg_0 -> BarcodeCameraView._init_$lambda$2(this, arg_0));
        this.cameraBinding.flashBtn.setOnClickListener(arg_0 -> BarcodeCameraView._init_$lambda$3(this, arg_0));
        this.cameraBinding.flashBtn.setVisibility(context.getPackageManager().hasSystemFeature("android.hardware.camera.flash") ? 0 : 4);
        IFinderViewController iFinderViewController = (IFinderViewController)this.cameraBinding.barcodeScannerView.getFinderViewController();
        Toolbar toolbar = this.cameraBinding.cameraTopToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)toolbar, (String)"cameraTopToolbar");
        FinderOverlayViewKt.setViewAsTopSafeArea((IFinderViewController)iFinderViewController, (View)((View)toolbar));
        this.permissionBinding.enableCameraBtn.setOnClickListener(arg_0 -> BarcodeCameraView._init_$lambda$4(this, arg_0));
    }

    @NotNull
    public final ScanbotSdkBarcodeCameraViewBinding getCameraBinding$rtu_ui_barcode_release() {
        return this.cameraBinding;
    }

    public final void setCameraBinding$rtu_ui_barcode_release(@NotNull ScanbotSdkBarcodeCameraViewBinding scanbotSdkBarcodeCameraViewBinding) {
        Intrinsics.checkNotNullParameter((Object)scanbotSdkBarcodeCameraViewBinding, (String)"<set-?>");
        this.cameraBinding = scanbotSdkBarcodeCameraViewBinding;
    }

    @NotNull
    public final ScanbotSdkBarcodeDescriptionViewBinding getDescriptionBinding$rtu_ui_barcode_release() {
        return this.descriptionBinding;
    }

    @NotNull
    public final ScanbotSdkCameraViewPermissionPlaceholderBinding getPermissionBinding$rtu_ui_barcode_release() {
        return this.permissionBinding;
    }

    public final void setPermissionBinding$rtu_ui_barcode_release(@NotNull ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding) {
        Intrinsics.checkNotNullParameter((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"<set-?>");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
    }

    @Nullable
    public final Float getOverlayStrokeWidth$rtu_ui_barcode_release() {
        return this.overlayStrokeWidth;
    }

    public final void setOverlayStrokeWidth$rtu_ui_barcode_release(@Nullable Float f) {
        this.overlayStrokeWidth = f;
    }

    @Nullable
    public final Integer getOverlayPolygonColor$rtu_ui_barcode_release() {
        return this.overlayPolygonColor;
    }

    public final void setOverlayPolygonColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayPolygonColor = n;
    }

    @Nullable
    public final Integer getOverlayHighlightedPolygonColor$rtu_ui_barcode_release() {
        return this.overlayHighlightedPolygonColor;
    }

    public final void setOverlayHighlightedPolygonColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayHighlightedPolygonColor = n;
    }

    @Nullable
    public final Integer getOverlayTextColor$rtu_ui_barcode_release() {
        return this.overlayTextColor;
    }

    public final void setOverlayTextColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayTextColor = n;
    }

    @Nullable
    public final Integer getOverlayTextHighlightedColor$rtu_ui_barcode_release() {
        return this.overlayTextHighlightedColor;
    }

    public final void setOverlayTextHighlightedColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayTextHighlightedColor = n;
    }

    @Nullable
    public final Integer getOverlayTextContainerColor$rtu_ui_barcode_release() {
        return this.overlayTextContainerColor;
    }

    public final void setOverlayTextContainerColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayTextContainerColor = n;
    }

    @Nullable
    public final Integer getOverlayTextContainerHighlightedColor$rtu_ui_barcode_release() {
        return this.overlayTextContainerHighlightedColor;
    }

    public final void setOverlayTextContainerHighlightedColor$rtu_ui_barcode_release(@Nullable Integer n) {
        this.overlayTextContainerHighlightedColor = n;
    }

    @Nullable
    public final BarcodeOverlayTextFormat getOverlayTextFormat$rtu_ui_barcode_release() {
        return this.overlayTextFormat;
    }

    public final void setOverlayTextFormat$rtu_ui_barcode_release(@Nullable BarcodeOverlayTextFormat barcodeOverlayTextFormat) {
        this.overlayTextFormat = barcodeOverlayTextFormat;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 35) {
            ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), (arg_0, arg_1) -> BarcodeCameraView.onAttachedToWindow$lambda$5(this, arg_0, arg_1));
        }
    }

    protected void onDetachedFromWindow() {
        this.cameraBinding.barcodeScannerView.getViewController().closeCamera();
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)this), null);
        super.onDetachedFromWindow();
    }

    private final void setBarcodeScanner(BarcodeScanner barcodeScanner) {
        this.cameraBinding.barcodeScannerView.initScanningBehavior(barcodeScanner, this.resultHandler, new IBarcodeScannerViewCallback(this){
            final /* synthetic */ BarcodeCameraView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSelectionOverlayBarcodeClicked(@NotNull BarcodeItem barcodeItem) {
                Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                IBarcodeCameraView.ViewModel viewModel = BarcodeCameraView.access$getViewModel$p(this.this$0);
                if (viewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    viewModel = null;
                }
                viewModel.onSelectionOverlayBarcodeClicked(barcodeItem);
            }

            public void onPictureTaken(@NotNull byte[] image, @NotNull CaptureInfo captureInfo) {
                Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
                this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().useFlash(false);
                IBarcodeCameraView.ViewModel viewModel = BarcodeCameraView.access$getViewModel$p(this.this$0);
                if (viewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    viewModel = null;
                }
                viewModel.pageSnapped(image, captureInfo.getImageOrientation());
            }

            public void onCameraOpen() {
                if (this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.usesCameraX()) {
                    BarcodeCameraView.access$doOnCameraOpen(this.this$0);
                } else {
                    this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.postDelayed(() -> setBarcodeScanner.1.onCameraOpen$lambda$0(this.this$0), 300L);
                }
            }

            private static final void onCameraOpen$lambda$0(BarcodeCameraView this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                BarcodeCameraView.access$doOnCameraOpen(this$0);
            }
        });
    }

    private final void doOnCameraOpen() {
        IBarcodeCameraView.ViewModel viewModel = this.viewModel;
        if (viewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel = null;
        }
        this.updateFlashState((Boolean)viewModel.getFlash().getValue());
        IBarcodeCameraView.ViewModel viewModel2 = this.viewModel;
        if (viewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel2 = null;
        }
        viewModel2.onCameraOpened();
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setCameraPreviewMode(cameraPreviewMode);
    }

    @Override
    public void attachViewModel(@NotNull IBarcodeCameraView.ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
        this.setBarcodeScanner(viewModel.getScanner());
        this.subscribeViews(viewModel);
    }

    @Override
    public void attachPermissionViewModel(@NotNull IPermissionViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.permissionViewModel = viewModel;
        this.subscribePermissionViewModel(viewModel);
    }

    private final void subscribePermissionViewModel(IPermissionViewModel viewModel) {
        LifecycleOwner lifecycleOwner = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
        if (lifecycleOwner != null && (lifecycleOwner = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner)) != null) {
            LifecycleOwner lifecycleOwner2;
            LifecycleOwner $this$subscribePermissionViewModel_u24lambda_u246 = lifecycleOwner2 = lifecycleOwner;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraPermissionGranted()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean granted = this.Z$0;
                            BarcodeCameraView.access$updateCameraPermissionView(this.this$0, granted);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribePermissionViewModel_u24lambda_u246));
        }
        this.cameraBinding.barcodeScannerView.getSelectionOverlayController().setBarcodeAppearanceDelegate(new BarcodePolygonsView.BarcodeAppearanceDelegate(this){
            final /* synthetic */ BarcodeCameraView this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public BarcodePolygonsView.BarcodePolygonStyle getPolygonStyle(@NotNull BarcodePolygonsView.BarcodePolygonStyle defaultStyle, @NotNull BarcodeItem barcodeItem) {
                Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
                Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                Float f = this.this$0.getOverlayStrokeWidth$rtu_ui_barcode_release();
                float f2 = f != null ? f.floatValue() : defaultStyle.getStrokeWidth();
                Integer n = this.this$0.getOverlayPolygonColor$rtu_ui_barcode_release();
                int n2 = n != null ? n.intValue() : defaultStyle.getFillColor();
                Integer n3 = this.this$0.getOverlayHighlightedPolygonColor$rtu_ui_barcode_release();
                int n4 = n3 != null ? n3.intValue() : defaultStyle.getFillHighlightedColor();
                Integer n5 = this.this$0.getOverlayPolygonColor$rtu_ui_barcode_release();
                int n6 = n5 != null ? n5.intValue() : defaultStyle.getStrokeColor();
                Integer n7 = this.this$0.getOverlayHighlightedPolygonColor$rtu_ui_barcode_release();
                int n8 = n7 != null ? n7.intValue() : defaultStyle.getStrokeHighlightedColor();
                return BarcodePolygonsView.BarcodePolygonStyle.copy$default((BarcodePolygonsView.BarcodePolygonStyle)defaultStyle, (boolean)false, (boolean)false, (boolean)false, (float)0.0f, (float)f2, (int)n6, (int)n8, (int)n2, (int)n4, (boolean)false, (int)527, null);
            }

            @NotNull
            public BarcodePolygonsView.BarcodeTextViewStyle getTextViewStyle(@NotNull BarcodePolygonsView.BarcodeTextViewStyle defaultStyle, @NotNull BarcodeItem barcodeItem) {
                Intrinsics.checkNotNullParameter((Object)defaultStyle, (String)"defaultStyle");
                Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
                Integer n = this.this$0.getOverlayTextColor$rtu_ui_barcode_release();
                int n2 = n != null ? n.intValue() : defaultStyle.getTextColor();
                Integer n3 = this.this$0.getOverlayTextHighlightedColor$rtu_ui_barcode_release();
                int n4 = n3 != null ? n3.intValue() : defaultStyle.getTextHighlightedColor();
                Integer n5 = this.this$0.getOverlayTextContainerColor$rtu_ui_barcode_release();
                int n6 = n5 != null ? n5.intValue() : defaultStyle.getTextContainerColor();
                Integer n7 = this.this$0.getOverlayTextContainerHighlightedColor$rtu_ui_barcode_release();
                int n8 = n7 != null ? n7.intValue() : defaultStyle.getTextContainerHighlightedColor();
                BarcodeOverlayTextFormat barcodeOverlayTextFormat = this.this$0.getOverlayTextFormat$rtu_ui_barcode_release();
                if (barcodeOverlayTextFormat == null) {
                    barcodeOverlayTextFormat = defaultStyle.getTextFormat();
                }
                return BarcodePolygonsView.BarcodeTextViewStyle.copy$default((BarcodePolygonsView.BarcodeTextViewStyle)defaultStyle, (int)n2, (int)n4, (int)n6, (int)n8, (BarcodeOverlayTextFormat)barcodeOverlayTextFormat, null, (int)32, null);
            }
        });
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setCameraOrientationMode(cameraOrientationMode);
    }

    @Override
    public void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setCameraModule(cameraModule);
    }

    @Override
    public void setCameraZoomRatio(float zoomRatio) {
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setPhysicalZoomRatio(zoomRatio);
    }

    @Override
    public void setCameraZoomRange(@NotNull ZoomRange zoomRange) {
        Intrinsics.checkNotNullParameter((Object)zoomRange, (String)"zoomRange");
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setPhysicalZoomRange(zoomRange);
    }

    @Override
    public void lockMinFocusDistance(boolean lockMinFocusDistance) {
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().lockMinFocusDistance(lockMinFocusDistance);
    }

    @Override
    public void setBarcodeHighlightedDelegate(@NotNull BarcodePolygonsView.BarcodeHighlightDelegate barcodeHighlightDelegate) {
        Intrinsics.checkNotNullParameter((Object)barcodeHighlightDelegate, (String)"barcodeHighlightDelegate");
        this.cameraBinding.barcodeScannerView.getSelectionOverlayController().setBarcodeHighlightedDelegate(barcodeHighlightDelegate);
    }

    @Override
    public void setSelectionOverlayEnabled(boolean enabled) {
        this.cameraBinding.barcodeScannerView.getSelectionOverlayController().setEnabled(enabled);
    }

    @Override
    public void setSelectionOverlayPolygonColor(int color) {
        this.overlayPolygonColor = color;
    }

    @Override
    public void setSelectionOverlayTextColor(int color) {
        this.overlayTextColor = color;
    }

    @Override
    public void setSelectionOverlayTextFormat(@NotNull BarcodeOverlayTextFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.overlayTextFormat = format;
    }

    @Override
    public void setSelectionOverlayTextContainerColor(int color) {
        this.overlayTextContainerColor = color;
    }

    @Override
    public void setSelectionOverlayHighlightedPolygonColor(int color) {
        this.overlayHighlightedPolygonColor = color;
    }

    @Override
    public void setSelectionOverlayHighlightedTextColor(int color) {
        this.overlayTextHighlightedColor = color;
    }

    @Override
    public void setSelectionOverlayHighlightedTextContainerColor(int color) {
        this.overlayTextContainerHighlightedColor = color;
    }

    public final void initCameraView$rtu_ui_barcode_release(@NotNull CameraUiSettings cameraUiSettings) {
        Intrinsics.checkNotNullParameter((Object)cameraUiSettings, (String)"cameraUiSettings");
        this.cameraBinding.barcodeScannerView.initCamera(cameraUiSettings);
        this.cameraBinding.barcodeScannerView.getCameraConfiguration().setCameraPreviewMode(CameraPreviewMode.FILL_IN);
    }

    private final void subscribeViews(IBarcodeCameraView.ViewModel viewModel) {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner2 == null || (lifecycleOwner2 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner2)) == null) break block0;
            LifecycleOwner $this$subscribeViews_u24lambda_u247 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraOpened()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            if (value) {
                                this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().onResume();
                            } else {
                                this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().onPause();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getStopNewFrames()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().setFrameProcessingEnabled(!value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getFlash()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            BarcodeCameraView.access$updateFlashState(this.this$0, value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getAutoSnapEnabled()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().setAutoSnappingEnabled(value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getBarcodeFilter()), (Function2)((Function2)new Function2<IBarcodeFilter, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ BarcodeCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            IBarcodeFilter barcodeFilter = (IBarcodeFilter)this.L$0;
                            this.this$0.getCameraBinding$rtu_ui_barcode_release().barcodeScannerView.getViewController().setBarcodeFilter(barcodeFilter);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull IBarcodeFilter p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u247));
        }
    }

    private final void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            this.permissionBinding.cameraPermissionView.setVisibility(8);
            if (this.cameraBinding.barcodeScannerView.usesCameraX()) {
                this.cameraBinding.barcodeScannerView.getViewController().restartPreview();
            }
        } else {
            this.permissionBinding.cameraPermissionView.setVisibility(0);
        }
    }

    @Override
    public void setSuccessfulScanningInterval(long scanningIntervalInMs) {
        this.cameraBinding.barcodeScannerView.getViewController().setBarcodeScanningInterval(scanningIntervalInMs);
    }

    private final void updateFlashState(boolean flash) {
        IBarcodeCameraView.ViewModel viewModel = this.viewModel;
        if (viewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel = null;
        }
        if (((Boolean)viewModel.getCameraOpened().getValue()).booleanValue()) {
            this.cameraBinding.flashBtn.setChecked(flash);
            this.cameraBinding.barcodeScannerView.getViewController().useFlash(flash);
        }
    }

    private static final boolean resultHandler$lambda$0(BarcodeCameraView this$0, FrameHandlerResult result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        IBarcodeCameraView.ViewModel viewModel = this$0.viewModel;
        if (viewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel = null;
        }
        viewModel.barcodeScanned((FrameHandlerResult<BarcodeScannerResult, SdkLicenseError>)result);
        return false;
    }

    private static final void _init_$lambda$2(BarcodeCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IBarcodeCameraView.ViewModel viewModel = this$0.viewModel;
        if (viewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel = null;
        }
        viewModel.onCancelClicked();
    }

    private static final void _init_$lambda$3(BarcodeCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IBarcodeCameraView.ViewModel viewModel = this$0.viewModel;
        if (viewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            viewModel = null;
        }
        viewModel.onFlashClicked();
    }

    private static final void _init_$lambda$4(BarcodeCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IPermissionViewModel iPermissionViewModel = this$0.permissionViewModel;
        if (iPermissionViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"permissionViewModel");
            iPermissionViewModel = null;
        }
        iPermissionViewModel.onActivateCameraPermission();
    }

    private static final WindowInsetsCompat onAttachedToWindow$lambda$5(BarcodeCameraView this$0, View view, WindowInsetsCompat windowInsets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Insets insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        this$0.cameraBinding.cameraTopToolbar.setPadding(0, insets2.top, 0, 0);
        return WindowInsetsCompat.CONSUMED;
    }

    public static final /* synthetic */ IBarcodeCameraView.ViewModel access$getViewModel$p(BarcodeCameraView $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ void access$doOnCameraOpen(BarcodeCameraView $this) {
        $this.doOnCameraOpen();
    }

    public static final /* synthetic */ void access$updateCameraPermissionView(BarcodeCameraView $this, boolean cameraPermissionGranted) {
        $this.updateCameraPermissionView(cameraPermissionGranted);
    }

    public static final /* synthetic */ void access$updateFlashState(BarcodeCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/barcode/BarcodeCameraView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "rtu-ui-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

