/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.barcodescanner.model;

import android.graphics.Bitmap;
import android.graphics.Point;
import io.scanbot.barcodescanner.model.BarcodeMetadataKey;
import io.scanbot.barcodescanner.model.BarcodeType;
import io.scanbot.genericdocument.entity.GenericDocument;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\tH\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lio/scanbot/barcodescanner/model/BarcodeItem;", "", "rawString", "", "parsedDocument", "Lio/scanbot/genericdocument/entity/GenericDocument;", "rawBytes", "", "decodedType", "", "image", "Landroid/graphics/Bitmap;", "pointsList", "", "Landroid/graphics/Point;", "metadataInternal", "", "(Ljava/lang/String;Lio/scanbot/genericdocument/entity/GenericDocument;[BILandroid/graphics/Bitmap;Ljava/util/List;Ljava/util/Map;)V", "getImage", "()Landroid/graphics/Bitmap;", "metadata", "Lio/scanbot/barcodescanner/model/BarcodeMetadataKey;", "getMetadata", "()Ljava/util/Map;", "getParsedDocument", "()Lio/scanbot/genericdocument/entity/GenericDocument;", "getPointsList", "()Ljava/util/List;", "getRawBytes", "()[B", "getRawString", "()Ljava/lang/String;", "type", "Lio/scanbot/barcodescanner/model/BarcodeType;", "getType", "()Lio/scanbot/barcodescanner/model/BarcodeType;", "typeFromInt", "value", "core-barcode_release"})
@SourceDebugExtension(value={"SMAP\nBarcodeItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarcodeItem.kt\nio/scanbot/barcodescanner/model/BarcodeItem\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n467#2,3:82\n470#2,4:92\n457#2:96\n403#2:97\n11335#3:85\n11670#3,3:86\n1747#4,3:89\n1238#4,4:98\n*S KotlinDebug\n*F\n+ 1 BarcodeItem.kt\nio/scanbot/barcodescanner/model/BarcodeItem\n*L\n40#1:82,3\n40#1:92,4\n42#1:96\n42#1:97\n41#1:85\n41#1:86,3\n41#1:89,3\n42#1:98,4\n*E\n"})
public final class BarcodeItem {
    @NotNull
    private final String rawString;
    @Nullable
    private final GenericDocument parsedDocument;
    @NotNull
    private final byte[] rawBytes;
    @Nullable
    private final Bitmap image;
    @NotNull
    private final List<Point> pointsList;
    @NotNull
    private final BarcodeType type;
    @NotNull
    private final Map<BarcodeMetadataKey, String> metadata;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BarcodeItem(@NotNull String rawString, @Nullable GenericDocument parsedDocument, @NotNull byte[] rawBytes, int decodedType, @Nullable Bitmap image, @NotNull List<? extends Point> pointsList, @NotNull Map<String, String> metadataInternal) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        void var4_9;
        Object object;
        LinkedHashMap linkedHashMap3;
        void var7_13;
        ArrayList<String> arrayList;
        void var3_3;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"rawString");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"rawBytes");
        Intrinsics.checkNotNullParameter((Object)arrayList, (String)"pointsList");
        Intrinsics.checkNotNullParameter((Object)var7_13, (String)"metadataInternal");
        this.rawString = object2;
        this.parsedDocument = linkedHashMap3;
        this.rawBytes = var3_3;
        this.image = object;
        this.pointsList = arrayList;
        this.type = this.typeFromInt((int)var4_9);
        object2 = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : metadataInternal.entrySet()) {
            boolean bl;
            ArrayList<String> arrayList2;
            String string = (String)entry.getKey();
            object = BarcodeMetadataKey.values();
            arrayList = arrayList2;
            arrayList2 = new ArrayList<String>(((BarcodeMetadataKey[])object).length);
            int n = ((BarcodeMetadataKey[])object).length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(object[i].name());
            }
            if (!arrayList.isEmpty()) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    if (!Intrinsics.areEqual((Object)((String)object.next()), (Object)string)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            Map.Entry entry2 = entry;
            Object k = entry2.getKey();
            ((AbstractMap)object2).put(k, entry2.getValue());
        }
        linkedHashMap3 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity((int)object2.size()));
        object2 = object2.entrySet().iterator();
        while (true) {
            if (!object2.hasNext()) {
                this.metadata = linkedHashMap3;
                return;
            }
            Map.Entry entry = (Map.Entry)object2.next();
            BarcodeMetadataKey barcodeMetadataKey = BarcodeMetadataKey.valueOf((String)entry.getKey());
            linkedHashMap3.put(barcodeMetadataKey, entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BarcodeType typeFromInt(int value) {
        BarcodeType barcodeType;
        switch (value) {
            default: {
                void var1_1;
                throw new IllegalStateException("Unknown barcode type from core: " + (int)var1_1);
            }
            case 29: {
                barcodeType = BarcodeType.GS1_COMPOSITE;
                break;
            }
            case 28: {
                barcodeType = BarcodeType.MICRO_PDF_417;
                break;
            }
            case 27: {
                barcodeType = BarcodeType.DATABAR_LIMITED;
                break;
            }
            case 26: {
                barcodeType = BarcodeType.AUSTRALIA_POST;
                break;
            }
            case 25: {
                barcodeType = BarcodeType.ROYAL_TNT_POST;
                break;
            }
            case 24: {
                barcodeType = BarcodeType.JAPAN_POST;
                break;
            }
            case 23: {
                barcodeType = BarcodeType.ROYAL_MAIL;
                break;
            }
            case 22: {
                barcodeType = BarcodeType.USPS_INTELLIGENT_MAIL;
                break;
            }
            case 21: {
                barcodeType = BarcodeType.MICRO_QR_CODE;
                break;
            }
            case 20: {
                barcodeType = BarcodeType.CODE_25;
                break;
            }
            case 19: {
                barcodeType = BarcodeType.INDUSTRIAL_2_OF_5;
                break;
            }
            case 18: {
                barcodeType = BarcodeType.IATA_2_OF_5;
                break;
            }
            case 17: {
                barcodeType = BarcodeType.MSI_PLESSEY;
                break;
            }
            case 15: {
                barcodeType = BarcodeType.UPC_E;
                break;
            }
            case 14: {
                barcodeType = BarcodeType.UPC_A;
                break;
            }
            case 13: {
                barcodeType = BarcodeType.DATABAR_EXPANDED;
                break;
            }
            case 12: {
                barcodeType = BarcodeType.DATABAR;
                break;
            }
            case 11: {
                barcodeType = BarcodeType.QR_CODE;
                break;
            }
            case 10: {
                barcodeType = BarcodeType.PDF_417;
                break;
            }
            case 8: {
                barcodeType = BarcodeType.ITF;
                break;
            }
            case 7: {
                barcodeType = BarcodeType.EAN_13;
                break;
            }
            case 6: {
                barcodeType = BarcodeType.EAN_8;
                break;
            }
            case 5: {
                barcodeType = BarcodeType.DATA_MATRIX;
                break;
            }
            case 4: {
                barcodeType = BarcodeType.CODE_128;
                break;
            }
            case 3: {
                barcodeType = BarcodeType.CODE_93;
                break;
            }
            case 2: {
                barcodeType = BarcodeType.CODE_39;
                break;
            }
            case 1: {
                barcodeType = BarcodeType.CODABAR;
                break;
            }
            case 0: {
                barcodeType = BarcodeType.AZTEC;
            }
        }
        return barcodeType;
    }

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @Nullable
    public final GenericDocument getParsedDocument() {
        return this.parsedDocument;
    }

    @NotNull
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Nullable
    public final Bitmap getImage() {
        return this.image;
    }

    @NotNull
    public final List<Point> getPointsList() {
        return this.pointsList;
    }

    @NotNull
    public final BarcodeType getType() {
        return this.type;
    }

    @NotNull
    public final Map<BarcodeMetadataKey, String> getMetadata() {
        return this.metadata;
    }
}

