/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.common.util;

import android.os.Build;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/scanbot/common/util/TensorFlowUtils;", "", "()V", "Companion", "core-common_release"})
public final class TensorFlowUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> MODELS_WITHOUT_GPU_PROGRAM_CACHING = CollectionsKt.listOf((Object[])new String[]{"SAMSUNG_SM-S908", "SAMSUNG_SM-S906", "SAMSUNG_SM-S901"});
    @NotNull
    private static final List<String> MODELS_WITHOUT_GPU_ACCELERATION = CollectionsKt.listOf((Object[])new String[]{"CAT_S52", "BLACKVIEW_BV4900", "REDMI_ANGELICA", "REDMI_ANGELICAN", "REDMI_M2006C3MNG", "REDMI_M2006C3MG", "REDMI_DANDELION", "REDMI_220233L2G", "REDMI_M2006C3LC", "REDMI_M2006C3LG", "REDMI_M2006C3LI", "REDMI_M2006C3LVG", "REDMI_CATTAIL", "REDMI_M2006C3MII", "REDMI_GALAHAD", "REDMI_M2004J19C", "REDMI_M2004J19G", "REDMI_M2010J19SI"});
    @NotNull
    private static final List<String> BRANDS_WITHOUT_GPU_ACCELERATION = CollectionsKt.listOf((Object)"WIKO");

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void prepareTensorFlow(boolean allowXnnpackAcceleration, boolean allowGpuAcceleration) {
        void var1_1;
        boolean bl;
        Companion.prepareTensorFlow(bl, (boolean)var1_1);
    }

    @JvmStatic
    private static final native void allowXnnpackAcceleration(boolean var0);

    @JvmStatic
    private static final native void allowGpuAcceleration(boolean var0);

    @JvmStatic
    private static final native void allowGpuProgramCaching(boolean var0);

    @JvmStatic
    public static final native void precompilePrograms(@NotNull String var0);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0083 J\u0011\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0083 J\u0011\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0083 J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0002J\u0011\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0005H\u0087 J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/scanbot/common/util/TensorFlowUtils$Companion;", "", "()V", "BRANDS_WITHOUT_GPU_ACCELERATION", "", "", "MODELS_WITHOUT_GPU_ACCELERATION", "MODELS_WITHOUT_GPU_PROGRAM_CACHING", "allowGpuAcceleration", "", "enable", "", "allowGpuProgramCaching", "allowXnnpackAcceleration", "getDeviceBrandName", "getDeviceModelByBrandName", "getDeviceModelName", "precompilePrograms", "codeCacheDirPath", "prepareTensorFlow", "core-common_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getDeviceModelByBrandName() {
            return this.getDeviceBrandName() + '_' + this.getDeviceModelName();
        }

        private final String getDeviceModelName() {
            String string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            return string2;
        }

        private final String getDeviceBrandName() {
            String string = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            return string2;
        }

        @JvmStatic
        private final void allowXnnpackAcceleration(boolean enable) {
            TensorFlowUtils.allowXnnpackAcceleration(enable);
        }

        @JvmStatic
        private final void allowGpuAcceleration(boolean enable) {
            TensorFlowUtils.allowGpuAcceleration(enable);
        }

        @JvmStatic
        private final void allowGpuProgramCaching(boolean enable) {
            TensorFlowUtils.allowGpuProgramCaching(enable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void prepareTensorFlow(boolean allowXnnpackAcceleration, boolean allowGpuAcceleration) {
            void var1_1;
            Companion companion = this;
            String string = companion.getDeviceModelByBrandName();
            String string2 = companion.getDeviceBrandName();
            if (MODELS_WITHOUT_GPU_PROGRAM_CACHING.contains(string)) {
                this.allowGpuProgramCaching(false);
            }
            if (!BRANDS_WITHOUT_GPU_ACCELERATION.contains(string2) && !MODELS_WITHOUT_GPU_ACCELERATION.contains(string)) {
                void var2_2;
                this.allowGpuAcceleration((boolean)var2_2);
            } else {
                this.allowGpuAcceleration(false);
            }
            this.allowXnnpackAcceleration((boolean)var1_1);
        }

        @JvmStatic
        public final void precompilePrograms(@NotNull String codeCacheDirPath) {
            TensorFlowUtils.precompilePrograms(codeCacheDirPath);
        }
    }
}

