/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sap;

import android.content.Context;
import android.text.TextUtils;
import io.scanbot.sap.SDKLicenseErrorHandler;
import io.scanbot.sap.SapManagerKt;
import io.scanbot.sdk.licensing.Feature;
import io.scanbot.sdk.licensing.LicenseInfo;
import io.scanbot.sdk.licensing.LicenseStatus;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\b\u001a\u00020\u0006H\u0082 J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0011\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0082 J\t\u0010\u000f\u001a\u00020\u0010H\u0082 J\t\u0010\u0011\u001a\u00020\u0012H\u0082 J\t\u0010\u0013\u001a\u00020\u0014H\u0086 J\t\u0010\u0015\u001a\u00020\u0016H\u0082 J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0010J\u001b\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!H\u0082 J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0004J\u0011\u0010&\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0082 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006'"}, d2={"Lio/scanbot/sap/SapManager;", "", "()V", "handler", "Lio/scanbot/sap/SDKLicenseErrorHandler;", "isLicenseActive", "", "()Z", "active", "checkLicenseStatus", "feature", "Lio/scanbot/sdk/licensing/Feature;", "checkLicenseStatusSilently", "enabled", "f", "getLicenseErrorMessage", "", "getLicenseExpiration", "", "getLicenseInfo", "Lio/scanbot/sdk/licensing/LicenseInfo;", "getStatusOfLicense", "", "handleLicenseStatusError", "", "status", "Lio/scanbot/sdk/licensing/LicenseStatus;", "message", "install", "context", "Landroid/content/Context;", "licenseStr", "array", "", "isFeatureActive", "licenseInfo", "setLicenseErrorHandler", "licenseErrorHandler", "setLicenseFailureHandler", "core-sap_release"})
public final class SapManager {
    @NotNull
    private SDKLicenseErrorHandler handler = new SDKLicenseErrorHandler(){

        public void handle(@NotNull LicenseStatus status, @NotNull Feature feature, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        }
    };

    public final void install(@Nullable Context context, @NotNull String licenseStr) {
        Intrinsics.checkNotNullParameter((Object)licenseStr, (String)"licenseStr");
        Object licenseStr2 = licenseStr;
        if (!TextUtils.isEmpty((CharSequence)((CharSequence)licenseStr2))) {
            Object object = licenseStr2 = (String)licenseStr2 + "\u0000";
            Charset charset = Charset.forName("ASCII");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] license = byArray;
            this.install((Object)context, license);
        }
        this.setLicenseFailureHandler(this.handler);
    }

    public final boolean isLicenseActive() {
        return this.active();
    }

    public final boolean checkLicenseStatusSilently(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return this.isFeatureActive(feature, this.getLicenseInfo());
    }

    private final boolean isFeatureActive(Feature feature, LicenseInfo licenseInfo) {
        return SapManagerKt.isValid(licenseInfo) && this.enabled(feature);
    }

    public final boolean checkLicenseStatus(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        LicenseInfo licenseInfo = this.getLicenseInfo();
        boolean featureActive = this.isFeatureActive(feature, licenseInfo);
        if (!featureActive) {
            this.handleLicenseStatusError(licenseInfo.getStatus(), feature, licenseInfo.getLicenseStatusMessage());
        }
        return featureActive;
    }

    private final void handleLicenseStatusError(LicenseStatus status, Feature feature, String message) {
        this.handler.handle(status, feature, message);
    }

    public final void setLicenseErrorHandler(@NotNull SDKLicenseErrorHandler licenseErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)licenseErrorHandler, (String)"licenseErrorHandler");
        this.handler = licenseErrorHandler;
        this.setLicenseFailureHandler(this.handler);
    }

    private final native boolean active();

    private final native boolean enabled(Feature var1);

    private final native void install(Object var1, byte[] var2);

    private final native void setLicenseFailureHandler(SDKLicenseErrorHandler var1);

    private final native int getStatusOfLicense();

    private final native long getLicenseExpiration();

    private final native String getLicenseErrorMessage();

    @NotNull
    public final native LicenseInfo getLicenseInfo();
}

