/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk_wrapper.barcode;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.core.net.UriKt;
import io.scanbot.sap.SdkLicenseInfo;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeScannerAdditionalConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScannerConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.barcode.entity.Gs1Handling;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.ui.view.barcode.InternalBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeScannerActivity;
import io.scanbot.sdk.ui.view.barcode.batch.configuration.BatchBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfiguration;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk_wrapper.SBWrapper;
import io.scanbot.sdk_wrapper.barcode.SBWrapperOperations;
import io.scanbot.sdk_wrapper.barcode.configurations.SBWrapperBarcodesOnImageArguments;
import io.scanbot.sdk_wrapper.barcode.configurations.SBWrapperImagesFromPdfArguments;
import io.scanbot.sdk_wrapper.barcode.results.SBWrapperBarcodeScannerResult;
import io.scanbot.sdk_wrapper.barcode.ui.SBWrapperRtuBarcodeScanner;
import io.scanbot.sdk_wrapper.barcode.ui.SBWrapperRtuBatchBarcodeScanner;
import io.scanbot.sdk_wrapper.exceptions.SBWrapperExceptions;
import io.scanbot.sdk_wrapper.extensions.SBWrapperUriExtensionKt;
import io.scanbot.sdk_wrapper.interfaces.SBWrapperResultDelegate;
import io.scanbot.sdk_wrapper.results.SBWrapperLicenseInfoResult;
import io.scanbot.sdk_wrapper.ui.SBWrapperRtuUI;
import io.scanbot.sdk_wrapper.utils.SBWrapperSDKChecks;
import io.scanbot.sdk_wrapper.utils.SBWrapperStorageUtils;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ;\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0004\b!\u0010\"J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J#\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u00a2\u0006\u0004\b(\u0010)J\"\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u000100H\u0007JG\u00101\u001a\u0004\u0018\u00010\u00102\u0006\u00102\u001a\u0002032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020705H\u0000\u00a2\u0006\u0004\b8\u00109JG\u0010:\u001a\u0004\u0018\u00010\u00102\u0006\u00102\u001a\u0002032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020<05H\u0000\u00a2\u0006\u0004\b=\u00109R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006>"}, d2={"Lio/scanbot/sdk_wrapper/barcode/SBWrapperOperations;", "", "()V", "barcodeScanner", "Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScanner;", "getBarcodeScanner$barcode_sdk_wrapper_release", "()Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScanner;", "setBarcodeScanner$barcode_sdk_wrapper_release", "(Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBarcodeScanner;)V", "batchBarcodeScanner", "Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBatchBarcodeScanner;", "getBatchBarcodeScanner$barcode_sdk_wrapper_release", "()Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBatchBarcodeScanner;", "setBatchBarcodeScanner$barcode_sdk_wrapper_release", "(Lio/scanbot/sdk_wrapper/barcode/ui/SBWrapperRtuBatchBarcodeScanner;)V", "detectBarcodesOnImage", "", "licenseInfo", "Lio/scanbot/sap/SdkLicenseInfo;", "configurationAsJSON", "", "resultDelegate", "Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;", "barcodeDetector", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "detectBarcodesOnImage$barcode_sdk_wrapper_release", "(Lio/scanbot/sap/SdkLicenseInfo;Ljava/lang/String;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;)Lkotlin/Unit;", "extractImagesFromPDF", "argsAsJSON", "pdfImagesExtractor", "Lio/scanbot/sdk/pdf/PdfImagesExtractor;", "outputDir", "Ljava/io/File;", "extractImagesFromPDF$barcode_sdk_wrapper_release", "(Lio/scanbot/sap/SdkLicenseInfo;Ljava/lang/String;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;Lio/scanbot/sdk/pdf/PdfImagesExtractor;Ljava/io/File;)Lkotlin/Unit;", "getBitmapFromImageUri", "Landroid/graphics/Bitmap;", "imageUri", "Landroid/net/Uri;", "getLicenseInfo", "getLicenseInfo$barcode_sdk_wrapper_release", "(Lio/scanbot/sap/SdkLicenseInfo;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;)Lkotlin/Unit;", "onActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "startBarcodeScanner", "activity", "Landroid/app/Activity;", "resultContract", "Landroidx/activity/result/contract/ActivityResultContract;", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui/view/barcode/InternalBarcodeScannerActivity$InternalResult;", "startBarcodeScanner$barcode_sdk_wrapper_release", "(Landroid/app/Activity;Lio/scanbot/sap/SdkLicenseInfo;Ljava/lang/String;Lio/scanbot/sdk_wrapper/interfaces/SBWrapperResultDelegate;Landroidx/activity/result/contract/ActivityResultContract;)Lkotlin/Unit;", "startBatchBarcodeScanner", "Lio/scanbot/sdk/ui/view/barcode/batch/configuration/BatchBarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui/view/barcode/batch/InternalBatchBarcodeScannerActivity$InternalResult;", "startBatchBarcodeScanner$barcode_sdk_wrapper_release", "barcode-sdk-wrapper_release"})
public final class SBWrapperOperations {
    @NotNull
    public static final SBWrapperOperations INSTANCE = new SBWrapperOperations();
    @Nullable
    private static SBWrapperRtuBarcodeScanner barcodeScanner;
    @Nullable
    private static SBWrapperRtuBatchBarcodeScanner batchBarcodeScanner;

    private SBWrapperOperations() {
    }

    @Nullable
    public final SBWrapperRtuBarcodeScanner getBarcodeScanner$barcode_sdk_wrapper_release() {
        return barcodeScanner;
    }

    public final void setBarcodeScanner$barcode_sdk_wrapper_release(@Nullable SBWrapperRtuBarcodeScanner sBWrapperRtuBarcodeScanner) {
        barcodeScanner = sBWrapperRtuBarcodeScanner;
    }

    @Nullable
    public final SBWrapperRtuBatchBarcodeScanner getBatchBarcodeScanner$barcode_sdk_wrapper_release() {
        return batchBarcodeScanner;
    }

    public final void setBatchBarcodeScanner$barcode_sdk_wrapper_release(@Nullable SBWrapperRtuBatchBarcodeScanner sBWrapperRtuBatchBarcodeScanner) {
        batchBarcodeScanner = sBWrapperRtuBatchBarcodeScanner;
    }

    @Nullable
    public final Unit getLicenseInfo$barcode_sdk_wrapper_release(@NotNull SdkLicenseInfo licenseInfo, @Nullable SBWrapperResultDelegate resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, licenseInfo, resultDelegate, false, false, (Function0)new Function0<Unit>(licenseInfo, resultDelegate){
            final /* synthetic */ SdkLicenseInfo $licenseInfo;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$licenseInfo = $licenseInfo;
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                SBWrapperLicenseInfoResult $this$invoke_u24lambda_u240 = SBWrapperLicenseInfoResult.Companion.fromNativeLicenseInfo(this.$licenseInfo);
                boolean bl = false;
                String wrapperLicenseInfoAsJSON = SBWrapper.INSTANCE.getGson().toJson((Object)$this$invoke_u24lambda_u240);
                SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, this.$resultDelegate, new JSONObject(wrapperLicenseInfoAsJSON), null, 4, null);
            }
        }, 4, null);
    }

    @Nullable
    public final Unit detectBarcodesOnImage$barcode_sdk_wrapper_release(@NotNull SdkLicenseInfo licenseInfo, @NotNull String configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate, @NotNull ScanbotBarcodeDetector barcodeDetector) {
        Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter((Object)barcodeDetector, (String)"barcodeDetector");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, licenseInfo, resultDelegate, false, false, (Function0)new Function0<Unit>(configurationAsJSON, resultDelegate, barcodeDetector){
            final /* synthetic */ String $configurationAsJSON;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            final /* synthetic */ ScanbotBarcodeDetector $barcodeDetector;
            {
                this.$configurationAsJSON = $configurationAsJSON;
                this.$resultDelegate = $resultDelegate;
                this.$barcodeDetector = $barcodeDetector;
                super(0);
            }

            public final void invoke() {
                SBWrapper.INSTANCE.getThreadPool().execute(() -> detectBarcodesOnImage.1.invoke$lambda$2(this.$configurationAsJSON, this.$resultDelegate, this.$barcodeDetector));
            }

            private static final void invoke$lambda$2(String $configurationAsJSON, SBWrapperResultDelegate $resultDelegate, ScanbotBarcodeDetector $barcodeDetector) {
                Intrinsics.checkNotNullParameter((Object)$configurationAsJSON, (String)"$configurationAsJSON");
                Intrinsics.checkNotNullParameter((Object)$barcodeDetector, (String)"$barcodeDetector");
                try {
                    Unit unit;
                    Object object = SBWrapper.INSTANCE.getGson().fromJson($configurationAsJSON, SBWrapperBarcodesOnImageArguments.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    SBWrapperBarcodesOnImageArguments wrapperBarcodeScannerConfig = (SBWrapperBarcodesOnImageArguments)object;
                    Bitmap bitmap = null;
                    try {
                        bitmap = SBWrapperOperations.access$getBitmapFromImageUri(SBWrapperOperations.INSTANCE, wrapperBarcodeScannerConfig.getImageUri());
                    }
                    catch (Exception ex) {
                        LoggerProvider.getLogger().e(SBWrapper.INSTANCE.getLoggerTag(), "Bitmap from URI not created");
                        SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release($resultDelegate, ex);
                        return;
                    }
                    $barcodeDetector.modifyConfig((Function1)new Function1<BarcodeScannerConfigBuilder, Unit>(wrapperBarcodeScannerConfig){
                        final /* synthetic */ SBWrapperBarcodesOnImageArguments $wrapperBarcodeScannerConfig;
                        {
                            this.$wrapperBarcodeScannerConfig = $wrapperBarcodeScannerConfig;
                            super(1);
                        }

                        public final void invoke(@NotNull BarcodeScannerConfigBuilder $this$modifyConfig) {
                            EngineMode it;
                            Intrinsics.checkNotNullParameter((Object)$this$modifyConfig, (String)"$this$modifyConfig");
                            EngineMode engineMode = this.$wrapperBarcodeScannerConfig.getBarcodeFormats();
                            if (engineMode != null) {
                                it = engineMode;
                                boolean bl = false;
                                $this$modifyConfig.setBarcodeFormats(it);
                            }
                            List<BarcodeDocumentFormat> list = this.$wrapperBarcodeScannerConfig.getAcceptedDocumentFormats();
                            if (list != null) {
                                it = list;
                                boolean bl = false;
                                $this$modifyConfig.setAcceptedDocumentFormats(it);
                            }
                            EngineMode engineMode2 = this.$wrapperBarcodeScannerConfig.getEngineMode();
                            if (engineMode2 != null) {
                                it = engineMode2;
                                boolean bl = false;
                                $this$modifyConfig.setEngineMode(it);
                            }
                            Boolean bl = this.$wrapperBarcodeScannerConfig.getSaveCameraPreviewFrame();
                            if (bl != null) {
                                boolean it2 = bl;
                                boolean bl2 = false;
                                $this$modifyConfig.setSaveCameraPreviewFrame(it2);
                            }
                            $this$modifyConfig.modifyAdditionalConfig((Function1)new Function1<BarcodeScannerAdditionalConfigBuilder, Unit>(this.$wrapperBarcodeScannerConfig){
                                final /* synthetic */ SBWrapperBarcodesOnImageArguments $wrapperBarcodeScannerConfig;
                                {
                                    this.$wrapperBarcodeScannerConfig = $wrapperBarcodeScannerConfig;
                                    super(1);
                                }

                                public final void invoke(@NotNull BarcodeScannerAdditionalConfigBuilder $this$modifyAdditionalConfig) {
                                    block8: {
                                        int it;
                                        Intrinsics.checkNotNullParameter((Object)$this$modifyAdditionalConfig, (String)"$this$modifyAdditionalConfig");
                                        Integer n = this.$wrapperBarcodeScannerConfig.getMinimumTextLength();
                                        if (n != null) {
                                            it = ((Number)n).intValue();
                                            boolean bl = false;
                                            $this$modifyAdditionalConfig.setMinimumTextLength(it);
                                        }
                                        Integer n2 = this.$wrapperBarcodeScannerConfig.getMaximumTextLength();
                                        if (n2 != null) {
                                            it = ((Number)n2).intValue();
                                            boolean bl = false;
                                            $this$modifyAdditionalConfig.setMaximumTextLength(it);
                                        }
                                        Integer n3 = this.$wrapperBarcodeScannerConfig.getMinimum1DBarcodesQuietZone();
                                        if (n3 != null) {
                                            it = ((Number)n3).intValue();
                                            boolean bl = false;
                                            $this$modifyAdditionalConfig.setMinimum1DQuietZoneSize(it);
                                        }
                                        Gs1Handling gs1Handling = this.$wrapperBarcodeScannerConfig.getGs1HandlingMode();
                                        if (gs1Handling != null) {
                                            Gs1Handling it2 = gs1Handling;
                                            boolean bl = false;
                                            $this$modifyAdditionalConfig.setGs1HandlingMode(it2);
                                        }
                                        List<MSIPlesseyChecksumAlgorithm> list = this.$wrapperBarcodeScannerConfig.getMsiPlesseyChecksumAlgorithm();
                                        if (list != null) {
                                            List<MSIPlesseyChecksumAlgorithm> it3 = list;
                                            boolean bl = false;
                                            if (!((Collection)it3).isEmpty()) {
                                                EnumSet<E> enumSet = EnumSet.copyOf(it3);
                                                Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(...)");
                                                $this$modifyAdditionalConfig.setMsiPlesseyChecksumAlgorithms(enumSet);
                                            }
                                        }
                                        Boolean bl = this.$wrapperBarcodeScannerConfig.getStripCheckDigits();
                                        if (bl != null) {
                                            boolean it4 = bl;
                                            boolean bl2 = false;
                                            $this$modifyAdditionalConfig.setStripCheckDigits(it4);
                                        }
                                        Boolean bl3 = this.$wrapperBarcodeScannerConfig.getLowPowerMode();
                                        if (bl3 != null) {
                                            boolean it5 = bl3;
                                            boolean bl4 = false;
                                            $this$modifyAdditionalConfig.setLowPowerMode(it5);
                                        }
                                        BarcodeDensity barcodeDensity = this.$wrapperBarcodeScannerConfig.getCodeDensity();
                                        if (barcodeDensity == null) break block8;
                                        BarcodeDensity it6 = barcodeDensity;
                                        boolean bl5 = false;
                                        $this$modifyAdditionalConfig.setCodeDensity(it6);
                                    }
                                }
                            });
                        }
                    });
                    BarcodeScanningResult barcodeScanningResult = $barcodeDetector.detectFromBitmap(bitmap, 0);
                    if (barcodeScanningResult != null) {
                        BarcodeScanningResult it = barcodeScanningResult;
                        boolean bl = false;
                        SBWrapperBarcodeScannerResult $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = SBWrapperBarcodeScannerResult.Companion.fromNativeBarcodeResult(it);
                        boolean bl2 = false;
                        String barcodeResultAsJSON = SBWrapper.INSTANCE.getGson().toJson((Object)$this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240);
                        SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, $resultDelegate, new JSONObject(barcodeResultAsJSON), null, 4, null);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, $resultDelegate, new JSONObject(), null, 4, null);
                    }
                }
                catch (Exception ex) {
                    LoggerProvider.getLogger().e(SBWrapper.INSTANCE.getLoggerTag(), ex.getMessage());
                    SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release($resultDelegate, new SBWrapperExceptions.SBWrapperUnexpectedError(ex.getMessage()));
                }
            }
        }, 12, null);
    }

    @Nullable
    public final Unit extractImagesFromPDF$barcode_sdk_wrapper_release(@NotNull SdkLicenseInfo licenseInfo, @NotNull String argsAsJSON, @Nullable SBWrapperResultDelegate resultDelegate, @NotNull PdfImagesExtractor pdfImagesExtractor, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
        Intrinsics.checkNotNullParameter((Object)argsAsJSON, (String)"argsAsJSON");
        Intrinsics.checkNotNullParameter((Object)pdfImagesExtractor, (String)"pdfImagesExtractor");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, licenseInfo, resultDelegate, false, false, (Function0)new Function0<Unit>(argsAsJSON, pdfImagesExtractor, outputDir, resultDelegate){
            final /* synthetic */ String $argsAsJSON;
            final /* synthetic */ PdfImagesExtractor $pdfImagesExtractor;
            final /* synthetic */ File $outputDir;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            {
                this.$argsAsJSON = $argsAsJSON;
                this.$pdfImagesExtractor = $pdfImagesExtractor;
                this.$outputDir = $outputDir;
                this.$resultDelegate = $resultDelegate;
                super(0);
            }

            public final void invoke() {
                SBWrapper.INSTANCE.getThreadPool().execute(() -> extractImagesFromPDF.1.invoke$lambda$0(this.$argsAsJSON, this.$pdfImagesExtractor, this.$outputDir, this.$resultDelegate));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$lambda$0(String $argsAsJSON, PdfImagesExtractor $pdfImagesExtractor, File $outputDir, SBWrapperResultDelegate $resultDelegate) {
                Intrinsics.checkNotNullParameter((Object)$argsAsJSON, (String)"$argsAsJSON");
                Intrinsics.checkNotNullParameter((Object)$pdfImagesExtractor, (String)"$pdfImagesExtractor");
                Intrinsics.checkNotNullParameter((Object)$outputDir, (String)"$outputDir");
                File pdfFile = null;
                boolean deletePdfFile = false;
                try {
                    File file;
                    Object object = SBWrapper.INSTANCE.getGson().fromJson($argsAsJSON, SBWrapperImagesFromPdfArguments.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    SBWrapperImagesFromPdfArguments args = (SBWrapperImagesFromPdfArguments)object;
                    if (args.getPdfUri() == null) {
                        throw new SBWrapperExceptions.SBWrapperUriParsingError(null, 1, null);
                    }
                    Uri uri = args.getPdfUri();
                    Intrinsics.checkNotNull((Object)uri);
                    if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                        Uri uri2 = args.getPdfUri();
                        Intrinsics.checkNotNull((Object)uri2);
                        file = UriKt.toFile((Uri)uri2);
                    } else {
                        deletePdfFile = true;
                        Uri uri3 = args.getPdfUri();
                        Intrinsics.checkNotNull((Object)uri3);
                        File file2 = SBWrapperStorageUtils.INSTANCE.getBaseDirectory();
                        ContentResolver contentResolver = SBWrapper.INSTANCE.getApplication().getContentResolver();
                        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
                        file = SBWrapperUriExtensionKt.toFileInDirectory(uri3, file2, contentResolver);
                    }
                    pdfFile = file;
                    List imagesUris = PdfImagesExtractor.DefaultImpls.imageUrlsFromPdf$default((PdfImagesExtractor)$pdfImagesExtractor, (File)pdfFile, (File)$outputDir, (String)"image", (Bitmap.CompressFormat)args.getCompression(), (int)args.getQuality(), (float)args.getScaling(), null, null, null, (int)448, null);
                    SBWrapperResultDelegate.Companion.sendSuccessOnMainThread$barcode_sdk_wrapper_release$default(SBWrapperResultDelegate.Companion, $resultDelegate, imagesUris.toString(), null, 4, null);
                }
                catch (Exception ex) {
                    LoggerProvider.getLogger().e(SBWrapper.INSTANCE.getLoggerTag(), ex.getMessage());
                    SBWrapperResultDelegate.Companion.sendFailureOnMainThread$barcode_sdk_wrapper_release($resultDelegate, new SBWrapperExceptions.SBWrapperUnexpectedError(ex.getMessage()));
                }
                finally {
                    if (deletePdfFile) {
                        try {
                            File file;
                            File file3 = file = pdfFile;
                            if (file3 != null) {
                                file3.delete();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }, 12, null);
    }

    @Nullable
    public final Unit startBarcodeScanner$barcode_sdk_wrapper_release(@NotNull Activity activity, @NotNull SdkLicenseInfo licenseInfo, @NotNull String configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate, @NotNull ActivityResultContract<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult> resultContract) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter(resultContract, (String)"resultContract");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, licenseInfo, resultDelegate, false, false, (Function0)new Function0<Unit>(configurationAsJSON, resultContract, resultDelegate, activity){
            final /* synthetic */ String $configurationAsJSON;
            final /* synthetic */ ActivityResultContract<BarcodeScannerConfiguration, InternalBarcodeScannerActivity.InternalResult> $resultContract;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            final /* synthetic */ Activity $activity;
            {
                this.$configurationAsJSON = $configurationAsJSON;
                this.$resultContract = $resultContract;
                this.$resultDelegate = $resultDelegate;
                this.$activity = $activity;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$invoke_u24lambda_u240;
                SBWrapperRtuBarcodeScanner sBWrapperRtuBarcodeScanner = new SBWrapperRtuBarcodeScanner(BarcodeScannerConfiguration.Companion.fromJson(this.$configurationAsJSON), this.$resultContract, this.$resultDelegate);
                Activity activity = this.$activity;
                SBWrapperRtuBarcodeScanner sBWrapperRtuBarcodeScanner2 = sBWrapperRtuBarcodeScanner;
                SBWrapperOperations sBWrapperOperations = SBWrapperOperations.INSTANCE;
                boolean bl = false;
                $this$invoke_u24lambda_u240.createIntentAndStartActivity(activity);
                sBWrapperOperations.setBarcodeScanner$barcode_sdk_wrapper_release(sBWrapperRtuBarcodeScanner);
            }
        }, 12, null);
    }

    @Nullable
    public final Unit startBatchBarcodeScanner$barcode_sdk_wrapper_release(@NotNull Activity activity, @NotNull SdkLicenseInfo licenseInfo, @NotNull String configurationAsJSON, @Nullable SBWrapperResultDelegate resultDelegate, @NotNull ActivityResultContract<BatchBarcodeScannerConfiguration, InternalBatchBarcodeScannerActivity.InternalResult> resultContract) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)licenseInfo, (String)"licenseInfo");
        Intrinsics.checkNotNullParameter((Object)configurationAsJSON, (String)"configurationAsJSON");
        Intrinsics.checkNotNullParameter(resultContract, (String)"resultContract");
        return (Unit)SBWrapperSDKChecks.sdkFunction$default(SBWrapperSDKChecks.INSTANCE, licenseInfo, resultDelegate, false, false, (Function0)new Function0<Unit>(configurationAsJSON, resultContract, resultDelegate, activity){
            final /* synthetic */ String $configurationAsJSON;
            final /* synthetic */ ActivityResultContract<BatchBarcodeScannerConfiguration, InternalBatchBarcodeScannerActivity.InternalResult> $resultContract;
            final /* synthetic */ SBWrapperResultDelegate $resultDelegate;
            final /* synthetic */ Activity $activity;
            {
                this.$configurationAsJSON = $configurationAsJSON;
                this.$resultContract = $resultContract;
                this.$resultDelegate = $resultDelegate;
                this.$activity = $activity;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$invoke_u24lambda_u240;
                SBWrapperRtuBatchBarcodeScanner sBWrapperRtuBatchBarcodeScanner = new SBWrapperRtuBatchBarcodeScanner(BatchBarcodeScannerConfiguration.Companion.fromJson(this.$configurationAsJSON), this.$resultContract, this.$resultDelegate);
                Activity activity = this.$activity;
                SBWrapperRtuBatchBarcodeScanner sBWrapperRtuBatchBarcodeScanner2 = sBWrapperRtuBatchBarcodeScanner;
                SBWrapperOperations sBWrapperOperations = SBWrapperOperations.INSTANCE;
                boolean bl = false;
                $this$invoke_u24lambda_u240.createIntentAndStartActivity(activity);
                sBWrapperOperations.setBatchBarcodeScanner$barcode_sdk_wrapper_release(sBWrapperRtuBatchBarcodeScanner);
            }
        }, 12, null);
    }

    @JvmStatic
    public static final boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        boolean bl;
        int n = requestCode;
        SBWrapperRtuUI sBWrapperRtuUI = barcodeScanner;
        boolean bl2 = sBWrapperRtuUI != null ? n == sBWrapperRtuUI.getRequestCode() : false;
        if (bl2) {
            SBWrapperRtuBarcodeScanner sBWrapperRtuBarcodeScanner = barcodeScanner;
            if (sBWrapperRtuBarcodeScanner != null) {
                sBWrapperRtuBarcodeScanner.handleResult(resultCode, data);
            }
            barcodeScanner = null;
            bl = true;
        } else {
            sBWrapperRtuUI = batchBarcodeScanner;
            boolean bl3 = sBWrapperRtuUI != null ? n == sBWrapperRtuUI.getRequestCode() : false;
            if (bl3) {
                SBWrapperRtuBatchBarcodeScanner sBWrapperRtuBatchBarcodeScanner = batchBarcodeScanner;
                if (sBWrapperRtuBatchBarcodeScanner != null) {
                    sBWrapperRtuBatchBarcodeScanner.handleResult(resultCode, data);
                }
                batchBarcodeScanner = null;
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final Bitmap getBitmapFromImageUri(Uri imageUri2) throws Exception {
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)SBWrapper.INSTANCE.getApplication().getContentResolver(), (Uri)imageUri2);
        if (bitmap == null) {
            throw new SBWrapperExceptions.SBWrapperUriParsingError(null, 1, null);
        }
        return bitmap;
    }

    public static final /* synthetic */ Bitmap access$getBitmapFromImageUri(SBWrapperOperations $this, Uri imageUri2) {
        return $this.getBitmapFromImageUri(imageUri2);
    }
}

